/*
 * File:	wb_mgstr.cc
 * Purpose:	simple language support
 * Author:	Julian Smart
 * Created:	1993
 * Updated:	
 * Copyright:	(c) 1993, AIAI, University of Edinburgh
 */

static const char sccsid[] = "%W% %G%";


/* Uncomment for Borland/UNIX combination
#ifdef wx_msw
#include "wx.h"
#pragma hdrstop
#else

#include "wx_mgstr.h"
#endif
*/

#include "wx.h"                 // MSC 7/UNIX

char **wx_msg_str = (char**) 0;

static char *msg_english[] = {
/* wxSTR_BUTTON_OK           */      "Ok",
/* wxSTR_BUTTON_CANCEL       */      "Cancel",
/* wxSTR_BUTTON_REVERT       */      "Revert",
/* wxSTR_BUTTON_UPDATE       */      "Update",
/* wxSTR_CONSTRAINT_VIOLATION*/      "Constraint violation",
/* wxSTR_VIOLATION_FLOAT     */      "%s should be in range %.2f to %.2f",
/* wxSTR_VIOLATION_LONG      */      "%s should be in range %.0f to %.0f",
/* wxSTR_MENU_HELP           */      "Help",
/* wxSTR_BUTTON_HELP         */      "Help"
};

static char *msg_german[] = /* I don't know */ {
/* wxSTR_BUTTON_OK           */      "Ok",
/* wxSTR_BUTTON_CANCEL       */      "Abbruch",
/* wxSTR_BUTTON_REVERT       */      "Reset",
/* wxSTR_BUTTON_UPDATE       */      "Update",
/* wxSTR_CONSTRAINT_VIOLATION*/      "Wertebereich Verletzung",
/* wxSTR_VIOLATION_FLOAT     */      "%s liegt nicht im Bereich von %.2f bis %.2f",
/* wxSTR_VIOLATION_LONG      */      "%s liegt nicht im Bereich von %.0f bis %.0f",
/* wxSTR_MENU_HELP           */      "Hilfe",
/* wxSTR_BUTTON_HELP         */      "Hilfe"
};

void wxSetLanguage(int language)
{
  switch(language) {
  case wxLANGUAGE_GERMAN:
      wx_msg_str = &(msg_german[0]);
      break;
  case wxLANGUAGE_ENGLISH:
  default:
      wx_msg_str = &(msg_english[0]);
      break;
  }
}
