/*
 * File:	wb_help.cc
 * Purpose:	API for invoking wxHelp
 * Author:	Julian Smart
 * Created:	1993
 * Updated:	
 * Copyright:	(c) 1993, AIAI, University of Edinburgh
 */

static const char sccsid[] = "%W% %G%";

/* Uncomment for Borland/UNIX combination
#include "wx.h"
#pragma hdrstop
*/

#include "wx.h"                 // MSC 7/UNIX
#if USE_HELP
#include <time.h>

#ifdef wx_msw
#include <wx_privt.h>
#endif

#ifdef wx_x
#include <netdb.h>

#ifdef SUN_CC
#include <sysent.h>
#endif // SUN_CC
#ifdef __hpux
#include <sys/unistd.h>
#endif // __hpux
#endif // wx_x

// Timeout in seconds
#define WX_HELP_TIMEOUT 30

#include "wx_help.h"

wxHelpInstance::wxHelpInstance(Bool native)
{
#ifdef wx_msw
  useNative = native;
#else
  useNative = FALSE;  // Vetoed under X -- no native help system
#endif

  __type = wxTYPE_HELP_INSTANCE;
  helpFile = NULL; helpServer = -1; helpHost = NULL;
  helpRunning = FALSE; helpConnection = NULL;
}

wxHelpInstance::~wxHelpInstance(void)
{
  if (helpFile) delete[] helpFile; 
  if (helpHost) delete[] helpHost;
}

Bool wxHelpInstance::Initialize(char *filename, int server)
{
#ifdef wx_x
  char host_buf[400];
  if (wxGetHostName(host_buf, sizeof(host_buf)))
    helpHost = copystring(host_buf);
  else helpHost = NULL;
#endif
#ifdef wx_msw
  if (!useNative)
    helpHost = copystring("dummy");
#endif

  helpFile = copystring(filename);
  if (!useNative)
  {
    helpServer = server;
    wxIPCInitialize();
  }
  return TRUE;
}

Bool wxHelpInstance::LoadFile(char *file)
{
  if (!file)
    file = helpFile;
  else
  {
    if (helpFile) delete[] helpFile;
    helpFile = copystring(file);
  }

  if (!useNative)
  {
    if (!helpRunning)
    {
      if (!Run())
        return FALSE;
    }
    char buf[300];
    sprintf(buf, "f %s", file);
    if (helpConnection)
      return helpConnection->Execute(buf);
    else return FALSE;
  }
  else
  {
#ifdef wx_msw
    char buf[300];
    strcpy(buf, file);
    int len = strlen(file);
    if (!(file[len-1] == 'p' && file[len-2] == 'l' && file[len-3] == 'h' && file[len-4] == '.'))
      strcat(buf, ".hlp");
    if (wxTheApp->wx_frame)
    {
      wxWnd *wnd = (wxWnd *)(wxTheApp->wx_frame->handle);
      HWND hwnd = wnd->handle;
      WinHelp(hwnd, buf, HELP_CONTENTS, 0L);
     return TRUE;
    }
#endif
  }
  return FALSE;
}

Bool wxHelpInstance::DisplayContents(void)
{
  if (!useNative)
  {
    if (!helpRunning)
    {
      if (!Run())
        return FALSE;
    }
    if (helpConnection)
      return helpConnection->Execute("s -1");
    else return FALSE;
  }
  else
  {
#ifdef wx_msw
    if (!helpFile) return FALSE;
    
    char buf[300];
    strcpy(buf, helpFile);
    int len = strlen(helpFile);
    if (!(helpFile[len-1] == 'p' && helpFile[len-2] == 'l' && helpFile[len-3] == 'h' && helpFile[len-4] == '.'))
      strcat(buf, ".hlp");
    if (wxTheApp->wx_frame)
    {
      wxWnd *wnd = (wxWnd *)(wxTheApp->wx_frame->handle);
      HWND hwnd = wnd->handle;
      WinHelp(hwnd, buf, HELP_CONTENTS, 0L);
     return TRUE;
    }
#endif
  }
  return FALSE;
}

Bool wxHelpInstance::DisplaySection(int section)
{
  if (!useNative)
  {
    if (!helpRunning)
    {
      if (!Run())
        return FALSE;
    }
    char buf[300];
    sprintf(buf, "s %d", section);
    if (helpConnection)
      return helpConnection->Execute(buf);
    else return FALSE;
  }
  // No WinHelp equivalent for this
  return FALSE;
}

Bool wxHelpInstance::DisplayBlock(long block)
{
  if (!useNative)
  {
    if (!helpRunning)
    {
      if (!Run())
        return FALSE;
    }
    char buf[300];
    sprintf(buf, "b %l", block);
    if (helpConnection)
      return helpConnection->Execute(buf);
    else return FALSE;
  }
  else
  {
    // Use context number -- a very rough equivalent to block id!
#ifdef wx_msw
    if (!helpFile) return FALSE;
    
    char buf[300];
    strcpy(buf, helpFile);
    int len = strlen(helpFile);
    if (!(helpFile[len-1] == 'p' && helpFile[len-2] == 'l' && helpFile[len-3] == 'h' && helpFile[len-4] == '.'))
      strcat(buf, ".hlp");
    if (wxTheApp->wx_frame)
    {
      wxWnd *wnd = (wxWnd *)(wxTheApp->wx_frame->handle);
      HWND hwnd = wnd->handle;
      WinHelp(hwnd, buf, HELP_CONTEXT, (DWORD)block);
     return TRUE;
    }
#endif
  }
  return FALSE;
}

Bool wxHelpInstance::KeywordSearch(char *k)
{
  if (!useNative)
  {
    if (!helpRunning)
    {
      if (!Run())
        return FALSE;
    }
    char buf[500];
    sprintf(buf, "k %s", k);
    if (helpConnection)
      return helpConnection->Execute(buf);
    else return FALSE;
  }
  else
  {
#ifdef wx_msw
    if (!helpFile) return FALSE;

    char buf[300];
    strcpy(buf, helpFile);
    int len = strlen(helpFile);
    if (!(helpFile[len-1] == 'p' && helpFile[len-2] == 'l' && helpFile[len-3] == 'h' && helpFile[len-4] == '.'))
      strcat(buf, ".hlp");
    if (wxTheApp->wx_frame)
    {
      wxWnd *wnd = (wxWnd *)(wxTheApp->wx_frame->handle);
      HWND hwnd = wnd->handle;
      WinHelp(hwnd, buf, HELP_PARTIALKEY, (DWORD)k);
     return TRUE;
    }
#endif
  }
  return FALSE;
}

Bool wxHelpInstance::Quit(void)
{
  if (helpConnection)
    return helpConnection->Disconnect(); // Calls OnQuit via OnDisconnect
  else return TRUE;
}

void wxHelpInstance::OnQuit(void)
{
}

Bool wxHelpInstance::Run(void)
{
#ifdef wx_x
  if (!helpFile || !helpHost || helpRunning)
    return FALSE;
#endif
#ifdef wx_msw
  if (!helpFile || helpRunning)
    return FALSE;
#endif

  char buf[500];
  char buf1[100];
  time_t start_time;
  time_t current_time;

  (void)time(&current_time);

  // Invent a server name that's likely to be unique but different from
  // last time
#ifdef wx_x
  if (helpServer == -1)
    helpServer = 4000 + (current_time % 4000);
#endif
#ifdef wx_msw // Only one instance of wxHelp at a time
  helpServer = 4000;
#endif

  sprintf(buf1, "%d", helpServer);

#ifdef wx_x
  sprintf(buf, "wxhelp -server %d &", helpServer);
#endif
#ifdef wx_msw
  // Only one instance of wxHelp under Windows.
  // See if there's already an instance of wxHelp
  if (helpConnection = (wxHelpConnection *)MakeConnection(helpHost, buf1, "WXHELP"))
  {
    helpRunning = TRUE;
    return TRUE;
  }

  sprintf(buf, "wxhelp -server %d", helpServer);
#endif
  wxExecute(buf);

  (void)time(&start_time);
  (void)time(&current_time);

  // Give it some time to respond
  while (!helpConnection && ((current_time - start_time) < WX_HELP_TIMEOUT))
  {
    wxSleep(1);
    helpConnection = (wxHelpConnection *)MakeConnection(helpHost, buf1, "WXHELP");
    (void)time(&current_time);
  }

  if (helpConnection)
  {
    helpRunning = TRUE;
    return TRUE;
  }
  else
  {
    sprintf(buf, "Connection to wxHelp timed out in %d seconds", WX_HELP_TIMEOUT);
    (void)wxMessageBox(buf);
    return FALSE;
  }
}

wxHelpConnection::wxHelpConnection(wxHelpInstance *instance)
{
  helpInstance = instance;
}

Bool wxHelpConnection::OnDisconnect(void)
{
  helpInstance->OnQuit();
  helpInstance->helpRunning = FALSE;
  helpInstance->helpConnection = NULL;
  helpInstance->helpServer = -1;
  delete this;
  return TRUE;
}

#endif // USE_HELP
