/*
 * File:	wb_hash.cc
 * Purpose:	Hash table implementation
 * Author:	Julian Smart
 * Created:	1993
 * Updated:	
 * Copyright:	(c) 1993, AIAI, University of Edinburgh
 */

static const char sccsid[] = "%W% %G%";

/* Uncomment for Borland/UNIX combination
#ifdef wx_msw
#include "wx.h"
#pragma hdrstop
#else
#include "common.h"
#include "wx_list.h"
#endif
*/

#include "wx.h"         // For MSC7/UNIX combination

#include "wx_hash.h"

#include <iostream.h>
#include <string.h>
#include <stdarg.h>

wxHashTable::wxHashTable(unsigned int the_key_type, int size)
{
  __type = wxTYPE_HASH_TABLE;
  n = size;
  current_position = -1;
  current_node = NULL;

  key_type = wxKEY_NONE;
  hash_table = new wxList *[size];
  for (int i = 0; i < size; i++)
  {
    hash_table[i] = NULL;
  }
}

wxHashTable::~wxHashTable(void)
{
  for (int i = 0; i < n; i++)
    if (hash_table[i])
      delete hash_table[i];
  delete hash_table;
}

void wxHashTable::Put(long key, long value, wxObject *object)
{
  if (key < 0) key = -key;
  
  long position = key % n;
  if (!hash_table[(int)position])
    hash_table[(int)position] = new wxList(wxKEY_INTEGER);

  hash_table[(int)position]->Append(value, object);
}

void wxHashTable::Put(long key, char *value, wxObject *object)
{
  if (key < 0) key = -key;
  
  long position = key % n;
  if (!hash_table[(int)position])
    hash_table[(int)position] = new wxList(wxKEY_INTEGER);

  hash_table[(int)position]->Append(value, object);
}

void wxHashTable::Put(long key, wxObject *object)
{
  if (key < 0) key = -key;

  long position = key % n;
  if (!hash_table[(int)position])
    hash_table[(int)position] = new wxList(wxKEY_INTEGER);

  hash_table[(int)position]->Append(key, object);
}

void wxHashTable::Put(char *key, wxObject *object)
{
  long int_key = 0;
  int len = strlen(key);
  for (int i = 0; i < len; i++)
    int_key += (long)key[i];

  long position = int_key % n;
  if (!hash_table[(int)position])
    hash_table[(int)position] = new wxList(wxKEY_STRING);

  hash_table[(int)position]->Append(key, object);
}

wxObject *wxHashTable::Get(long key, long value)
{
  if (key < 0) key = -key;

  long position = key % n;
  if (!hash_table[(int)position])
    return NULL;
  else
  {
    wxNode *node = hash_table[(int)position]->Find(value);
    if (node)
      return node->Data();
    else return NULL;
  }
}

wxObject *wxHashTable::Get(long key, char *value)
{
  if (key < 0) key = -key;

  long position = key % n;
  if (!hash_table[(int)position])
    return NULL;
  else
  {
    wxNode *node = hash_table[(int)position]->Find(value);
    if (node)
      return node->Data();
    else return NULL;
  }
}

wxObject *wxHashTable::Get(long key)
{
  if (key < 0) key = -key;

  long position = key % n;
  if (!hash_table[(int)position])
    return NULL;
  else
  {
    wxNode *node = hash_table[(int)position]->Find(key);
    if (node)
      return node->Data();
    else return NULL;
  }
}

wxObject *wxHashTable::Get(char *key)
{
  long int_key = 0;
  int len = strlen(key);
  for (int i = 0; i < len; i++)
    int_key += (long)key[i];

  long position = int_key % n;
  if (!hash_table[(int)position])
    return NULL;
  else
  {
    wxNode *node = hash_table[(int)position]->Find(key);
    if (node)
      return node->Data();
    else return NULL;
  }
}

wxObject *wxHashTable::Delete(long key)
{
  if (key < 0) key = -key;

  long position = key % n;
  if (!hash_table[(int)position])
    return NULL;
  else
  {
    wxNode *node = hash_table[(int)position]->Find(key);
    if (node)
    {
      wxObject *data = node->Data();
      delete node;
      return data;
    }
    else return NULL;
  }
}

wxObject *wxHashTable::Delete(char *key)
{
  long int_key = 0;
  int len = strlen(key);
  for (int i = 0; i < len; i++)
    int_key += (long)key[i];

  long position = int_key % n;
  if (!hash_table[(int)position])
    return NULL;
  else
  {
    wxNode *node = hash_table[(int)position]->Find(key);
    if (node)
    {
      wxObject *data = node->Data();
      delete node;
      return data;
    }
    else return NULL;
  }
}

wxObject *wxHashTable::Delete(long key, int value)
{
  if (key < 0) key = -key;
  
  long position = key % n;
  if (!hash_table[(int)position])
    return NULL;
  else
  {
    wxNode *node = hash_table[(int)position]->Find(value);
    if (node)
    {
      wxObject *data = node->Data();
      delete node;
      return data;
    }
    else return NULL;
  }
}

wxObject *wxHashTable::Delete(long key, char *value)
{
  if (key < 0) key = -key;
  
  long position = key % n;
  if (!hash_table[(int)position])
    return NULL;
  else
  {
    wxNode *node = hash_table[(int)position]->Find(value);
    if (node)
    {
      wxObject *data = node->Data();
      delete node;
      return data;
    }
    else return NULL;
  }
}

long wxHashTable::MakeKey(char *string)
{
  long int_key = 0;
  int len = strlen(string);
  for (int i = 0; i < len; i++)
    int_key += (long)string[i];

  if (int_key < 0) int_key = -int_key;
  
  return int_key;
}

void wxHashTable::BeginFind(void)
{
  current_position = -1;
  current_node = NULL;
}

wxNode *wxHashTable::Next(void)
{
  wxNode *found = NULL;
  Bool end = FALSE;
  while (!end && !found)
  {
    if (!current_node)
    {
      current_position ++;
      if (current_position >= n)
      {
        current_position = -1;
        current_node = NULL;
        end = TRUE;
      }
      else
      {
        if (hash_table[current_position])
        {
          current_node = hash_table[current_position]->First();
          found = current_node;
        }
      }
    }
    else
    {
      current_node = current_node->Next();
      found = current_node;
    }
  }
  return found;
}

void wxHashTable::DeleteContents(Bool flag)
{
  for (int i = 0; i < n; i++)
  {
    if (hash_table[i])
      hash_table[i]->DeleteContents(flag);
  }
}

void wxHashTable::Clear(void)
{
  for (int i = 0; i < n; i++)
  {
    if (hash_table[i])
      hash_table[i]->Clear();
  }
}


