/*
 * File:	wb_gdi.cc
 * Purpose:	GDI (Graphics Device Interface) objects and functions
 * Author:	Julian Smart
 * Created:	1993
 * Updated:	
 * Copyright:	(c) 1993, AIAI, University of Edinburgh
 */

static const char sccsid[] = "%W% %G%";

/* Uncomment for Borland/UNIX combination
#ifdef wx_msw
#include "wx.h"
#pragma hdrstop
#else

#include "common.h"
#include "wx_list.h"
#include "wx_utils.h"
#include "wx_main.h"
#include "wx_gdi.h"
#endif
*/
#include "wx.h"                         // MSC 7/UNIX
#include <iostream.h>

wxBrushList *wxTheBrushList = NULL;
wxPenList   *wxThePenList = NULL;
wxGDIList   *wxTheIconList = NULL;
wxFontList   *wxTheFontList = NULL;
wxGDIList   *wxTheBitmapList = NULL;
wxGDIList   *wxTheCursorList = NULL;

wxColourDatabase *wxTheColourDatabase = NULL;

// Stock objects
wxFont *wxNORMAL_FONT;
wxFont *wxSMALL_FONT;
wxFont *wxITALIC_FONT;
wxFont *wxSWISS_FONT;
wxPen *wxRED_PEN;

wxPen *wxCYAN_PEN;
wxPen *wxGREEN_PEN;
wxPen *wxBLACK_PEN;
wxPen *wxWHITE_PEN;
wxPen *wxTRANSPARENT_PEN;
wxPen *wxBLACK_DASHED_PEN;
wxPen *wxGREY_PEN;
wxPen *wxMEDIUM_GREY_PEN;
wxPen *wxLIGHT_GREY_PEN;

wxBrush *wxBLUE_BRUSH;
wxBrush *wxGREEN_BRUSH;
wxBrush *wxWHITE_BRUSH;
wxBrush *wxBLACK_BRUSH;
wxBrush *wxTRANSPARENT_BRUSH;
wxBrush *wxCYAN_BRUSH;
wxBrush *wxRED_BRUSH;
wxBrush *wxGREY_BRUSH;
wxBrush *wxMEDIUM_GREY_BRUSH;
wxBrush *wxLIGHT_GREY_BRUSH;

wxColour *wxBLACK;
wxColour *wxWHITE;
wxColour *wxRED;
wxColour *wxBLUE;
wxColour *wxGREEN;
wxColour *wxCYAN;
wxColour *wxLIGHT_GREY;

wxCursor *wxSTANDARD_CURSOR = NULL;
wxCursor *wxHOURGLASS_CURSOR = NULL;
wxCursor *wxCROSS_CURSOR = NULL;

wxbFont::wxbFont(void)
{
  __type = wxTYPE_FONT;
}

/* Constructor for a font. Note that the real construction is done
 * in wxDC::SetFont, when information is available about scaling etc.
 */
wxbFont::wxbFont(int PointSize, int Family, int Style, int Weight, Bool Underline)
{
  __type = wxTYPE_FONT;
}

wxbFont::~wxbFont()
{
}

// Colour

wxColour::wxColour(void)
{
  __type = wxTYPE_COLOUR;
  isInit = FALSE ;
#ifdef wx_x
  pixel = -1;
#endif
#ifdef wx_msw
  pixel = 0 ;
#endif
}

wxColour::wxColour(unsigned char r, unsigned char g, unsigned char b)
{
  __type = wxTYPE_COLOUR;
  red = r; green = g; blue = b;
  isInit = TRUE;
#ifdef wx_x
  pixel = -1;
#endif
#ifdef wx_msw
  pixel = RGB(red,green,blue) ;
#endif
}

wxColour::wxColour(char *col)
{
  __type = wxTYPE_COLOUR;
  wxColour *the_colour = wxTheColourDatabase->FindColour(col);
  if (the_colour)
  {
    red = the_colour->Red(); green = the_colour->Green();
    blue = the_colour->Blue();
    isInit = TRUE;
  }
  else
  {
    red = 0; green = 0; blue = 0;
    isInit = FALSE;
  }
#ifdef wx_x
  pixel = -1;
#endif
#ifdef wx_msw
  pixel = RGB(red,green,blue) ;
#endif
}

wxColour& wxColour:: operator =(wxColour& src)
{
  red = src.red ;
  green = src.green ;
  blue = src.blue ;
  pixel = src.pixel;
  isInit = src.isInit ;
  return(*this) ;
}


void wxColour::Set(unsigned char r, unsigned char g, unsigned char b)
{
  red = r; green = g; blue = b;
  isInit = TRUE;
#ifdef wx_x
  pixel = -1;
#endif
#ifdef wx_msw
    pixel = RGB(red,green,blue) ;
#endif
}

void wxColour::Get(unsigned char *r, unsigned char *g, unsigned char *b)
{
  *r = red; *g = green; *b = blue;
}

/*
 * Colour map
 *
 */

wxbColourMap::wxbColourMap(void)
{
}

wxbColourMap::~wxbColourMap(void)
{
}

wxColourDatabase::wxColourDatabase(int type):wxList(type)
{
}

wxColourDatabase::~wxColourDatabase(void)
{
  // Cleanup Colour allocated in Initialize()
  wxNode *node = First();
  while (node)
  {
    wxColour *col = (wxColour *)node->Data();
    wxNode *next = node->Next();
    delete col;
    node = next;
  }
}

// Colour database stuff
// COLOURS NOW IN LINE WITH WINDOWS 3.1 BASIC COLOURS
void wxColourDatabase::Initialize(void)
{
  Append("AQUAMARINE"       , new wxColour(112, 219, 147));
  Append("BLACK"            , new wxColour(0, 0, 0));
// #ifdef wx_msw
//   Append("BLUE"             , new wxColour(0, 0, 128));
// #else
  Append("BLUE"             , new wxColour(0, 0, 255));
// #endif
  Append("BLUE VIOLET"      , new wxColour(159, 95, 159));
// #ifdef wx_msw
//   Append("BROWN"            , new wxColour(128, 128, 0));
// #else
  Append("BROWN"            , new wxColour(165, 42, 42));
// #endif
  Append("CADET BLUE"       , new wxColour(95, 159, 159));
  Append("CORAL"            , new wxColour(255, 127, 0));
  Append("CORNFLOWER BLUE"  , new wxColour(66, 66, 111));
// #ifdef wx_msw
//   Append("CYAN"             , new wxColour(0, 128, 128));
// #else
  Append("CYAN"             , new wxColour(0, 255, 255));
// #endif
  Append("DARK GREY"        , new wxColour(47, 47, 47));  // ?
  Append("DARK GREEN"       , new wxColour(47, 79, 47));
  Append("DARK OLIVE GREEN" , new wxColour(79, 79, 47));
  Append("DARK ORCHID"      , new wxColour(153, 50, 204));
  Append("DARK SLATE BLUE"  , new wxColour(107, 35, 142));
  Append("DARK SLATE GREY"  , new wxColour(47, 79, 79));
  Append("DARK TURQUOISE"   , new wxColour(112, 147, 219));
  Append("DIM GREY"         , new wxColour(84, 84, 84));
  Append("FIREBRICK"        , new wxColour(142, 35, 35));
  Append("FOREST GREEN"     , new wxColour(35, 142, 35));
  Append("GOLD"             , new wxColour(204, 127, 50));
  Append("GOLDENROD"        , new wxColour(219, 219, 112));
#ifdef wx_msw
  Append("GREY"             , new wxColour(128, 128, 128));
#else
  Append("GREY"             , new wxColour(192, 192, 192));
#endif
// #ifdef wx_msw
//   Append("GREEN"            , new wxColour(0, 128, 0));
// #else
  Append("GREEN"            , new wxColour(0, 255, 0));
// #endif
  Append("GREEN YELLOW"     , new wxColour(147, 219, 112));
  Append("INDIAN RED"       , new wxColour(79, 47, 47));
  Append("KHAKI"            , new wxColour(159, 159, 95));
// #ifdef wx_msw
//   Append("LIGHT BLUE"       , new wxColour(0, 0, 255));
// #else
  Append("LIGHT BLUE"       , new wxColour(191, 216, 216));
// #endif
#ifdef wx_msw
  Append("LIGHT GREY"       , new wxColour(192, 192, 192));
#else
  Append("LIGHT GREY"       , new wxColour(168, 168, 168));
#endif
  Append("LIGHT STEEL BLUE" , new wxColour(143, 143, 188));
  Append("LIME GREEN"       , new wxColour(50, 204, 50));
  Append("LIGHT GREEN"       , new wxColour(0, 255, 0));
  Append("LIGHT CYAN"       , new wxColour(0, 255, 255));
  Append("LIGHT RED"       , new wxColour(255, 0, 0));
  Append("LIGHT MAGENTA"       , new wxColour(255, 0, 255));
// #ifdef wx_msw
//   Append("MAGENTA"          , new wxColour(128, 0, 128));
// #else
  Append("MAGENTA"          , new wxColour(255, 0, 255));
// #endif
  Append("MAROON"           , new wxColour(142, 35, 107));
  Append("MEDIUM AQUAMARINE" , new wxColour(50, 204, 153));
  Append("MEDIUM GREY" , new wxColour(100, 100, 100));
  Append("MEDIUM BLUE"      , new wxColour(50, 50, 204));
  Append("MEDIUM FOREST GREEN" , new wxColour(107, 142, 35));
  Append("MEDIUM GOLDENROD" , new wxColour(234, 234, 173));
  Append("MEDIUM ORCHID"    , new wxColour(147, 112, 219));
  Append("MEDIUM SEA GREEN" , new wxColour(66, 111, 66));
  Append("MEDIUM SLATE BLUE" , new wxColour(127, 0, 255));
  Append("MEDIUM SPRING GREEN" , new wxColour(127, 255, 0));
  Append("MEDIUM TURQUOISE" , new wxColour(112, 219, 219));
  Append("MEDIUM VIOLET RED" , new wxColour(219, 112, 147));
  Append("MIDNIGHT BLUE"    , new wxColour(47, 47, 79));
  Append("NAVY"             , new wxColour(35, 35, 142));
  Append("ORANGE"           , new wxColour(204, 50, 50));
  Append("ORANGE RED"       , new wxColour(255, 0, 127));
  Append("ORCHID"           , new wxColour(219, 112, 219));
  Append("PALE GREEN"       , new wxColour(143, 188, 143));
  Append("PINK"             , new wxColour(188, 143, 234));
  Append("PLUM"             , new wxColour(234, 173, 234));
  Append("PURPLE"           , new wxColour(176, 0, 255));
// #ifdef wx_msw
//   Append("RED"              , new wxColour(128, 0, 0));
// #else
  Append("RED"              , new wxColour(255, 0, 0));
// #endif
  Append("SALMON"           , new wxColour(111, 66, 66));
  Append("SEA GREEN"        , new wxColour(35, 142, 107));
  Append("SIENNA"           , new wxColour(142, 107, 35));
  Append("SKY BLUE"         , new wxColour(50, 153, 204));
  Append("SLATE BLUE"       , new wxColour(0, 127, 255));
  Append("SPRING GREEN"     , new wxColour(0, 255, 127));
  Append("STEEL BLUE"       , new wxColour(35, 107, 142));
  Append("TAN"              , new wxColour(219, 147, 112));
  Append("THISTLE"          , new wxColour(216, 191, 216));
  Append("TURQUOISE"        , new wxColour(173, 234, 234));
  Append("VIOLET"           , new wxColour(79, 47, 79));
  Append("VIOLET RED"       , new wxColour(204, 50, 153));
  Append("WHEAT"            , new wxColour(216, 216, 191));
  Append("WHITE"            , new wxColour(255, 255, 255));
  Append("YELLOW"           , new wxColour(255, 255, 0));
  Append("YELLOW GREEN"     , new wxColour(153, 204, 50));
}

wxColour *wxColourDatabase::FindColour(char *colour)
{
  wxNode *node = Find(colour);
  if (node)
    return (wxColour *)node->Data();
  else
    return NULL;
}

char *wxColourDatabase::FindName(wxColour& colour)
{
  wxNode *node = First();
  char *found = NULL;
  unsigned char red = colour.Red();
  unsigned char green = colour.Green();
  unsigned char blue = colour.Blue();
  while (node && !found)
  {
    wxColour *col = (wxColour *)node->Data();
    if (col->Red() == red && col->Green() == green && col->Blue() == blue)
      found = node->key.string;
    else
      node = node->Next();
  }
  return found;
}


void wxInitializeStockObjects(void)
{
  wxTheBrushList = new wxBrushList;
  wxThePenList = new wxPenList;
  wxTheIconList = new wxGDIList;
  wxTheFontList =  new wxFontList;
  wxTheBitmapList =  new wxGDIList;
  wxTheCursorList =  new wxGDIList;

#ifdef wx_motif
#endif
#ifdef wx_x
  wxFontPool = new XFontPool;
#endif

  wxNORMAL_FONT = new wxFont(12, wxMODERN, wxNORMAL, wxNORMAL);
  wxSMALL_FONT = new wxFont(10, wxSWISS, wxNORMAL, wxNORMAL);
  wxITALIC_FONT = new wxFont(12, wxROMAN, wxITALIC, wxNORMAL);
  wxSWISS_FONT = new wxFont(12, wxSWISS, wxNORMAL, wxNORMAL);

  wxRED_PEN = new wxPen("RED", 3, wxSOLID);
  wxCYAN_PEN = new wxPen("CYAN", 3, wxSOLID);
  wxGREEN_PEN = new wxPen("GREEN", 1, wxSOLID);
  wxBLACK_PEN = new wxPen("BLACK", 1, wxSOLID);
  wxWHITE_PEN = new wxPen("WHITE", 1, wxSOLID);
  wxTRANSPARENT_PEN = new wxPen("BLACK", 1, wxTRANSPARENT);
  wxBLACK_DASHED_PEN = new wxPen("BLACK", 1, wxSHORT_DASH);
  wxGREY_PEN = new wxPen("GREY", 1, wxSOLID);
  wxMEDIUM_GREY_PEN = new wxPen("MEDIUM GREY", 1, wxSOLID);
  wxLIGHT_GREY_PEN = new wxPen("LIGHT GREY", 1, wxSOLID);

  wxBLUE_BRUSH = new wxBrush("BLUE", wxSOLID);
  wxGREEN_BRUSH = new wxBrush("GREEN", wxSOLID);
  wxWHITE_BRUSH = new wxBrush("WHITE", wxSOLID);
  wxBLACK_BRUSH = new wxBrush("BLACK", wxSOLID);
  wxTRANSPARENT_BRUSH = new wxBrush("BLACK", wxTRANSPARENT);
  wxCYAN_BRUSH = new wxBrush("CYAN", wxSOLID);
  wxRED_BRUSH = new wxBrush("RED", wxSOLID);
  wxGREY_BRUSH = new wxBrush("GREY", wxSOLID);
  wxMEDIUM_GREY_BRUSH = new wxBrush("MEDIUM GREY", wxSOLID);
  wxLIGHT_GREY_BRUSH = new wxBrush("LIGHT GREY", wxSOLID);

  wxBLACK = new wxColour("BLACK");
  wxWHITE = new wxColour("WHITE");
  wxRED = new wxColour("RED");
  wxBLUE = new wxColour("BLUE");
  wxGREEN = new wxColour("GREEN");
  wxCYAN = new wxColour("CYAN");
  wxLIGHT_GREY = new wxColour("LIGHT GREY");

  wxSTANDARD_CURSOR = new wxCursor(wxCURSOR_ARROW);
  wxHOURGLASS_CURSOR = new wxCursor(wxCURSOR_WAIT);
  wxCROSS_CURSOR = new wxCursor(wxCURSOR_CROSS);
}

void wxDeleteStockObjects(void)
{
  if (wxBLACK)
    delete wxBLACK ;
  if (wxWHITE)
    delete wxWHITE ;
  if (wxRED)
    delete wxRED ;
  if (wxBLUE)
    delete wxBLUE ;
  if (wxGREEN)
    delete wxGREEN ;
  if (wxCYAN)
    delete wxCYAN ;
  if (wxLIGHT_GREY)
    delete wxLIGHT_GREY ;

  if (wxSTANDARD_CURSOR)
    delete wxSTANDARD_CURSOR ;
  if (wxHOURGLASS_CURSOR)
    delete wxHOURGLASS_CURSOR ;
  if (wxCROSS_CURSOR)
    delete wxCROSS_CURSOR ;
}

// Pens

wxbPen::wxbPen(void)
{
  __type = wxTYPE_PEN;
}

wxbPen::~wxbPen()
{
}

wxbPen::wxbPen(wxColour& col, int Width, int Style)
{
  __type = wxTYPE_PEN;
}

wxbPen::wxbPen(char *col, int Width, int Style)
{
  __type = wxTYPE_PEN;
}

int wxbPen::GetWidth(void)
{
  return width;
}

int wxbPen::GetStyle(void)
{
  return style;
}

int wxbPen::GetJoin(void)
{
  return join;
}

wxBitmap* wxbPen::GetStipple(void)
{
  return stipple;
}

int wxbPen::GetCap(void)
{
  return cap;
}

int wxbPen::GetDashes(wxDash **ptr)
{
  *ptr = dash ;
  return nb_dash;
}

wxColour& wxbPen::GetColour(void)
{
  return *colour;
}

void wxbPen::SetColour(wxColour& col)
{
  // Must allocate BEFORE deleting, since &col can be a ref to this->colour!
  wxColour *newcol = new wxColour() ;
  *newcol = col ;
  if (colour)
    delete colour;
  colour = newcol ;
}

void wxbPen::SetColour(char *col)
{
  if (colour)
    delete colour;
  colour = new wxColour(col);
}

void wxbPen::SetColour(char red, char green, char blue)
{
  if (colour)
    delete colour;
  colour = new wxColour(red, green, blue);
}

void wxbPen::SetWidth(int Width)
{
  width = Width;
}

void wxbPen::SetCap(int Cap)
{
  cap = Cap ;
}

void wxbPen::SetJoin(int Join)
{
  join = Join ;
}

void wxbPen::SetStyle(int Style)
{
  style = Style;
}

void wxbPen::SetDashes(int nbDash, wxDash *Dash)
{
  nb_dash = nbDash ;
  dash = Dash ;
}

void wxbPen::SetStipple(wxBitmap *Stipple)
{
  stipple = Stipple ;
}

// Brushes

wxbBrush::wxbBrush(void)
{
  __type = wxTYPE_BRUSH;
}

wxbBrush::~wxbBrush()
{
}

wxbBrush::wxbBrush(wxColour& col, int Style)
{
  __type = wxTYPE_BRUSH;
}

wxbBrush::wxbBrush(char *col, int Style)
{
  __type = wxTYPE_BRUSH;
}

int wxbBrush::GetStyle(void)
{
  return style;
}

wxBitmap* wxbBrush::GetStipple(void)
{
  return stipple;
}

wxColour& wxbBrush::GetColour(void)
{
  return *colour;
}

void wxbBrush::SetColour(wxColour& col)
{
  // Must allocate BEFORE deleting, since &col can be a ref to this->colour!
  wxColour *newcol = new wxColour() ;
  *newcol = col ;
  if (colour)
    delete colour;
  colour = newcol ;
}

void wxbBrush::SetColour(char *col)
{
  if (colour)
    delete colour;
  colour = new wxColour(col);
}

void wxbBrush::SetColour(char red, char green, char blue)
{
  if (colour)
    delete colour;
  colour = new wxColour(red, green, blue);
}

void wxbBrush::SetStyle(int Style)
{
  style = Style;
}

void wxbBrush::SetStipple(wxBitmap *Stipple)
{
  stipple = Stipple ;
}

// Icons
wxbIcon::wxbIcon(void)
{
  __type = wxTYPE_ICON;
}

wxbIcon::wxbIcon(char bits[], int width, int height)
{
  __type = wxTYPE_ICON;
}

wxbIcon::wxbIcon(char *icon_file)
{
  __type = wxTYPE_ICON;
}

wxbIcon::~wxbIcon(void)
{
}

wxGDIList::wxGDIList(void)
{
}

wxGDIList::~wxGDIList(void)
{
  wxNode *node = First();
  while (node)
  {
    wxObject *object = (wxObject *)node->Data();
    wxNode *next = node->Next();
    delete object;
    node = next;
  }
}

// Cursors
// NB Should delete loaded Windows cursors with DestroyCursor!!!
wxbCursor::wxbCursor(char bits[], int width, int height)
{
  __type = wxTYPE_CURSOR;
}

wxbCursor::wxbCursor(void)
{
  __type = wxTYPE_CURSOR;
}

wxbCursor::wxbCursor(char *cursor_file)
{
  __type = wxTYPE_CURSOR;
}

// Cursors by stock number
wxbCursor::wxbCursor(int cursor_type)
{
  __type = wxTYPE_CURSOR;
}

wxbCursor::~wxbCursor(void)
{
}

// Pen and Brush lists
wxPenList::~wxPenList(void)
{
  wxNode *node = First();
  while (node)
  {
    wxPen *pen = (wxPen *)node->Data();
    wxNode *next = node->Next();
    delete pen;
    node = next;
  }
}

void wxPenList::AddPen(wxPen *pen)
{
  Append(pen);
}

void wxPenList::RemovePen(wxPen *pen)
{
  DeleteObject(pen);
}

wxPen *wxPenList::FindOrCreatePen(wxColour *colour, int width, int style)
{
  wxPen *found = NULL;
  wxNode *node = First();
  while (node && !found)
  {
    wxPen *each_pen = (wxPen *)node->Data();
    if (each_pen->GetWidth() == width && each_pen->GetStyle() == style &&
        each_pen->GetColour().Red() == colour->Red() &&
        each_pen->GetColour().Green() == colour->Green() &&
        each_pen->GetColour().Blue() == colour->Blue())
      found = each_pen;
    node = node->Next();
  }
  if (found)
    return found;
  else
    return new wxPen(*colour, width, style);
}

wxPen *wxPenList::FindOrCreatePen(char *colour, int width, int style)
{
  wxColour *the_colour = wxTheColourDatabase->FindColour(colour);
  if (colour)
    return FindOrCreatePen(the_colour, width, style);
  else return NULL;
}

wxBrushList::~wxBrushList(void)
{
  wxNode *node = First();
  while (node)
  {
    wxBrush *brush = (wxBrush *)node->Data();
    wxNode *next = node->Next();
    delete brush;
    node = next;
  }
}

void wxBrushList::AddBrush(wxBrush *brush)
{
  Append(brush);
}

wxBrush *wxBrushList::FindOrCreateBrush(wxColour *colour, int style)
{
  wxBrush *found = NULL;
  wxNode *node = First();
  while (node && !found)
  {
    wxBrush *each_brush = (wxBrush *)node->Data();
    if (each_brush->GetStyle() == style &&
        each_brush->GetColour().Red() == colour->Red() &&
        each_brush->GetColour().Green() == colour->Green() &&
        each_brush->GetColour().Blue() == colour->Blue())
      found = each_brush;
    node = node->Next();
  }
  if (found)
    return found;
  else
    return new wxBrush(*colour, style);
}

wxBrush *wxBrushList::FindOrCreateBrush(char *colour, int style)
{
  wxColour *the_colour = wxTheColourDatabase->FindColour(colour);
  if (colour)
    return FindOrCreateBrush(the_colour, style);
  else return NULL;
}


void wxBrushList::RemoveBrush(wxBrush *brush)
{
  DeleteObject(brush);
}

wxFontList::~wxFontList(void)
{
  wxNode *node = First();
  while (node)
  {
    wxFont *font = (wxFont *)node->Data();
    wxNode *next = node->Next();
    delete font;
    node = next;
  }
}

void wxFontList::AddFont(wxFont *font)
{
  Append(font);
}

void wxFontList::RemoveFont(wxFont *font)
{
  DeleteObject(font);
}

wxFont *wxFontList::FindOrCreateFont(int PointSize, int Family, int Style, int Weight, Bool underline)
{
  wxFont *found = NULL;
  wxNode *node = First();
  while (node && !found)
  {
    wxFont *each_font = (wxFont *)node->Data();
    if ((each_font->GetPointSize() == PointSize) &&
        (each_font->GetStyle() == Style) &&
        (each_font->GetWeight() == Weight) &&
        (each_font->GetFamily() == Family) &&
        (each_font->GetUnderlined() == underline))
      found = each_font;
    node = node->Next();
  }
  if (found)
    return found;
  else
    return new wxFont(PointSize, Family, Style, Weight, underline);
}

#if (!USE_TYPEDEFS)
wxPoint::wxPoint(void)
{
}

wxPoint::wxPoint(float the_x, float the_y)
{
  x = the_x;
  y = the_y;
}

wxPoint::~wxPoint(void)
{
}
#endif

#if (!USE_TYPEDEFS)
wxIntPoint::wxIntPoint(void)
{
}

wxIntPoint::wxIntPoint(int the_x, int the_y)
{
  x = the_x;
  y = the_y;
}

wxIntPoint::~wxIntPoint(void)
{
}
#endif

wxbBitmap::wxbBitmap(char bits[], int the_width, int the_height, int no_bits)
{
  __type = wxTYPE_BITMAP;
}

wxbBitmap::wxbBitmap(char *bitmap_file)
{
  __type = wxTYPE_BITMAP;
}

wxbBitmap::wxbBitmap(int w, int h, int d)
{
  __type = wxTYPE_BITMAP;
}

wxbBitmap::~wxbBitmap(void)
{
}
