/*
 * File:	wb_dialg.cc
 * Purpose:	wxDialogBox and miscellaneous dialog functions
 * Author:	Julian Smart
 * Created:	1993
 * Updated:	
 * Copyright:	(c) 1993, AIAI, University of Edinburgh
 */

static const char sccsid[] = "%W% %G%";

/* Uncomment for Borland/UNIX combination
#ifdef wx_msw
#include "wx.h"
#pragma hdrstop
#else

#include "common.h"
#include "wx_dialg.h"
#include "wx_utils.h"
#include "wx_frame.h"
#include "wx_panel.h"
#include "wx_item.h"
#include "wx_buttn.h"
#include "wx_messg.h"
#include "wx_choic.h"
#include "wx_check.h"
#include "wx_menu.h"
#include "wx_txt.h"
#include "wx_mtxt.h"
#include "wx_slidr.h"
#include "wx_lbox.h"
#endif
*/

#include "wx.h"                 // MSC 7/UNIX
#include <iostream.h>
#include <stdio.h>

#define wxDIALOG_DEFAULT_X 300
#define wxDIALOG_DEFAULT_Y 300

// Dialog box - like panel but doesn't need a frame, and is modal or
// non-modal

wxbDialogBox::wxbDialogBox(void)
{
  __type = wxTYPE_DIALOG_BOX;
}

wxbDialogBox::wxbDialogBox(wxFrame *Parent, char *Title, Bool Modal, 
                         int x, int y, int width, int height, int style, char *name):
  wxPanel()
{
  __type = wxTYPE_DIALOG_BOX;
}

Bool wxbDialogBox::Create(wxFrame *Parent, char *Title, Bool Modal, 
                         int x, int y, int width, int height, int style, char *name)
{
  if (!Parent)
    wxTopLevelWindows.Append(this);
  return TRUE;
}

wxbDialogBox::~wxbDialogBox()
{
  wxTopLevelWindows.DeleteObject(this);
}

void wxbDialogBox::Centre(int direction)
{
  int display_width, display_height, width, height, x, y;
  wxDisplaySize(&display_width, &display_height);

  GetSize(&width, &height);
  GetPosition(&x, &y);

  if (direction == wxBOTH || direction == wxHORIZONTAL)
    x = (int)((display_width - width)/2);
  if (direction == wxBOTH || direction == wxVERTICAL)
    y = (int)((display_height - height)/2);

  SetSize(x, y, width, height);
}


/*
 * Common dialogs code
 *
 */

/*
 * Message centring code
 *
 */

void wxSplitMessage(char *message, wxList *messageList, wxPanel *panel)
{
  char *copyMessage = copystring(message);
  int i = 0;
  int len = strlen(copyMessage);
  char *currentMessage = copyMessage;
  while (i < len)
  {
    while ((i < len) && (copyMessage[i] != '\n')) i ++;
    if (i < len) copyMessage[i] = 0;
    wxMessage *mess = new wxMessage(panel, currentMessage);
    messageList->Append(mess);
    panel->NewLine();

    currentMessage = copyMessage + i + 1;
  }
  delete[] copyMessage;
}

void wxCentreMessage(wxList *messageList)
{
  // Do the message centering
  wxNode *node = messageList->First();
  while (node)
  {
    wxMessage *mess = (wxMessage *)node->Data();
    mess->Centre();
    node = node->Next();
  }
}


/*
 * A general purpose dialog box with an OnClose that returns TRUE.
 *
 */

class wxMessageBoxDialog: public wxDialogBox
{
 public:
  wxText *textItem;
  wxListBox *listBoxItem;
  static char *textAnswer;
  static char *listSelection;
  static char *listClientSelection;
  static int listPosition;
  static int buttonPressed;
  
  wxMessageBoxDialog(wxFrame *parent, char *caption, Bool modal, int x, int y,
    int w, int h, int type):
   wxDialogBox(parent, caption, modal, x, y, w, h, type)
 {
   textItem = NULL;
   listBoxItem = NULL;
   buttonPressed = wxCANCEL;
 }
 Bool OnClose(void)
 {
   return TRUE;
 }
};

char *wxMessageBoxDialog::textAnswer = NULL;
char *wxMessageBoxDialog::listSelection = NULL;
char *wxMessageBoxDialog::listClientSelection = NULL;
int wxMessageBoxDialog::listPosition = 0;
int wxMessageBoxDialog::buttonPressed = wxCANCEL;

void wxDialogOkButton(wxButton& but, wxEvent& event)
{
  wxPanel *panel = (wxPanel *)but.GetParent();
  // There is a possibility that buttons belong to a sub panel.
  // So, we must search the dialog.
  while (!wxSubType(panel->__type,wxTYPE_DIALOG_BOX))
    panel = (wxPanel*) panel->GetParent() ;

  wxMessageBoxDialog *dialog = (wxMessageBoxDialog *)panel;
  if (dialog->textItem)
  {
    if (dialog->textAnswer)
      delete[] dialog->textAnswer;
    dialog->textAnswer = copystring(dialog->textItem->GetValue());
  }
  if (dialog->listBoxItem)
  {
    if (dialog->listSelection)
      delete[] dialog->listSelection;
    dialog->listSelection = (dialog->listBoxItem->GetStringSelection() ?
                             copystring(dialog->listBoxItem->GetStringSelection()) : NULL);
    dialog->listPosition = dialog->listBoxItem->GetSelection();
    dialog->listClientSelection = dialog->listBoxItem->wxListBox::GetClientData(dialog->listPosition);
  }

  dialog->buttonPressed = wxOK;
  dialog->Show(FALSE);
  delete dialog;
}

void wxDialogCancelButton(wxButton& but, wxEvent& event)
{
  wxDialogBox *dialog = (wxDialogBox *)but.GetParent();
  // There is a possibility that buttons belong to a sub panel.
  // So, we must search the dialog.
  while (!wxSubType(dialog->__type,wxTYPE_DIALOG_BOX))
    dialog = (wxDialogBox*) ((wxPanel*)dialog)->GetParent() ;

  dialog->Show(FALSE);
  delete dialog;
}

void wxDialogYesButton(wxButton& but, wxEvent& event)
{
  wxPanel *panel = (wxPanel *)but.GetParent();
  // There is a possibility that buttons belong to a sub panel.
  // So, we must search the dialog.
  while (!wxSubType(panel->__type,wxTYPE_DIALOG_BOX))
    panel = (wxPanel*) panel->GetParent() ;

  wxMessageBoxDialog *dialog = (wxMessageBoxDialog *)panel;
  dialog->buttonPressed = wxYES;
  dialog->Show(FALSE);
  delete dialog;
}

void wxDialogNoButton(wxButton& but, wxEvent& event)
{
  wxPanel *panel = (wxPanel *)but.GetParent();
  // There is a possibility that buttons belong to a sub panel.
  // So, we must search the dialog.
  while (!wxSubType(panel->__type,wxTYPE_DIALOG_BOX))
    panel = (wxPanel*) panel->GetParent() ;

  wxMessageBoxDialog *dialog = (wxMessageBoxDialog *)panel;
  dialog->buttonPressed = wxNO;
  dialog->Show(FALSE);
  delete dialog;
}


/*
 * BUGBUG Julian Smart 12/93
 * define USE_PANEL_IN_PANEL
 * if you dare use panel in panel for dialogs; I can't
 * get it to work without absolute positioning, because
 * wxItem::SetSize DOES NOT WORK (try the hello.cc About box.
 *
 */

// Return NULL if cancel pressed
char *wxGetTextFromUser(char *message, char *caption, char *default_value,
                        wxFrame *parent, int x, int y, Bool centre)
{
// Do not use ABSOLUTE until subpanels work with this mode!

#if USE_PANEL_IN_PANEL
  wxMessageBoxDialog *dialog = new wxMessageBoxDialog(parent, caption, TRUE, x, y);
#else
  wxMessageBoxDialog *dialog = new wxMessageBoxDialog(parent, caption, TRUE, x, y, 500, 160, wxABSOLUTE_POSITIONING);
#endif

  wxList messageList;
  wxSplitMessage(message, &messageList, dialog);

  dialog->NewLine();

  dialog->textItem = new wxText(dialog, NULL, NULL, default_value, -1, -1, 320);
  dialog->NewLine();

#if (!defined(wx_xview) && USE_PANEL_IN_PANEL)
  wxPanel *but_panel = new wxPanel(dialog) ;
#else
  // Until sub panels work in XView mode
  wxPanel *but_panel = dialog ;
#endif

  wxButton *ok = new wxButton(but_panel, (wxFunction)&wxDialogOkButton, "OK");
  (void)new wxButton(but_panel, (wxFunction)&wxDialogCancelButton, "Cancel");

  ok->SetDefault();
  dialog->textItem->SetFocus();

#if (!defined(wx_xview) && USE_PANEL_IN_PANEL)
  but_panel->Fit() ;
#endif
  dialog->Fit();
#ifndef wx_xview
  but_panel->Centre(wxHORIZONTAL) ;
#endif

  if (centre)
    wxCentreMessage(&messageList);

  if ((x < 0) && (y < 0))
    dialog->Centre(wxBOTH);
  else if (x < 0)
    dialog->Centre(wxHORIZONTAL);
  else if (y < 0)
    dialog->Centre(wxVERTICAL);

  dialog->Show(TRUE);

  if (wxMessageBoxDialog::buttonPressed == wxOK)
    return wxMessageBoxDialog::textAnswer;
  else
    return NULL;
}


char *wxGetSingleChoice(char *message, char *caption, int n, char *choices[],
                        wxFrame *parent, int x, int y, Bool centre, int width, int height)
{
// Do not use ABSOLUTE until subpanels work with this mode!

#if (!USE_PANEL_IN_PANEL)
  wxMessageBoxDialog *dialog = new wxMessageBoxDialog(parent, caption, TRUE, x, y, 300, 250, wxABSOLUTE_POSITIONING);
#else
  wxMessageBoxDialog *dialog = new wxMessageBoxDialog(parent, caption, TRUE, x, y);
#endif

  wxList messageList;
  wxSplitMessage(message, &messageList, dialog);

  dialog->NewLine();

  dialog->listBoxItem = new wxListBox(dialog, NULL, NULL, wxSINGLE,
                     -1, -1, width, height, n, choices);

  dialog->NewLine();
#if (!defined(wx_xview) && USE_PANEL_IN_PANEL)
  wxPanel *but_panel = new wxPanel(dialog) ;
#else
  // Until sub panels work in XView mode
  wxPanel *but_panel = dialog ;
#endif

  wxButton *ok = new wxButton(but_panel, (wxFunction)&wxDialogOkButton, "OK");
  (void)new wxButton(but_panel, (wxFunction)&wxDialogCancelButton, "Cancel");
  // must call SetDefault AFTER creating all buttons of the subPanel
  // (see comment in x/wx_item.cc)
  ok->SetDefault();

#if (!defined(wx_xview) && USE_PANEL_IN_PANEL)
  but_panel->Fit() ;
#endif
  dialog->Fit();
#if (!defined(wx_xview) && USE_PANEL_IN_PANEL)
  but_panel->Centre(wxHORIZONTAL) ;
#endif

  if (centre)
    wxCentreMessage(&messageList);

  if ((x < 0) && (y < 0))
    dialog->Centre(wxBOTH);
  else if (x < 0)
    dialog->Centre(wxHORIZONTAL);
  else if (y < 0)
    dialog->Centre(wxVERTICAL);

  dialog->Show(TRUE);

  if (wxMessageBoxDialog::buttonPressed == wxOK)
  {
    if (wxMessageBoxDialog::listPosition >= 0)
      return wxMessageBoxDialog::listSelection;
    else return NULL;
  }
  else
    return NULL;
}

int wxGetSingleChoiceIndex(char *message, char *caption, int n, char *choices[],
                           wxFrame *parent, int x, int y, Bool centre,
                           int width, int height)
{
// Do not use ABSOLUTE until subpanels work with this mode!
#if (!USE_PANEL_IN_PANEL)
  wxMessageBoxDialog *dialog = new wxMessageBoxDialog(parent, caption, TRUE, x, y, 300, 250, wxABSOLUTE_POSITIONING);
#else
  wxMessageBoxDialog *dialog = new wxMessageBoxDialog(parent, caption, TRUE, x, y);
#endif

  wxList messageList;
  wxSplitMessage(message, &messageList, dialog);

  dialog->NewLine();

  dialog->listBoxItem = new wxListBox(dialog, NULL, NULL, wxSINGLE,
                     -1, -1, width, height, n, choices);
  dialog->NewLine();

  // Create Buttons in a sub-panel, so they can be centered.
#if (!defined(wx_xview) && USE_PANEL_IN_PANEL)
  wxPanel *but_panel = new wxPanel(dialog) ;
#else
  // Until sub panels work in XView mode
  wxPanel *but_panel = dialog ;
#endif

  wxButton *ok = new wxButton(but_panel, (wxFunction)&wxDialogOkButton, "OK");
  (void)new wxButton(but_panel, (wxFunction)&wxDialogCancelButton, "Cancel");
  // SetDefault must be done AFTER creating all buttons
  ok->SetDefault();

#if (!defined(wx_xview) && USE_PANEL_IN_PANEL)
  but_panel->Fit() ;
#endif
  dialog->Fit();
#if (!defined(wx_xview) && USE_PANEL_IN_PANEL)
  but_panel->Centre(wxHORIZONTAL) ;
#endif

  if (centre)
    wxCentreMessage(&messageList);

  if ((x < 0) && (y < 0))
    dialog->Centre(wxBOTH);
  else if (x < 0)
    dialog->Centre(wxHORIZONTAL);
  else if (y < 0)
    dialog->Centre(wxVERTICAL);

  dialog->Show(TRUE);
  if (wxMessageBoxDialog::buttonPressed == wxOK)
  {
    return wxMessageBoxDialog::listPosition;
  }
  else
    return -1;
}

char *wxGetSingleChoiceData(char *message, char *caption, int n,
                            char *choices[], char *client_data[],
                            wxFrame *parent, int x, int y, Bool centre,
                            int width, int height)
{
// Do not use ABSOLUTE until subpanels work with this mode!
#if (!USE_PANEL_IN_PANEL)
  wxMessageBoxDialog *dialog = new wxMessageBoxDialog(parent, caption, TRUE, x, y, 300, 250, wxABSOLUTE_POSITIONING);
#else
  wxMessageBoxDialog *dialog = new wxMessageBoxDialog(parent, caption, TRUE, x, y);
#endif

  wxList messageList;
  wxSplitMessage(message, &messageList, dialog);

  dialog->NewLine();

  dialog->listBoxItem = new wxListBox(dialog, NULL, NULL, wxSINGLE, -1, -1,
                     width, height);
  int i;
  for (i = 0; i < n; i++)
    dialog->listBoxItem->Append(choices[i], client_data[i]);

  dialog->NewLine();

  // Create Buttons in a sub-panel, so they can be centered.
#if (!defined(wx_xview) && USE_PANEL_IN_PANEL)
  wxPanel *but_panel = new wxPanel(dialog) ;
#else
  // Until sub panels work in XView mode
  wxPanel *but_panel = dialog ;
#endif

  wxButton *ok = new wxButton(but_panel, (wxFunction)&wxDialogOkButton, "OK");
  (void)new wxButton(but_panel, (wxFunction)&wxDialogCancelButton, "Cancel");
  // SetDefault must be done AFTER creating all buttons
  ok->SetDefault();

#if (!defined(wx_xview) && USE_PANEL_IN_PANEL)
  but_panel->Fit() ;
#endif
  dialog->Fit();
#if (!defined(wx_xview) && USE_PANEL_IN_PANEL)
  but_panel->Centre(wxHORIZONTAL) ;
#endif

  if (centre)
    wxCentreMessage(&messageList);

  if ((x < 0) && (y < 0))
    dialog->Centre(wxBOTH);
  else if (x < 0)
    dialog->Centre(wxHORIZONTAL);
  else if (y < 0)
    dialog->Centre(wxVERTICAL);

  dialog->Show(TRUE);
  if (wxMessageBoxDialog::buttonPressed == wxOK)
  {
    if (wxMessageBoxDialog::listPosition >= 0)
      return wxMessageBoxDialog::listClientSelection;
    else return NULL;
  }
  else
    return NULL;
}

// Pop up a message box: generic version used by X.
int wxbMessageBox(char *message, char *caption, int type,
                 wxFrame *parent, int x, int y)
{
#if (!USE_PANEL_IN_PANEL)
  wxMessageBoxDialog *dialog = new wxMessageBoxDialog(parent, caption, TRUE, x, y, 500, 500, wxABSOLUTE_POSITIONING);
#else
  wxMessageBoxDialog *dialog = new wxMessageBoxDialog(parent, caption, TRUE, x, y, 600, 600);
#endif

  Bool centre = ((type & wxCENTRE) == wxCENTRE);

  wxList messageList;
  wxSplitMessage(message, &messageList, dialog);

  dialog->NewLine();

  // Create Buttons in a sub-panel, so they can be centered.
#if (!defined(wx_xview) && USE_PANEL_IN_PANEL)
  wxPanel *but_panel = new wxPanel(dialog) ;
#else
  // Until sub panels work in XView mode
  wxPanel *but_panel = dialog ;
#endif

  wxButton *ok = NULL;
  wxButton *cancel = NULL;
  wxButton *yes = NULL;
  wxButton *no = NULL;

  if (type & wxYES_NO)
  {
    yes = new wxButton(but_panel, (wxFunction)&wxDialogYesButton, "Yes");
    no = new wxButton(but_panel, (wxFunction)&wxDialogNoButton, "No");
  }

  if (type & wxOK)
  {
    ok = new wxButton(but_panel, (wxFunction)&wxDialogOkButton, "OK");
  }

  if (type & wxCANCEL)
  {
    cancel = new wxButton(but_panel, (wxFunction)&wxDialogCancelButton, "Cancel");
  }

  if (ok)
    ok->SetDefault();
  else if (yes)
    yes->SetDefault();

#if (!defined(wx_xview) && USE_PANEL_IN_PANEL)
  but_panel->Fit() ;
#endif
  dialog->Fit();
#if (!defined(wx_xview) && USE_PANEL_IN_PANEL)
  but_panel->Centre(wxHORIZONTAL) ;
#endif

  // Do the message centering
  if (centre)
    wxCentreMessage(&messageList);

#if (defined(wx_xview) || !USE_PANEL_IN_PANEL)
  // Since subpanels don't work on XView, we must center ok button
  if (ok && !cancel && !yes && !no)
    ok->Centre();
#endif

  if ((x < 0) && (y < 0))
    dialog->Centre(wxBOTH);
  else if (x < 0)
    dialog->Centre(wxHORIZONTAL);
  else if (y < 0)
    dialog->Centre(wxVERTICAL);

  dialog->Show(TRUE);

  return wxMessageBoxDialog::buttonPressed;
}
