/*
 * File:	wx_win.h
 * Purpose:	wxWindow class declaration (X version).
 * Author:	Julian Smart
 * Created:	1993
 * Updated:	
 * Copyright:	(c) 1993, AIAI, University of Edinburgh
 */

/* sccsid[] = "%W% %G%" */

#ifndef wx_winh
#define wx_winh

#include "common.h"
#include "wx_obj.h"
#include "wx_stdev.h"
#include "wx_list.h"
#include "wx_gdi.h"
#include "wb_win.h"

#include <X11/X.h>
#include <X11/Xutil.h>
#include <X11/keysym.h>

/*
 * Base class for frame, panel, canvas, panel items, dialog box.
 *
 */

#ifdef IN_CPROTO
typedef       void    *wxWindow ;
#else

class wxWindow: public wxbWindow
{
 public:
#ifdef wx_xview
  Xv_opaque dropSite;
#endif
  // Constructors/Destructors
  wxWindow(void);
  ~wxWindow(void);

  void GetSize(int *width, int *height);
  void GetPosition(int *x, int *y);
  void GetClientSize(int *width, int *height); // Size client can use
  void SetSize(int x, int y, int width, int height);
  void SetClientSize(int width, int size);
  void ClientToScreen(int *x, int *y);
  void ScreenToClient(int *x, int *y);
  void SetFocus(void);
  void CaptureMouse(void);
  void ReleaseMouse(void);
  void Enable(Bool enable);
  void DragAcceptFiles(Bool accept);
  void Fit(void) {};
  void Centre(int direction) {};
  void SetTitle(char *title) {};
  Bool PopupMenu(wxMenu *menu, float x, float y);

  void Show(Bool show);
  wxCursor *SetCursor(wxCursor *cursor);
  void SetColourMap(wxColourMap *cmap);

  float GetCharHeight(void);
  float GetCharWidth(void);
  void GetTextExtent(char *string, float *x, float *y,
                     float *descent = NULL, float *externalLeading = NULL);

  int CharCodeXToWX(KeySym keySym);
  KeySym CharCodeWXToX(int id);

#ifdef wx_motif 
  virtual Bool PreResize(void);
  virtual void PostDestroyChildren(void);
  int wxType;
#endif
};

#endif // IN_CPROTO
#endif
