/*
 * File:	wx_txt.h
 * Purpose:	Declares single-line text panel item
 * Author:	Julian Smart
 * Created:	1993
 * Updated:	
 * Copyright:	(c) 1993, AIAI, University of Edinburgh
 */

/* sccsid[] = "%W% %G%" */

#ifndef wx_txth
#define wx_txth

#include "common.h"
#include "wb_txt.h"

#ifdef wx_motif
#include <Xm/Label.h>
#include <Xm/Form.h>
#endif
#ifdef wx_xview
#include <xview/openmenu.h>
#endif

#ifdef IN_CPROTO
typedef       void    *wxText ;
#else

// Single-line text item
class wxText: public wxbText
{
 public:
  wxText(void);
  wxText(wxPanel *panel, wxFunction func, char *label, char *value = "",
         int x = -1, int y = -1, int width = -1, int height = -1,
         int style = 0, char *name = "text");
  ~wxText(void);

  Bool Create(wxPanel *panel, wxFunction func, char *label, char *value = "",
         int x = -1, int y = -1, int width = -1, int height = -1,
         int style = 0, char *name = "text");
  char *GetValue(void);
  void SetValue(char *value);
  void SetSize(int x, int y, int width, int height);
  void SetFocus(void);
};

#endif // IN_CPROTO
#endif // wx_txth
