/*
 * File:	wx_text.h
 * Purpose:	wxTextWindow - simple text subwindow class (X version)
 * Author:	Julian Smart
 * Created:	1993
 * Updated:	
 * Copyright:	(c) 1993, AIAI, University of Edinburgh
 */

/* sccsid[] = "%W% %G%" */

#ifndef wx_texth
#define wx_texth
#include "common.h"
#include "wx_frame.h"
#include "wb_text.h"

#ifdef IN_CPROTO
typedef       void    *wxTextWindow ;
#else

class wxTextWindow: public wxbTextWindow
{
#ifdef wx_motif
  long textPosition;
  Bool textModified;
#endif
 public:
  wxTextWindow(void);
  wxTextWindow(wxFrame *frame, int x=-1, int y=-1, int width=-1, int height=-1,
               int style=0, char *name = "textWindow");
  ~wxTextWindow(void);

  Bool Create(wxFrame *frame, int x=-1, int y=-1, int width=-1, int height=-1,
               int style=0, char *name = "textWindow");
  Bool LoadFile(char *file);
  Bool SaveFile(char *file);
  void WriteText(char *text);
  void SetSize(int x, int y, int width, int height);
  void SetClientSize(int width, int height);
  void Clear(void);
  void DiscardEdits(void);
  Bool Modified(void);
  char *GetContents(void);
  void SetInsertionPoint(long pos);
  void SetInsertionPointEnd(void);
  long GetInsertionPoint(void);
  long GetLastPosition(void);
  long XYToPosition(long x, long y);
  void PositionToXY(long *x, long *y);
  void ShowPosition(long pos);
  int GetLineLength(long lineNo);
  int GetLineText(long lineNo, char *buf);
  int GetNumberOfLines(void);
  void Replace(long from, long to, char *value);
  void Remove(long from, long to);
  void Highlight(long from, long to);
  void SetEditable(Bool editable);
#ifdef wx_xview
  virtual void DragAcceptFiles(Bool accept = TRUE);
#endif
};

#endif // IN_CPROTO
#endif // wx_texth
