/*
 * File:	wx_slidr.h
 * Purpose:	Declares slider panel item (X version)
 * Author:	Julian Smart
 * Created:	1993
 * Updated:	
 * Copyright:	(c) 1993, AIAI, University of Edinburgh
 */

/* sccsid[] = "%W% %G%" */

#ifndef wx_slidrh
#define wx_slidrh

#include "common.h"
#include "wb_slidr.h"

#ifdef IN_CPROTO
typedef       void    *wxSlider ;
#else

// Slider
class wxSlider: public wxbSlider
{
 public:
  wxSlider(void);
  wxSlider(wxPanel *panel, wxFunction func, char *label, int value,
           int min_value, int max_value, int width, int x = -1, int y = -1,
           int style = 0, char *name = "slider");
  ~wxSlider(void);

  Bool Create(wxPanel *panel, wxFunction func, char *label, int value,
           int min_value, int max_value, int width, int x = -1, int y = -1,
           int style = 0, char *name = "slider");
  int GetValue(void);
  void SetValue(int);
  void GetSize(int *x, int *y);
  void SetSize(int x, int y, int width, int height);
};

#endif // IN_CPROTO
#endif // wx_slidrh
