/*
 * File:	wx_rbox.h
 * Purpose:	Declares radio box item (X version)
 * Author:	Julian Smart
 * Created:	1993
 * Updated:	
 * Copyright:	(c) 1993, AIAI, University of Edinburgh
 */

/* sccsid[] = "%W% %G%" */

#ifndef wx_rboxh
#define wx_rboxh

#include "common.h"
#include "wx_win.h"
#include "wb_rbox.h"

#ifdef IN_CPROTO
typedef       void    *wxRadioBox ;
#else

// Radio box item
class wxBitmap ;
class wxRadioBox: public wxbRadioBox
{
 public:
#ifdef wx_motif
  char **radioButtonLabels;
  Widget *radioButtons;
#endif

  wxRadioBox(void);
  wxRadioBox(wxPanel *panel, wxFunction func, char *Title,
             int x = -1, int y = -1, int width = -1, int height = -1,
             int N = 0, char **Choices = NULL,
             int majorDim=0, int style = 0, char *name = "radioBox");
  wxRadioBox(wxPanel *panel, wxFunction func, char *Title,
             int x = -1, int y = -1, int width = -1, int height = -1,
             int N = 0, wxBitmap **Choices = NULL,
             int majorDim=0, int style = 0, char *name = "radioBox");
  ~wxRadioBox(void);

  Bool Create(wxPanel *panel, wxFunction func, char *Title,
             int x = -1, int y = -1, int width = -1, int height = -1,
             int N = 0, char **Choices = NULL,
             int majorDim=0, int style = 0, char *name = "radioBox");
  Bool Create(wxPanel *panel, wxFunction func, char *Title,
             int x = -1, int y = -1, int width = -1, int height = -1,
             int N = 0, wxBitmap **Choices = NULL,
             int majorDim=0, int style = 0, char *name = "radioBox");
  int FindString(char *s);
  void SetSelection(int N);
  int GetSelection(void);
  char *GetString(int N);
  void SetSize(int x, int y, int width, int height);
#ifdef wx_motif
  void Enable(Bool enable);
#endif
  void Enable(int item, Bool enable);
  void Show(int item, Bool show) ;
  void SetLabel(int item, char *label) ;
  void SetLabel(int item, wxBitmap *bitmap) ;
};

#endif // IN_CPROTO
#endif // wx_rboxh
