/*
 * File:	wx_menu.h
 * Purpose:	Declares menus and menu bars (X version)
 * Author:	Julian Smart
 * Created:	1993
 * Updated:	
 * Copyright:	(c) 1993, AIAI, University of Edinburgh
 */

/* sccsid[] = "%W% %G%" */

#ifndef wx_menuh
#define wx_menuh

#include "common.h"
#include "wx_win.h"
#include "wx_panel.h"
#include "wb_menu.h"
#include "wx_mnuit.h"

#ifdef wx_motif
#include <Xm/Label.h>
#include <Xm/Form.h>
#endif
#ifdef wx_xview
#include <xview/openmenu.h>
#endif

#ifdef IN_CPROTO
typedef       void    *wxMenu ;
typedef       void    *wxMenuBar ;
#else

class wxMenuBar;

// Menu
class wxMenu: public wxbMenu
{
 public:
#ifdef wx_motif
  Widget buttonWidget; // The actual string, so we can grey it etc.
  int menuId;
#endif
#ifdef wx_xview
  void *panelItem ;
#endif

  wxMenu(char *Title = NULL, wxFunction func = NULL);
  ~wxMenu(void);
  void AppendSeparator(void);
  void Append(int Id, char *Label, char *helpString = NULL);
  void Append(int Id, char *Label, wxMenu *SubMenu, char *helpString = NULL);
  void Enable(int Id, Bool Flag);
  void Check(int Id, Bool Flag);
  void SetTitle(char *label);
  char *GetTitle(void);
  void SetLabel(int id, char *label);
  char *GetLabel(int id);

#ifdef wx_motif
  Widget CreateMenu(wxMenuBar *menuBar, Widget parent, wxMenu *topMenu,
            char *title = NULL, Bool isPulldown = FALSE);
  Widget FindMenuItem(int Id);
#endif
#ifdef wx_xview
  Menu_item FindMenuItem(int Id);
#endif
};

// Menu Bar (a la Windows)
#define MENU_BAR_PANEL_HEIGHT 30
class wxMenuBar:public wxbMenuBar
{
 public:
  wxMenuBar(void);
  wxMenuBar(int n, wxMenu *menus[], char *Titles[]);
  ~wxMenuBar(void);

  // Must only be used AFTER menu has been attached to frame,
  // otherwise use individual menus to enable/disable items
  void Enable(int id, Bool flag);
  void EnableTop(int pos, Bool flag);
  void Check(int id, Bool flag);
  void SetLabel(int id, char *label) ;
  char *GetLabel(int id) ;
  void SetLabelTop(int pos,char *label) ;
  char *GetLabelTop(int pos) ;
};

#endif // IN_CPROTO
#endif // wx_menuh
