/*
 * File:	wx_item.h
 * Purpose:	Declares panel items (controls/widgets) for X
 * Author:	Julian Smart
 * Created:	1993
 * Updated:	
 * Copyright:	(c) 1993, AIAI, University of Edinburgh
 */

/* sccsid[] = "%W% %G%" */

#ifndef wx_itemh
#define wx_itemh

#include "common.h"
#include "wx_win.h"
#include "wx_panel.h"
#include "wb_item.h"

#ifdef wx_motif
#include <Xm/Label.h>
#include <Xm/Form.h>
#endif
#ifdef wx_xview
#include <xview/openmenu.h>
#endif

#ifdef IN_CPROTO
typedef       void    *wxItem ;
#else

// General item class
class wxItem: public wxbItem
{
 public:
    wxItem(void);
   ~wxItem(void);
#ifdef wx_motif
   // Each item is a form/rowcol widget, optional label widget, plus a specific
   // widget
   Widget formWidget;
   Widget labelWidget;
   int itemOrientation;
   int rowNumber;
   int colNumber;
   void AttachWidget(wxPanel *panel, Widget formWidget,
                     int x, int y, int width, int height);
#endif

   void GetSize(int *width, int *height);
   void GetPosition(int *x, int *y);
   void SetSize(int x, int y, int width, int height);
   void SetFocus(void);
   void SetLabel(char *label);
   char *GetLabel(void);

   void Show(Bool show);
   void Enable(Bool enable);
   float GetCharHeight(void);
   float GetCharWidth(void);
   void GetTextExtent(char *string, float *x, float *y,
                      float *descent = NULL, float *externalLeading = NULL,
                      wxFont *the_font = NULL);
};

// Find the letter corresponding to the mnemonic, for Motif
char wxFindMnemonic(char *s);

#endif // IN_CPROTO
#endif // wx_itemh
