/*
 * File:	wx_dccan.h
 * Purpose:	Canvas device context declaration (X version)
 * Author:	Julian Smart
 * Created:	1993
 * Updated:	
 * Copyright:	(c) 1993, AIAI, University of Edinburgh
 */

/* sccsid[] = "%W% %G%" */


#ifndef wx_dccanh
#define wx_dccanh

#ifndef IN_CPROTO
#include <fstream.h>
#endif
#include "common.h"
#include "wx_frame.h"
#include "wx_gdi.h"
#include "wb_dccan.h"

#ifdef IN_CPROTO
typedef       void    *wxCanvasDC ;
#else

class wxCanvas;
class wxCanvasDC: public wxbCanvasDC
{
 public:
  wxCanvas *canvas;
  // Every time a callback happens, these are set to point to the right values
  // for drawing calls to work
  GC gc;
  Display *display;

  Pixmap pixmap;
  int pixmapWidth;
  int pixmapHeight;

  Region current_reg,
         onpaint_reg,
         user_reg;

#ifdef wx_motif
  GC gcBacking;
#endif
  int background_pixel;
  wxColour current_colour;
  int current_pen_width ;
  int current_pen_join ;
  int current_pen_cap ;
  int current_pen_nb_dash ;
  char *current_pen_dash ;
  wxBitmap *current_stipple ;
  int current_style ;
  wxBitmap *selected_pixmap;

  wxCanvasDC(void);

  // Create a DC corresponding to a canvas
  wxCanvasDC(wxCanvas *canvas);

  ~wxCanvasDC(void);

  void SetCanvasClipping() ;
  void GetClippingBox(float *x,float *y,float *w,float *h) ;

  virtual void BeginDrawing(void) {} ;
  virtual void EndDrawing(void) {} ;

  void DrawLine(float x1, float y1, float x2, float y2);
  void IntDrawLine(int x1, int y1, int x2, int y2);
  void DrawArc(float x1,float y1,float x2,float y2,float xc,float yc);
  void DrawPoint(float x, float y);
  void DrawLines(int n, wxPoint points[], float xoffset = 0, float yoffset = 0);
  void DrawLines(int n, wxIntPoint points[], int xoffset = 0, int yoffset = 0);
  void DrawPolygon(int n, wxPoint points[], float xoffset = 0, float yoffset = 0);
  void DrawRectangle(float x, float y, float width, float height);
  void DrawRoundedRectangle(float x, float y, float width, float height, float radius = 20);
  void DrawEllipse(float x, float y, float width, float height);
  void DrawIcon(wxIcon *icon, float x, float y);
  void DrawText(char *text, float x, float y);

  void Clear(void);
  void SetFont(wxFont *font);
  void SetPen(wxPen *pen);
  void SetBrush(wxBrush *brush);
  void SetLogicalFunction(int function);
  void SetBackground(wxBrush *brush);
  void SetClippingRegion(float x, float y, float width, float height);
  void DestroyClippingRegion(void);

  float GetCharHeight(void);
  float GetCharWidth(void);
  void GetTextExtent(char *string, float *x, float *y,
                     float *descent = NULL, float *externalLeading = NULL);
  Bool StartDoc(char *message);
  void EndDoc(void);
  void StartPage(void);
  void EndPage(void);
  void SetMapMode(int mode);
  void SetUserScale(float x, float y);
  float DeviceToLogicalX(int x);
  float DeviceToLogicalY(int y);
  float DeviceToLogicalXRel(int x);
  float DeviceToLogicalYRel(int y);
  int LogicalToDeviceX(float x);
  int LogicalToDeviceY(float y);
  int LogicalToDeviceXRel(float x);
  int LogicalToDeviceYRel(float y);

  Bool Blit(float xdest, float ydest, float width, float height,
            wxCanvasDC *source, float xsrc, float ysrc, int rop = wxCOPY);

};

#endif // IN_CPROTO
#endif // wx_dccanh

