/*
 * File:	wx_choic.h
 * Purpose:	Declares wxChoice panel item (X version)
 * Author:	Julian Smart
 * Created:	1993
 * Updated:	
 * Copyright:	(c) 1993, AIAI, University of Edinburgh
 */

/* sccsid[] = "%W% %G%" */

#ifndef wx_choich
#define wx_choich

#include "common.h"
#include "wx_win.h"
#include "wx_panel.h"
#include "wb_choic.h"

#ifdef IN_CPROTO
typedef       void    *wxChoice ;
#else

// Choice item
class wxChoice: public wxbChoice
{
  int no_strings;
 public:
#ifdef wx_motif
  Widget menuWidget;
  Widget buttonWidget;
  Widget *widgetList ;
  Widget rowWidget;
  wxStringList stringList;
#endif
  wxChoice(void);
  wxChoice(wxPanel *panel, wxFunction func, char *Title,
           int x = -1, int y = -1, int width = -1, int height = -1,
           int N = 0, char **Choices = NULL,
           int style = 0, char *name = "choice");
  ~wxChoice(void);

  Bool Create(wxPanel *panel, wxFunction func, char *Title,
           int x = -1, int y = -1, int width = -1, int height = -1,
           int N = 0, char **Choices = NULL,
           int style = 0, char *name = "choice");
  virtual void Append(char *Item);
  virtual void Clear(void);
  virtual int GetSelection(void);
  virtual void SetSelection(int n);
  virtual int FindString(char *s);
  virtual char *GetString(int n);
};

#endif // IN_CPROTO
#endif // wx_choich
