/*
 * File:	wx_canvs.h
 * Purpose:	wxCanvas subwindow declarations (X version)
 * Author:	Julian Smart
 * Created:	1993
 * Updated:	
 * Copyright:	(c) 1993, AIAI, University of Edinburgh
 */

/* sccsid[] = "%W% %G%" */

#ifndef wx_canvsh
#define wx_canvsh

#ifndef IN_CPROTO
#include <iostream.h>
#endif
#include "common.h"
#include "wx_frame.h"
#include "wx_gdi.h"
#include "wb_canvs.h"

#ifdef wx_xview
#include <xview/canvas.h>
#include <xview/scrollbar.h>
#include <xview/xv_xrect.h>
#endif

#ifdef IN_CPROTO
typedef       void    *wxCanvas ;
#else

// Canvas subwindow for drawing on
class wxCanvas: public wxbCanvas
{
 public:
  int units_per_page_x;
  int units_per_page_y;
  int units_x ;
  int units_y ;
  Bool requiresRetention; // Not the same as IsRetained()!
#ifdef wx_motif
  Bool requiresBackingStore ;
  Widget scrolledWindow;
  Bool PreResize(void);
  Bool hScroll;
  Bool vScroll;
  int  hExtent;   // Actual extent of virtual scrolled canvas
  int  vExtent;
  Widget hScrollBar;
  Widget vScrollBar;
  Widget borderWidget;
  Bool allowRepainting;
  Bool hScrollingEnabled;
  Bool vScrollingEnabled;
  Pixmap backingPixmap;
  int pixmapWidth;
  int pixmapHeight;
  int pixmapOffsetX;
  int pixmapOffsetY;
  // Need to store state of buttons (whether they're still down)
  Bool button1Pressed;
  Bool button2Pressed;
  Bool button3Pressed;
  void Refresh(void);
#endif
#ifdef wx_xview
  int DRAG_MAX;
  int drag_count;
  Xv_xrectlist *xrects;
  Xv_opaque selectionRequestor;
#endif
  wxCanvas(void);
  wxCanvas(wxFrame *frame, int x=-1, int y=-1, int width=-1, int height=-1,
           int style = wxRETAINED, char *name = "canvas");
  virtual ~wxCanvas(void);

  Bool Create(wxFrame *frame, int x=-1, int y=-1, int width=-1, int height=-1,
           int style = wxRETAINED, char *name = "canvas");
  void SetSize(int x, int y, int width, int height);
  void SetClientSize(int width, int height);
  void GetSize(int *width, int *height);
  void GetClientSize(int *width, int *height);
  void GetPosition(int *x, int *y);

  // Number of pixels per user unit (0 or -1 for no scrollbar)
  // Length of virtual canvas in user units
  // Length of page in user units
  void SetScrollbars(int horizontal, int vertical,
                             int x_length, int y_length,
                             int x_page, int y_page,
                             int x_pos = 0, int y_pos = 0);

  // Scroll the canvas
  void Scroll(int x_pos, int y_pos);
  void GetScrollUnitsPerPage(int *x_page, int *y_page);

#ifdef wx_xview
// Every time a callback happens, these are set to point to the right values
// for drawing calls to work
  Xv_Window paint_window;
  Scrollbar horiz_scroll;
  Scrollbar vert_scroll;
  virtual void DragAcceptFiles(Bool accept = TRUE);
#endif

  Display *display;
  Window xwindow;

  void ViewStart(int *x, int *y);

  // Actual size in pixels when scrolling is taken into account
  void GetVirtualSize(int *x, int *y);

  void SetColourMap(wxColourMap *cmap);
  wxCursor *SetCursor(wxCursor *cursor);

  // Enable/disable Windows 3.1 scrolling in either direction.
  // If TRUE, wxWindows scrolls the canvas and only a bit of
  // the canvas is invalidated; no Clear() is necessary.
  // If FALSE, the whole canvas is invalidated and a Clear() is
  // necessary. Disable for when the scroll increment is used
  // to actually scroll a non-constant distance
  void EnableScrolling(Bool x_scrolling, Bool y_scrolling);

  Bool IsRetained(void) { return is_retained; }

  virtual void WarpPointer(int x_pos, int y_pos) ;
};

#endif // IN_CPROTO
#endif // wc_canvsh
