/*
 * File:	wx_slidr.h
 * Purpose:	Slider
 * Author:	Julian Smart
 * Created:	1993
 * Updated:	
 * Copyright:	(c) 1993, AIAI, University of Edinburgh
 */

/* sccsid[] = "%W% %G%" */

#ifndef wx_slidrh
#define wx_slidrh

#include "wb_slidr.h"

#ifdef IN_CPROTO
typedef       void    *wxSlider ;
#else

// Slider
class wxSlider: public wxbSlider
{
 public:
  HWND static_label;
  HWND static_min;
  HWND static_max;
  HWND edit_value;

  int s_min;
  int s_max;
  int page_size;

  wxSlider(void);
  wxSlider(wxPanel *panel, wxFunction func, char *label, int value,
           int min_value, int max_value, int width, int x = -1, int y = -1,
           int style = 0, char *name = "slider");
  ~wxSlider(void);

  Bool Create(wxPanel *panel, wxFunction func, char *label, int value,
           int min_value, int max_value, int width, int x = -1, int y = -1,
           int style = 0, char *name = "slider");
  virtual int GetValue(void);
  virtual char *GetLabel(void);
  virtual void SetValue(int);
  virtual void SetLabel(char *label);
  void GetSize(int *x, int *y);
  void SetSize(int x, int y, int width, int height);
  void GetPosition(int *x, int *y);
};

#endif // IN_CPROTO
#endif // wx_slidrh
