/*
 * File:	wx_menu.h
 * Purpose:	Declares panel items (controls/widgets)
 * Author:	Julian Smart
 * Created:	1993
 * Updated:	
 * Copyright:	(c) 1993, AIAI, University of Edinburgh
 */

/* sccsid[] = "%W% %G%" */

#ifndef wx_menuh
#define wx_menuh

#include "common.h"
#include "wx_win.h"
#include "wx_panel.h"
#include "wb_menu.h"

#ifdef IN_CPROTO
typedef       void    *wxMenu ;
typedef       void    *wxMenuBar ;
#else

class wxMenuBar;

// Menu
class wxMenu: public wxbMenu
{
 public:
  HANDLE save_ms_handle ; // Used for Enable() on popup

  wxMenu(char *Title = NULL, wxFunction func = NULL);
  ~wxMenu(void);
  void AppendSeparator(void);
  void Append(int id, char *Label, char *helpString = NULL);
  void Append(int id, char *Label, wxMenu *SubMenu, char *helpString = NULL);
  void Enable(int id, Bool Flag);
  void Check(int id, Bool Flag);
  void SetTitle(char *label);
  char *GetTitle(void);
  void SetLabel(int id, char *label);
  char *GetLabel(int id);

  BOOL MSWCommand(UINT param, WORD id);
};

// Menu Bar (a la Windows)
#define MENU_BAR_PANEL_HEIGHT 30
class wxFrame;
class wxMenuBar:public wxbMenuBar
{
 public:
  wxMenuBar(void);
  wxMenuBar(int n, wxMenu *menus[], char *Titles[]);
  ~wxMenuBar(void);

  void Append(wxMenu *menu, char *title);
  // Must only be used AFTER menu has been attached to frame,
  // otherwise use individual menus to enable/disable items
  void Enable(int Id, Bool Flag);
  void EnableTop(int pos, Bool Flag);
  void Check(int id, Bool Flag);
  void SetLabel(int id,char *label) ;
  char *GetLabel(int id) ;
  void SetLabelTop(int pos,char *label) ;
  char *GetLabelTop(int pos) ;
};

#endif // IN_CPROTO
#endif // wx_menuh
