/*
 * File:	wx_item.h
 * Purpose:	Declares base panel item class
 * Author:	Julian Smart
 * Created:	1993
 * Updated:	
 * Copyright:	(c) 1993, AIAI, University of Edinburgh
 */

/* sccsid[] = "%W% %G%" */

#ifndef wx_itemh
#define wx_itemh

#include "wb_item.h"

#ifdef IN_CPROTO
typedef       void    *wxItem ;
#else

// General item class
class wxItem: public wxbItem
{
 public:
   wxList subControls; // For controls like radiobuttons which are really composite
   wxItem(void);
   ~wxItem(void);

   void GetSize(int *width, int *height);
   void GetPosition(int *x, int *y);
   void SetSize(int x, int y, int width, int height);
   void SetClientSize(int width, int height);
   void SetFocus(void);
   void SetLabel(char *label);
   char *GetLabel(void);

   void Show(Bool show);
   float GetCharHeight(void);
   float GetCharWidth(void);
   void GetTextExtent(char *string, float *x, float *y,
                      float *descent = NULL, float *externalLeading = NULL,
                      wxFont *the_font=NULL);
};

#endif // IN_CPROTO
#endif // wx_itemh
