/*
 * File:	wx_gdi.h
 * Purpose:	Declaration of various graphics objects - fonts, pens, icons etc.
 * Author:	Julian Smart
 * Created:	1993
 * Updated:	
 * Copyright:	(c) 1993, AIAI, University of Edinburgh
 */

/* sccsid[] = "%W% %G%" */


#ifndef wx_gdih
#define wx_gdih

#include "wb_gdi.h"

#ifdef IN_CPROTO
typedef       void    *wxFont ;
typedef       void    *wxColourMap;
typedef       void    *wxPen;
typedef       void    *wxBrush;
typedef       void    *wxIcon;
typedef       void    *wxCursor;
typedef       void    *wxBitmap;
#else

// Font
class wxFont: public wxbFont
{
 public:
  HFONT cfont;

  wxFont(void);
  wxFont(int PointSize, int Family, int Style, int Weight, Bool underlined = FALSE);
  ~wxFont(void);
  void BuildInternalFont(HDC dc) ;
  HFONT GetInternalFont(HDC dc) ;
};

class wxColourMap: public wxbColourMap
{
 public:
  wxColourMap(void);
  ~wxColourMap(void);
};

#define wxColorMap wxColourMap

// Pen
class wxPen: public wxbPen
{
 public:
  int old_width;
  int old_style;
  int old_join ;
  int old_cap ;
  int old_nb_dash ;
  wxDash *old_dash ;
  wxBitmap *old_stipple ;
  COLORREF old_color ;

  HPEN cpen;

  wxPen(void);
  wxPen(wxColour& col, int width, int style);
  wxPen(char *col, int width, int style);
  ~wxPen(void);

  Bool ChangePen() ;

};

int wx2msPenStyle(int wx_style);

// Brush
class wxBrush: public wxbBrush
{
 public:
  HBRUSH cbrush;
  int old_style;
  wxBitmap *old_stipple ;
  COLORREF old_color ;


  wxBrush(void);
  wxBrush(wxColour& col, int style);
  wxBrush(char *col, int style);
  ~wxBrush(void);

  Bool ChangeBrush() ;
};

// Icon
class wxIcon: public wxbIcon
{
 public:
  HICON ms_icon;
  wxIcon(void);
  wxIcon(char bits[], int width, int height);
  wxIcon(char *name);
  ~wxIcon(void);
};

// Cursor
class wxCursor: public wxbCursor
{
 public:
  HCURSOR ms_cursor;
  wxCursor(void);
  wxCursor(char bits[], int width, int height);
  wxCursor(char *name);
  wxCursor(int cursor_type);
  ~wxCursor(void);
};

// Bitmap
class wxBitmap: public wxbBitmap
{
 public:
  HBITMAP ms_bitmap;

  wxBitmap(void); // Platform-specific
  wxBitmap(char bits[], int width, int height, int depth = 1);
  wxBitmap(char *name);
  // If depth is omitted, will create a bitmap compatible with the display
  wxBitmap(int width, int height, int depth = -1);
  ~wxBitmap(void);
};

#endif // IN_CPROTO
#endif // wx_gdih
