/*
 * File:	wx_dialg.h
 * Purpose:	wxDialogBox and common dialog declarations
 * Author:	Julian Smart
 * Created:	1993
 * Updated:	
 * Copyright:	(c) 1993, AIAI, University of Edinburgh
 */

/* sccsid[] = "%W% %G%" */

#ifndef wx_dialgh
#define wx_dialgh

#include "common.h"
#include "wx_item.h"
#include "wx_check.h"
#include "wx_messg.h"
#include "wb_dialg.h"

#ifdef IN_CPROTO
typedef void    *wxDialogBox ;
#else

// Dialog boxes
class wxDialogBox: public wxbDialogBox
{
 public:
  Bool modal_showing;

  wxDialogBox(void);
  wxDialogBox(wxFrame *frame, char *title, Bool modal = FALSE,
              int x = -1, int y = -1,
              int width = -1, int height = -1, int style = 0,
              char *name = "dialogBox");
  ~wxDialogBox(void);

  Bool Create(wxFrame *frame, char *title, Bool modal=FALSE,
              int x=-1, int y=-1,
              int width=-1, int height=-1, int style=0,
              char *name="dialogBox");
  void SetSize(int x, int y, int width, int height);
  void SetClientSize(int width, int height);
  void GetPosition(int *x, int *y);
  void Show(Bool show);
  Bool IsShown(void);
  void Iconize(Bool iconize);
  Bool Iconized(void);
  void Fit(void);

  void SetTitle(char *title);
  char *GetTitle(void);
};

int wxMessageBox(char *message, char *caption = "Message", int style = wxOK|wxCENTRE,
  wxFrame *parent = NULL, int x = -1, int y = -1);


#endif // IN_CPROTO
#endif // wx_dialgh
