/*
 * File:	wx_utils.h
 * Purpose:	Miscellaneous utilities
 * Author:	Julian Smart
 * Created:	1993
 * Updated:	
 * Copyright:	(c) 1993, AIAI, University of Edinburgh
 */

/* sccsid[] = "%W% %G%" */

#ifndef wxb_utilsh
#define wxb_utilsh
#include "wx_setup.h"
#include "wx_obj.h"
#include "wx_list.h"
#include "wx_win.h"
#include "wx_frame.h"

#ifdef wx_x
#include <dirent.h>
#include <unistd.h>
#endif

// sprintf is often needed, but we don't always want to include the whole
// of stdio.h!
#ifdef wx_msw
extern "C" int __cdecl sprintf(char *, const char *, ...);
#endif
#ifdef wx_x
#include <stdio.h>
#endif

// Make a copy of this string using 'new'
char *copystring(char *s);

// Generate a unique ID
long NewId(void);

// Ensure subsequent IDs don't clash with this one
void RegisterId(long id);

// Useful buffer
extern char wxBuffer[];

// Various conversions
void StringToFloat(char *s, float *number);
char *FloatToString(float number);
void StringToDouble(char *s, double *number);
char *DoubleToString(double number);
void StringToInt(char *s, int *number);
void StringToLong(char *s, long *number);
char *IntToString(int number);
char *LongToString(long number);

// Matches string one within string two regardless of case
#ifndef IN_CPROTO
Bool StringMatch(char *one, char *two, Bool subString = TRUE, Bool exact = FALSE);
#endif

// Some file utilities

#ifdef IN_CPROTO
typedef       void    *wxPathList ;
typedef       void    *wxLogClass;
#else
// Path searching
class wxPathList: public wxList
{
  public:

  void AddEnvList(char *envVariable);    // Adds all paths in environment variable
  void Add(char *path);
  char *FindValidPath(char *filename);   // Find the first full path
                                         // for which the file exists
  void EnsureFileAccessible(char *path); // Given full path and filename,
                                         // add path to list
  Bool Member(char *path);
};

Bool FileExists(char *filename);
Bool DirExists(char *dir);
Bool IsAbsolutePath(char *filename);

// Get filename
char *FileNameFromPath(char *path);

// Get directory
char *PathOnly(char *path);

void Dos2UnixFilename(char *s);
void Unix2DosFilename(char *s);

// Get a temporary filename, opening and closing the file.
void wxGetTempFileName(char *prefix, char *buf);

// Does the pattern contain wildcards?
Bool wxIsWild(char *pattern);

// Does the pattern match the text (usually a filename)?
// If dot_special is TRUE, doesn't match * against . (eliminating
// `hidden' dot files)
Bool wxMatchWild(char *pattern, char *text, Bool dot_special = TRUE);

// Execute another program. Returns FALSE if there was an error.
Bool wxExecute(char *command);

// Concatenate two files to form third
Bool wxConcatFiles(char *file1, char *file2, char *file3);

// Copy file1 to file2
Bool wxCopyFile(char *file1, char *file2);

// Remove file
Bool wxRemoveFile(char *file);

// Rename file
Bool wxRenameFile(char *file1, char *file2);

// Sleep for nSecs seconds under UNIX, do nothing under Windows
void wxSleep(int nSecs);

// Get free memory in bytes, or -1 if cannot determine amount (e.g. on UNIX)
long wxGetFreeMemory(void);

// Consume all events until no more left
void wxFlushEvents(void);

// Make directory
Bool wxMkdir(char *dir);

/*
 * Network and username functions.
 *
 */

// Get hostname.
Bool wxGetHostName(char *buf, int maxSize);

// Get user ID e.g. jacs
Bool wxGetUserId(char *buf, int maxSize);

// Get user name e.g. Julian Smart
Bool wxGetUserName(char *buf, int maxSize);

/*
 * Strip out any menu codes
 */
void wxStripMenuCodes(char *in, char *out);

// Find the window/widget with the given title or label.
// Pass a parent to begin the search from, or NULL to look through
// all windows.
wxWindow *wxFindWindowByLabel(wxWindow *parent, char *title);

// Returns menu item id or -1 if none.
int wxFindMenuItemId(wxFrame *frame, char *menuString, char *itemString);

// Debug Log
#ifdef DEBUGLOG
#include <fstream.h>
class wxLogClass
{
  ofstream *the_stream;
  char *log_file;
  public:
    wxLogClass(char *file);
    ~wxLogClass();
    void Open(void);
    void Close(void);

    wxLogClass& operator << (char *s);
    wxLogClass& operator << (int i);
    wxLogClass& operator << (double i);
};

extern wxLogClass wxLog;
#endif

#if (!defined(__MINMAX_DEFINED) && !defined(max))
#define max(a,b)            (((a) > (b)) ? (a) : (b))
#define min(a,b)            (((a) < (b)) ? (a) : (b))
#define __MINMAX_DEFINED 1
#endif

void wxDebugMsg(char *fmt ...) ;
void wxBell(void) ;

/*
 * Error message functions used by wxWindows
 *
 */

// Non-fatal error (continues) 
void wxError(char *msg, char *title = "wxWindows Internal Error");

// Fatal error (exits)
void wxFatalError(char *msg, char *title = "wxWindows Fatal Error");

// Reading and writing resources (eg WIN.INI, .Xdefaults)
#if USE_RESOURCES
Bool wxWriteResource(char *section, char *entry, char *value, char *file = NULL);
Bool wxWriteResource(char *section, char *entry, float value, char *file = NULL);
Bool wxWriteResource(char *section, char *entry, long value, char *file = NULL);
Bool wxWriteResource(char *section, char *entry, int value, char *file = NULL);

Bool wxGetResource(char *section, char *entry, char **value, char *file = NULL);
Bool wxGetResource(char *section, char *entry, float *value, char *file = NULL);
Bool wxGetResource(char *section, char *entry, long *value, char *file = NULL);
Bool wxGetResource(char *section, char *entry, int *value, char *file = NULL);
#endif // USE_RESOURCES

#endif // IN_CPROTO
#endif // wxb_utilsh
