/*
 * File:	wx_setup.h
 * Purpose:	Window library main include file
 * Author:	Julian Smart
 * Created:	1993
 * Updated:	
 * Copyright:	(c) 1993, AIAI, University of Edinburgh
 */

/* sccsid[] = "%W% %G%" */

#ifndef wx_setuph
#define wx_setuph

/*
 * Gross features
 *
 */
 

#define USE_POSTSCRIPT 1
                                    // 0 for no PostScript device context
#define USE_METAFILE   1
                                    // 0 for no Metafile and metafile device context
#define USE_FORM       1
                                    // 0 for no wxForm
#define USE_IPC        1
                                    // 0 for no interprocess comms
#define USE_HELP       1
                                    // 0 for no help facility
#define USE_ENHANCED_DIALOG 1
                                    // 0 for no enhanced dialog
#define USE_RESOURCES  1
                                    // 0 for no wxGetResource/wxWriteResource
#define USE_CLIPBOARD  1
                                    // 0 for no clipboard functions
#define USE_SPLINES    1
                                    // 0 for no splines
#define USE_XFIG_SPLINE_CODE  1
                                    // 1 for XFIG spline code, 0 for AIAI spline code.
                                    // AIAI spline code is slower, but freer of
                                    // copyright issues.
#define USE_DRAG_AND_DROP 1
                                    // 0 for no drag and drop

/*
 * Finer detail
 *
 */

/*
 * Motif
 *
 */
 
#define USE_GADGETS    1
                                    // More efficient to use gadgets for some
                                    // widgets in Motif. 0 for no gadgets.
                                    // Please note: there is no reason to not use it,
                                    // except if you intend to modify color of
                                    // individuals items.
#define PIXEL0_DISABLE 0
                                    // Define to disallow allocation of pixel #0 (wxXOR problem).

/*
 * Windows
 *
 */

#define EDITABLE_TEXT_WINDOW 0
                                    // Editable text window in Microsoft - uses
                                    // EDIT control, but files must be < 64K
                                    // Not yet implemented.
#define FAFA_LIB             1
                                    // Define 1 for Fafa lib. Mandatory for pixmapped
                                    // buttons under Windows.
#define CTL3D                1
                                    // Define 1 to use Microsoft CTL3D library.

/*
 * Any platform
 *
 */
#define ENHANCED_FONTS       1
                                    // Define 1 to have predefined fonts in
                                    // wxEnhDialogBox.
#define USE_PANEL_IN_PANEL   0
                                    // 1 to use panel in panel in common dialogs;
                                    // Advantage: neater dialogs. Disadvantage: messes up
                                    // default button and tab traversal.
#define USE_TYPEDEFS         0
                                    // Use typedefs not classes for wxPoint and others,
                                    // to reduce overhead and avoid MS C7 memory bug.
                                    // Bounds checker complains about deallocating
                                    // arrays of wxPoints if wxPoint is a class.

#endif // wx_setuph

