/*
 * File:	wx_dcps.h
 * Purpose:	PostScript device context
 * Author:	Julian Smart
 * Created:	1993
 * Updated:	
 * Copyright:	(c) 1993, AIAI, University of Edinburgh
 */

/* sccsid[] = "%W% %G%" */


#ifndef wx_dcpsh
#define wx_dcpsh
#include "wx_dc.h"
#if USE_POSTSCRIPT

#ifdef IN_CPROTO
typedef       void    *wxPostScriptDC ;
#else

class wxPostScriptDC: public wxDC
{
 public:
  int yorigin;          // For EPS
  ofstream *pstream;    // PostScript output stream
  char *filename;

  // Create a compatible DC from an existing one
  wxPostScriptDC(wxPostScriptDC *old_dc);

  // Create a printer DC
  wxPostScriptDC(char *output, Bool interactive = TRUE);

  ~wxPostScriptDC(void);

  virtual void BeginDrawing(void) {} ;
  virtual void EndDrawing(void) {} ;

  void DrawLine(float x1, float y1, float x2, float y2);
  void IntDrawLine(int x1, int y1, int x2, int y2);
  void DrawArc(float x1,float y1,float x2,float y2,float xc,float yc);
  void DrawPoint(float x, float y);
  void DrawLines(int n, wxPoint points[], float xoffset = 0, float yoffset = 0);
  void DrawLines(int n, wxIntPoint points[], int xoffset = 0, int yoffset = 0);
  void DrawPolygon(int n, wxPoint points[], float xoffset = 0, float yoffset = 0);
  void DrawRectangle(float x, float y, float width, float height);
  void DrawRoundedRectangle(float x, float y, float width, float height, float radius = 20);
  void DrawEllipse(float x, float y, float width, float height);
  // Splines
  // 3-point spline
  void DrawSpline(float x1, float y1, float x2, float y2, float x3, float y3);
  // Any number of control points - a list of pointers to wxPoints
  void DrawSpline(wxList *points);
  void DrawSpline(int n, wxPoint points[]);
  void DrawIcon(wxIcon *icon, float x, float y);
  void DrawText(char *text, float x, float y);

  void Clear(void);
  void SetFont(wxFont *font);
  void SetPen(wxPen *pen);
  void SetBrush(wxBrush *brush);
  void SetLogicalFunction(int function);
  void SetBackground(wxBrush *brush);
  void SetClippingRegion(float x, float y, float width, float height);
  void DestroyClippingRegion(void);

  Bool StartDoc(char *message);
  void EndDoc(void);
  void StartPage(void);
  void EndPage(void);

  float GetCharHeight(void);
  float GetCharWidth(void);
  void GetTextExtent(char *string, float *x, float *y,
                     float *descent = NULL, float *externalLeading = NULL);
  void SetMapMode(int mode);
  void SetUserScale(float x, float y);
  float DeviceToLogicalX(int x);
  float DeviceToLogicalY(int y);
  float DeviceToLogicalXRel(int x);
  float DeviceToLogicalYRel(int y);
  int LogicalToDeviceX(float x);
  int LogicalToDeviceY(float y);
  int LogicalToDeviceXRel(float x);
  int LogicalToDeviceYRel(float y);
  Bool Blit(float xdest, float ydest, float width, float height,
            wxCanvasDC *source, float xsrc, float ysrc, int rop = wxCOPY);
};

#endif // IN_CPROTO
#endif // USE_POSTSCRIPT
#endif // wx_dcpsh

