/*
 * File:	wx_clipb.h
 * Purpose:	Clipboard functionality
 * Author:	Julian Smart
 * Created:	1993
 * Updated:	
 * Copyright:	(c) 1993, AIAI, University of Edinburgh
 */

/* sccsid[] = "%W% %G%" */

#ifndef wx_clipbh
#define wx_clipbh

#include "common.h"
#include "wx_setup.h"

#if USE_CLIPBOARD

#include "wx_obj.h"

#ifndef IN_CPROTO
Bool wxOpenClipboard(void);
Bool wxCloseClipboard(void);
Bool wxEmptyClipboard(void);
Bool wxIsClipboardFormatAvailable(int dataFormat);
Bool wxSetClipboardData(int dataFormat, wxObject *obj, int width = 0, int height = 0);
wxObject *wxGetClipboardData(int dataFormat);
int  wxEnumClipboardFormats(int dataFormat);
int  wxRegisterClipboardFormat(char *formatName);
Bool wxGetClipboardFormatName(int dataFormat, char *formatName, int maxCount);
#endif // IN_CPROTO
#endif // USE_CLIPBOARD
#endif // wx_clipbh
