/*
 * File:	wxstring.h
 * Purpose:	String class
 * Author:	Julian Smart
 * Created:	1994
 * Updated:	
 * Copyright:	(c) 1993, AIAI, University of Edinburgh
 */

/* sccsid[] = "%W% %G%" */

#ifndef wx_stringh
#define wx_stringh

#include "common.h"
#include "wx_obj.h"

/*
 * String
 *
 */
 
class wxString: public wxObject
{
 private:
  char *stringData;
 public:
  wxString(char *s = NULL);
  wxString(wxString& s);
  ~wxString(void);

  void operator =(wxString& s);
  Bool operator ==(wxString& s);
  Bool operator !=(wxString& s);
  wxString operator +(wxString& s);
  inline int Compare(wxString& s) { return strcmp(stringData, s.GetData()); };

  inline char *GetData(void) { return stringData; }
  void SetData(char *s);
  inline int Length(void) { return strlen(stringData); }

  wxString SubString(int from, int to);
  wxString UpperCase(void);
  wxString LowerCase(void);
};

#endif // wx_stringh
