/*
 * File:	wb_win.h
 * Purpose:	
 * Author:	Julian Smart
 * Created:	1993
 * Updated:	
 * Copyright:	(c) 1993, AIAI, University of Edinburgh
 */

/* sccsid[] = "%W% %G%" */

/*
 * Purpose:  wxWindow class declaration. Base class for all windows and
 *           panel items.
 */


#ifndef wxb_winh
#define wxb_winh

#include "common.h"
#include "wx_obj.h"
#include "wx_stdev.h"
#include "wx_list.h"
#include "wx_gdi.h"

#ifdef IN_CPROTO
typedef       void    *wxFunction ;
typedef       void    *wxbWindow ;
#else

// Callback function type definition
typedef void (*wxFunction) (wxObject&, wxEvent&);

class wxMenu;

/*
 * Base class for frame, panel, canvas, panel items, dialog box.
 *
 */

class wxWindow;
class wxMenu;
class wxbWindow: public wxObject
{
 public:
  // Font - created on demand, not deleted with window
  int doubleClickAllowed ;
  wxFont *font;                               // Window's font
  wxCursor *wx_cursor;                        // Window's cursor

  char *wx_client_data;                       // Any user client data
  wxList *children;                           // Window's children
  Bool paintingEnabled;

  wxWindow *window_parent;                     // Each window always knows its parent
  char *handle;                                // Pointer to real window
  char *windowName;                            // Window name

  wxFunction callback;                         // Callback associated with the window
  virtual void Callback(wxFunction);           // Adds callback

  // Constructors/Destructors
  wxbWindow(void);
  virtual ~wxbWindow(void);

  virtual void OnPaint(void) {};             // Called when needs painting
  virtual void OnSize(int width, int height) {}; // Called on resize
  virtual void OnEvent(wxMouseEvent& event) {};  // Called on mouse event
  virtual void OnChar(wxKeyEvent& event) {};     // Called on character event
  virtual Bool OnClose(void) { return FALSE; };  // Delete window if returns TRUE
  virtual void OnActivate(Bool active) {};       // Called on window activation (MSW)
  virtual void OnSetFocus(void) {};              // Called on setting focus
  virtual void OnKillFocus(void) {};             // Called on killing focus
  virtual void OnDropFiles(int n, char *files[], int x, int y) {};
                                                 // Called when files dropped

  virtual void GetSize(int *width, int *height) = 0;
  virtual void GetPosition(int *x, int *y) = 0;
  virtual void GetClientSize(int *width, int *height) = 0; // Size client can use
  virtual void SetSize(int x, int y, int width, int height) = 0;
  virtual void SetClientSize(int width, int size) = 0;
  virtual void ClientToScreen(int *x, int *y) = 0;
  virtual void ScreenToClient(int *x, int *y) = 0;
  virtual void Enable(Bool enable) = 0;
  virtual void SetFocus(void) = 0;
  virtual void CaptureMouse(void) = 0;
  virtual void ReleaseMouse(void) = 0;
  virtual void DragAcceptFiles(Bool accept) = 0;

  // Most windows have the concept of a label; for frames, this is the
  // title; for items, this is the label or button text.
  virtual char *GetLabel(void) { return NULL; }
  virtual char *GetHandle(void);
  char *GetClientData(void);
  virtual wxWindow *GetParent(void);
  virtual wxWindow *GetGrandParent(void);
  virtual wxList *GetChildren() { return children; }

  void SetClientData(char *);
  virtual void Show(Bool show) = 0;
  virtual wxCursor *SetCursor(wxCursor *cursor) = 0;
  virtual void SetColourMap(wxColourMap *cmap) = 0;

  virtual float GetCharWidth(void) = 0;
  virtual float GetCharHeight(void) = 0;
  virtual void GetTextExtent(char *string, float *x, float *y,
                             float *descent = NULL, float *externalLeading = NULL) {};
  virtual void SetTitle(char *title) {};      // Set window title
  virtual void Fit(void) {};                  // Size window to fit contents
  virtual void Centre(int direction) {};      // Centre item on panel,
                                               // or frame on screen

  // A concession to our friends across the pond
  inline void Center(int direction = wxHORIZONTAL) { Centre(direction); }

  virtual void EnablePainting(Bool enable) { paintingEnabled = enable; }
  virtual void Paint(void) { OnPaint(); }

  virtual Bool PopupMenu(wxMenu *menu, float x, float y) = 0;

  // INTERNAL FUNCTIONS
  virtual void AddChild(wxObject *child);      // Adds reference to the child object
  virtual void RemoveChild(wxObject *child);   // Removes reference to child
                                       // (but doesn't delete the child object)
  virtual void DestroyChildren(void);  // Removes and destroys all children
};

extern wxList wxTopLevelWindows;

#endif // IN_CPROTO
#endif // wxb_winh
