/*
 * File:	wb_item.h
 * Purpose:	Declares panel items base class
 * Author:	Julian Smart
 * Created:	1993
 * Updated:	
 * Copyright:	(c) 1993, AIAI, University of Edinburgh
 */

/* sccsid[] = "%W% %G%" */

#ifndef wxb_itemh
#define wxb_itemh

#include "common.h"
#include "wx_panel.h"
#include "wx_stdev.h"

#ifdef IN_CPROTO
typedef       void    *wxbItem ;
#else

class wxFont ;

// General item class
class wxbItem: public wxWindow
{
 public:
    wxbItem(void);
   ~wxbItem(void);

   wxFont *buttonFont ;
   wxFont *labelFont ;
   int labelPosition;

   virtual void GetSize(int *width, int *height) = 0;
   virtual void GetPosition(int *x, int *y) = 0;
   virtual void SetSize(int x, int y, int width, int height) = 0;
   virtual void SetClientSize(int width, int height);
   virtual void SetFocus(void) = 0;
   virtual void SetLabel(char *label) = 0;
   virtual char *GetLabel(void) = 0;

   inline virtual void Command(wxCommandEvent& event) {};        // Simulates an event
   inline virtual void ProcessCommand(wxCommandEvent& event) {}; // Calls the callback and 
                                                                 // appropriate event handlers

   virtual void Show(Bool show) = 0;
   virtual float GetCharWidth(void) = 0;
   virtual float GetCharHeight(void) = 0;
   virtual void GetTextExtent(char *string, float *x, float *y,
                              float *descent = NULL,
                              float *externalLeading = NULL,
                              wxFont *the_font=NULL) = 0;
   virtual int GetLabelPosition(void);
   virtual void SetLabelPosition(int pos);

  // Places item in centre of panel - so can't be used BEFORE panel->Fit()
  void Centre(int direction = wxHORIZONTAL);
};

#endif // IN_CPROTO
#endif // wxb_itemh
