/*
 * File:	wb_frame.h
 * Purpose:	wxFrame declaration
 * Author:	Julian Smart
 * Created:	1993
 * Updated:	
 * Copyright:	(c) 1993, AIAI, University of Edinburgh
 */

/* sccsid[] = "%W% %G%" */

#ifndef wxb_frameh
#define wxb_frameh

#include "common.h"
#include "wx_win.h"

#define wxMAX_STATUS   5

#ifdef IN_CPROTO
typedef       void    *wxbFrame ;
#else

class wxMenuBar;

class wxStatusWnd;
class wxFrame;
class wxbFrame: public wxWindow
{
 public:
  Bool modal_showing;
  wxMenuBar *wx_menu_bar;
  wxIcon *icon;
  Bool status_line_exists;
  int frame_type;  // SDI, MDI parent/child
  int nb_status;

  wxbFrame(void);
  wxbFrame(wxFrame *parent, char *title,
          int x=-1, int y=-1, int width=-1, int height=-1,
          int type = wxSDI | wxDEFAULT_FRAME, char *name = "frame");

  ~wxbFrame(void);

  Bool Create(wxFrame *parent, char *title,
          int x=-1, int y=-1, int width=-1, int height=-1,
          int type = wxSDI | wxDEFAULT_FRAME, char *name = "frame");

  // Override, e.g. to resize subwindows
  void OnSize(int x, int y);

  // The default thing is to set the focus for the first child window.
  // Override for your own behaviour.
  void OnActivate(Bool flag);

  // Default behaviour is to display a help string for the menu item.
  virtual void OnMenuSelect(int id);
  virtual void OnMenuCommand(int Id) {};         // Called on frame menu command

  virtual void SetClientSize(int width, int height) = 0;
  virtual void GetClientSize(int *width, int *height) = 0;
  virtual void GetSize(int *width, int *height) = 0;
  virtual void GetPosition(int *x, int *y) = 0;
  virtual void SetSize(int x, int y, int width, int height) = 0;
  virtual void Show(Bool show) = 0;

  // Set menu bar
  virtual void SetMenuBar(wxMenuBar *menu_bar);
  virtual wxMenuBar *GetMenuBar(void);

  // Set title
  virtual void SetTitle(char *title) = 0;
  virtual char *GetTitle(void) = 0;

  inline virtual char *GetLabel(void) { return GetTitle(); }

  // Set icon
  virtual void SetIcon(wxIcon *icon) = 0;

  // Create status line
  virtual void CreateStatusLine(int number = 1, char *name = "status_line") = 0;

  // Set status line text
  virtual void SetStatusText(char *text, int number = 0) = 0;
  virtual Bool StatusLineExists(void);

  // Fit frame around subwindows
  virtual void Fit(void) = 0;

  // Centre window on screen (you can also use Center)
  virtual void Centre(int direction = wxBOTH);

  // Iconize
  virtual void Iconize(Bool iconize) = 0;
  virtual Bool Iconized(void) = 0;
  // Windos 3.x maximize/restore
  virtual void Maximize(Bool maximize) = 0;

  virtual void LoadAccelerators(char *table) = 0;

  // Call this to simulate a menu command
  virtual void Command(int id);
  virtual void ProcessCommand(int id);
};

#endif // IN_CPROTO
#endif // wxb_frameh
