/*
 * File:	wb_check.h
 * Purpose:	Check boxes
 * Author:	Julian Smart
 * Created:	1993
 * Updated:	
 * Copyright:	(c) 1993, AIAI, University of Edinburgh
 */

/* sccsid[] = "%W% %G%" */

#ifndef wxb_checkh
#define wxb_checkh

#include "common.h"
#include "wx_panel.h"
#include "wx_item.h"

#ifdef IN_CPROTO
typedef void  *wxbCheckBox ;
#else

// Checkbox item (single checkbox)
class wxBitmap ;
class wxbCheckBox: public wxItem
{
 public:
  wxbCheckBox(void);
  wxbCheckBox(wxPanel *panel, wxFunction func, char *Title,
             int x = -1, int y = -1, int width = -1, int height = -1,
             int style = 0, char *name = "checkBox");
  wxbCheckBox(wxPanel *panel, wxFunction func, wxBitmap *bitmap,
             int x = -1, int y = -1, int width = -1, int height = -1,
             int style = 0, char *name = "checkBox");
  ~wxbCheckBox(void);

  void Command(wxCommandEvent& event);
  void ProcessCommand(wxCommandEvent& event);

  virtual void SetValue(Bool) = 0;
  virtual Bool GetValue(void) = 0;
  virtual void SetLabel(wxBitmap *bitmap) = 0;
};

#endif // IN_CPROTO
#endif // wxb_checkh
