/*
|-----------------------------------------------------------------------|
|									|
|	F.Blancher				Mar.	1993		|
|	Fafa	 				Version 1.1		|
|									|
|	Controles Windows 						|
|	Initialisations de la librairie					|
|									|
|	Copyright (c)	FB			Paris			|
|									|
|-----------------------------------------------------------------------|
*/

#include		"fafapriv.h"
#include		<memory.h>

/*
|-----------------------------------------------------------------------|
| Parametres
|-----------------------------------------------------------------------|
*/

LRESULT	WINAPI LoopFafaDialog( HWND w, UINT msg, UINT mw, LPARAM ml ) ;
LRESULT	WINAPI LoopFafaButton( HWND w, UINT msg, UINT mw, LPARAM ml ) ;
LRESULT	WINAPI LoopFafaStatic( HWND w, UINT msg, UINT mw, LPARAM ml ) ;
LRESULT	WINAPI LoopFafaCheck ( HWND w, UINT msg, UINT mw, LPARAM ml ) ;
LRESULT	WINAPI LoopFafaCont  ( HWND w, UINT msg, UINT mw, LPARAM  ) ;

HANDLE	Inst ;

char	FafaWind[] = FAFA_WIND ;
char	FafaButt[] = FAFA_BUTTON ;
char	FafaStat[] = FAFA_STATIC ;
char	FafaChck[] = FAFA_CHECK ;
char	MichButt[] = FAFA_CONT ;

#define	DISABLE_BTM		9100

static	int	MyRegisterClass( void ) ;

/*
|-----------------------------------------------------------------------|
| proc LibMain :
|-----------------------------------------------------------------------|
*/

int InitFafa( HANDLE inst)
{

	Inst = inst ;
	GrisClair = CreateSolidBrush( RGB( 192, 192, 192 ) ) ;

	if ( MyRegisterClass() )
		{
		LOGBRUSH	lb ;

		lb.lbStyle = BS_PATTERN;
		//lb.lbHatch = (LONG)LoadBitmap( Inst, MAKEINTRESOURCE(DISABLE_BTM) ) ;
		//int for Win31. A voir pour Win32
		lb.lbHatch = (int)LoadBitmap( Inst, MAKEINTRESOURCE(DISABLE_BTM) ) ;

		DisableBitmap = CreateBrushIndirect( & lb ) ;
		DeleteObject( (HGDIOBJ)lb.lbHatch ) ;

		GrisFonce = CreatePen( PS_SOLID, 1, RGB( 128, 128, 128 ) ) ;
		return 1 ;
		}
	else	
	{
		DeleteObject( GrisClair ) ;
		GrisClair = NULL ;
	}
	return 0 ;
}

void EndFafa(void)
{
	if (GrisClair)
		DeleteObject(GrisClair) ;
	if (GrisFonce)
		DeleteObject(GrisFonce) ;
	if (DisableBitmap)
		DeleteObject(DisableBitmap) ;

}

/*
|-----------------------------------------------------------------------|
| proc MyRegisterClass :
|-----------------------------------------------------------------------|
*/

static	int	MyRegisterClass( void )
{
	WNDCLASS	w ;

	memset( & w, 0, sizeof w ) ;
	w.lpszClassName = FafaWind ;
	w.hInstance	= Inst ;
	w.lpfnWndProc	= LoopFafaDialog ;
	w.hCursor	= LoadCursor( 0, IDC_ARROW ) ;
	w.hIcon		= LoadIcon( Inst, "fafa_icn") ;
	w.hbrBackground = GrisClair ;
	w.style		= CS_HREDRAW | CS_VREDRAW | CS_DBLCLKS |
				CS_GLOBALCLASS ;
	w.cbWndExtra	= DLGWINDOWEXTRA ;
	if ( ! RegisterClass( & w ) )
		return 0 ;

	w.lpszClassName = FafaButt ;
	w.lpfnWndProc	= LoopFafaButton ;
	w.cbWndExtra	= FB_EXTRA ;
	w.hCursor	= 0 ;
	w.hIcon		= 0 ;
	if ( ! RegisterClass( & w ) )
		return 0 ;

	w.lpszClassName = FafaChck ;
	w.lpfnWndProc	= LoopFafaCheck ;
	if ( ! RegisterClass( & w ) )
		return 0 ;

	w.lpszClassName = MichButt ;
	w.lpfnWndProc	= LoopFafaCont ;
	if ( ! RegisterClass( & w ) )
		return 0 ;

	w.lpszClassName = FafaStat ;
	w.lpfnWndProc	= LoopFafaStatic ;
	w.style		= CS_HREDRAW | CS_VREDRAW | CS_GLOBALCLASS ;
	return RegisterClass( & w ) ;
}

