/*
 * File:     hello.cc
 * Purpose:  Demo for wxWindows class library
 *
 *                       wxWindows 1.50
 * Copyright (c) 1993 Artificial Intelligence Applications Institute,
 *                   The University of Edinburgh
 *
 *                     Author: Julian Smart
 *                        Date: 7-9-93
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose is hereby granted without fee, provided
 * that the above copyright notice, author statement and this permission
 * notice appear in all copies of this software and related documentation.
 *
 * THE SOFTWARE IS PROVIDED "AS-IS" AND WITHOUT WARRANTY OF ANY KIND, EXPRESS,
 * IMPLIED OR OTHERWISE, INCLUDING WITHOUT LIMITATION, ANY WARRANTY OF
 * MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE.
 *
 * IN NO EVENT SHALL THE ARTIFICIAL INTELLIGENCE APPLICATIONS INSTITUTE OR THE
 * UNIVERSITY OF EDINBURGH BE LIABLE FOR ANY SPECIAL, INCIDENTAL, INDIRECT OR
 * CONSEQUENTIAL DAMAGES OF ANY KIND, OR ANY DAMAGES WHATSOEVER RESULTING FROM
 * LOSS OF USE, DATA OR PROFITS, WHETHER OR NOT ADVISED OF THE POSSIBILITY OF
 * DAMAGE, AND ON ANY THEORY OF LIABILITY, ARISING OUT OF OR IN CONNECTION WITH
 * THE USE OR PERFORMANCE OF THIS SOFTWARE.
 */

#ifdef wx_msw
#ifndef WIN32
#pragma hdrfile "c:\c\wx\develop\src\msw\wx.sym"
#endif
#endif

#include "wx.h"
#pragma hdrstop
#include "hello.h"

// Declare two frames
MyFrame   *frame = NULL;
wxFrame   *subframe = NULL;
wxMenuBar *menu_bar = NULL;
MyTimer   the_timer;
Bool      timer_on = FALSE;
wxBitmap  *test_bitmap = NULL;
wxIcon    *test_icon = NULL;
wxMenu	  *scale_menu,*the_file_menu ;

wxButton *btn1,*btn2 ;

// This statement initialises the whole application
MyApp     myApp;

// For drawing lines in a canvas
float     xpos = -1;
float     ypos = -1;

// Must initialise these in OnInit, not statically
wxPen     *red_pen;
wxFont    *small_font;
wxFont    *test_font;

float     zoom_factor = 1.0;

#ifdef wx_x
#include "aiai.xbm"
#include "fload.xbm"
#endif

#define	BUTTON_TAG	1
#define	PIXMAP_TAG	2

// Testing of ressources
MyApp::MyApp()
{
}

// The `main program' equivalent, creating the windows and returning the
// main frame
wxFrame *MyApp::OnInit(void)
{
  // Test of DebugMsg fct
  int w,h ;
  wxDisplaySize(&w,&h) ;
  wxDebugMsg("Screen size %dx%d\n",w,h) ;

  // Test of resources
  char *helloResource = NULL;

  wxGetResource("hello", "test", &helloResource);
  if (helloResource)
    wxDebugMsg("Found hello.test: %s\n", helloResource);

  wxWriteResource("hello", "test", "julian");

  // Create a red pen
  red_pen = new wxPen("RED", 3, wxSOLID);

  // Create a small font
  small_font = new wxFont(10, wxMODERN, wxNORMAL, wxNORMAL);
  test_font = new wxFont(18, wxROMAN, wxITALIC, wxBOLD);

  // Create the main frame window
  frame = new MyFrame(NULL, "Hello wxWindows", 0, 0, 500, 500);

  // Give it a status line
  frame->CreateStatusLine(5);

  // Load icon and bitmap
#ifdef wx_msw
  test_icon = new wxIcon("aiai_icn");
  test_bitmap = new wxBitmap("fload") ;
#endif
#ifdef wx_x
  test_icon = new wxIcon(aiai_bits, aiai_width, aiai_height);
  test_bitmap = new wxBitmap(fload_bits,fload_width,fload_height) ;
#endif

  frame->SetIcon(test_icon);

  // Make a menubar
  wxMenu *file_menu = new wxMenu;
  the_file_menu = file_menu ;

  file_menu->Append(HELLO_LOAD_FILE, "&Load file",      "Load a text file");

  wxMenu *pullright_menu = new wxMenu("Title Scale");
  scale_menu = pullright_menu ;
  pullright_menu->Append(HELLO_TWIPS, "&Twips",         "Twips scale");
  pullright_menu->Append(HELLO_LOMETRIC, "&10th mm",    "Metric scale (0.1 mm)");
  pullright_menu->Append(HELLO_METRIC, "&Metric",       "Metric scale (mm)");
  pullright_menu->Append(HELLO_NORMAL, "&Normal size",  "Pixel scale");
  pullright_menu->Append(HELLO_ZOOM, "&Zoom...",        "Zoom by specified amount");

  file_menu->Append(HELLO_SCALE, "&Scale picture", pullright_menu, "Scale picture");

  file_menu->AppendSeparator();
  file_menu->Append(HELLO_PRINT_EPS, "Print to &EPS file", 
                                                        "Print to EPS file");
#ifdef wx_msw
  file_menu->Append(HELLO_PRINT, "&Print",              "Print picture");
  file_menu->Append(HELLO_COPY_MF, "&Copy metafile to clipboard",
                                                        "Copy metafile to clipboard");
#endif
  file_menu->AppendSeparator();
  file_menu->Append(HELLO_QUIT, "&Quit",                "Quit program");

  wxMenu *timer_menu = new wxMenu;
  timer_menu->Append(HELLO_TIMER_ON, "Timer &on",       "Turn timer on");
  timer_menu->Append(HELLO_TIMER_OFF, "Timer o&ff",     "Turn timer off");

  wxMenu *cursor_menu = new wxMenu;
  cursor_menu->Append(wxCURSOR_ARROW, "Arrow");
  cursor_menu->Append(wxCURSOR_WAIT, "Wait");
  cursor_menu->Append(wxCURSOR_IBEAM, "Ibeam");
  cursor_menu->Append(wxCURSOR_CROSS, "Cross");
  cursor_menu->Append(wxCURSOR_SIZENWSE, "Size NWSE");
  cursor_menu->Append(wxCURSOR_SIZENESW, "Size NESW");
  cursor_menu->Append(wxCURSOR_SIZEWE, "Size WE");
  cursor_menu->Append(wxCURSOR_SIZENS, "Size NS");
  cursor_menu->Append(wxCURSOR_PENCIL, "Pencil");
  cursor_menu->Append(wxCURSOR_BULLSEYE, "Bullseye");
  cursor_menu->Append(wxCURSOR_MAGNIFIER, "Magnifier");
  cursor_menu->Append(wxCURSOR_HAND, "Hand");
  cursor_menu->Append(wxCURSOR_NO_ENTRY, "No Entry");
  cursor_menu->Append(wxCURSOR_CHAR, "Char");
  cursor_menu->Append(wxCURSOR_LEFT_BUTTON, "Left Button");
  cursor_menu->Append(wxCURSOR_RIGHT_BUTTON, "Right Button");
  cursor_menu->Append(wxCURSOR_MIDDLE_BUTTON, "Middle Button");
  cursor_menu->Append(wxCURSOR_QUESTION_ARROW, "Question arrow");
  cursor_menu->Append(wxCURSOR_SIZING, "Sizing");
  cursor_menu->Append(wxCURSOR_SPRAYCAN, "Spraycan");
  cursor_menu->Append(wxCURSOR_WATCH, "Watch");
  cursor_menu->Append(wxCURSOR_POINT_LEFT, "Point left");
  cursor_menu->Append(wxCURSOR_POINT_RIGHT, "Point right");
  cursor_menu->Append(wxCURSOR_PAINT_BRUSH, "Paint brush");

  wxMenu *help_menu = new wxMenu;
  help_menu->Append(HELLO_ABOUT, "&About",              "About Hello wxWindows");

  menu_bar = new wxMenuBar;

  menu_bar->Append(file_menu, "&File");
  menu_bar->Append(timer_menu, "&Timer");
  menu_bar->Append(cursor_menu, "&Cursor");
  menu_bar->Append(help_menu, "&Help");

  // Associate the menu bar with the frame
  frame->SetMenuBar(menu_bar);

  menu_bar->Enable(HELLO_TIMER_ON, TRUE);
  menu_bar->Enable(HELLO_TIMER_OFF, FALSE);

  // Make a panel
  frame->panel = new wxPanel(frame, 0, 0, 500, 500, wxBORDER, "MyMainFrame");
  frame->panel->SetLabelPosition(wxVERTICAL);
  frame->panel->SetLabelFont(test_font) ;
  frame->panel->SetButtonFont(small_font) ;

  // Create some panel items

  btn1 = new wxButton(frame->panel, (wxFunction)&button_proc, "A button") ;
  btn1->SetClientData((char*)BUTTON_TAG) ;

  btn2 = new wxButton(frame->panel, (wxFunction)&button_proc, test_bitmap) ;
  btn2->SetClientData((char*)PIXMAP_TAG) ;

  (void)new wxText(frame->panel, (wxFunction)&text_proc, "A text item", "Initial value") ;

  (void)new wxCheckBox(frame->panel, (wxFunction)&check_proc , "A check box");

  frame->panel->NewLine();

  char *choice_strings[4];
  choice_strings[0] = "Julian";
  choice_strings[1] = "Hattie";
  choice_strings[2] = "Ken";
  choice_strings[3] = "Dick";

  wxChoice *choice = new wxChoice(frame->panel, NULL, "A choice item",
                     -1, -1, -1, -1, 4, choice_strings);
  choice->SetSelection(0);

  frame->panel->SetLabelPosition(wxVERTICAL) ;
  char *radio_strings[6];
  radio_strings[0] = "1";
  radio_strings[1] = "2";
  radio_strings[2] = "3";
  radio_strings[3] = "4";
  radio_strings[4] = "5";
  radio_strings[5] = "6";
  (void)new wxRadioBox(frame->panel,NULL,"Radio",-1,-1,-1,-1,6,radio_strings,2,wxFLAT);

  (void)new wxMessage(frame->panel, "Hello! A simple message");

  frame->panel->SetLabelPosition(wxHORIZONTAL) ;
  wxListBox *list = new wxListBox(frame->panel, (wxFunction)&list_proc, "A list",
                                  wxSINGLE|wxALWAYS_SB, -1, -1, 150, 100);
  list->Append("Apple");
  list->Append("Pear");
  list->Append("Orange");
  list->Append("Banana");
  list->Append("Fruit");
  
  frame->panel->NewLine();

  (void)new wxSlider(frame->panel, NULL, "A slider",
                     40, 22, 101, 150);

  (void)new wxMultiText(frame->panel, (wxFunction)NULL, "Multiline text", "Some text");

  // Make a text window
  frame->text_window = new MyTextWindow(frame, 0, 250, 400, 250, 0);

  // Make another frame, containing a canvas
  subframe = new wxFrame(NULL, "Canvas Frame", 300, 300, 400, 300);

  int width, height;
  subframe->GetClientSize(&width, &height);

  MyCanvas *canvas = new MyCanvas(subframe, 0, 0, width, height, wxRETAINED);

  wxCursor *cursor = new wxCursor(wxCURSOR_PENCIL);
  canvas->SetCursor(cursor);

  // Give it scrollbars: the virtual canvas is 20 * 50 = 1000 pixels in each direction
  canvas->SetScrollbars(20, 20, 50, 50, 4, 4);
  canvas->SetPen(red_pen);
  frame->canvas = canvas;

  frame->Show(TRUE);
  subframe->Show(TRUE);

  // Load a file into the text window
  frame->text_window->LoadFile("welcome.txt");
  frame->SetStatusText("Hello, wxWindows");

  frame->panel->Fit() ;
  frame->Fit() ;
  // Return the main frame window
  return frame;
}

// Define my frame constructor
MyFrame::MyFrame(wxFrame *frame, char *title, int x, int y, int w, int h):
  wxFrame(frame, title, x, y, w, h)
{
  panel = NULL;
  text_window = NULL;
}

// Intercept menu commands
void MyFrame::OnMenuCommand(int id)
{
  wxDC *dc = canvas->GetDC();
  switch (id)
  {
    case HELLO_LOAD_FILE:
    {
      char *s = wxFileSelector("Load text file", NULL, NULL, NULL, "*.txt");
      if (s)
        frame->text_window->LoadFile(s);
      break;
    }
    case HELLO_TWIPS:
    {
      dc->SetMapMode(MM_TWIPS);
      dc->Clear();
      // last param required for cl386
      Draw(*dc,TRUE);
      break;
    }
    case HELLO_METRIC:
    {
      dc->SetMapMode(MM_METRIC);
      dc->Clear();
      // last param required for cl386
      Draw(*dc,TRUE);
      break;
    }
    case HELLO_LOMETRIC:
    {
      dc->SetMapMode(MM_LOMETRIC);
      dc->Clear();
      // last param required for cl386
      Draw(*dc,TRUE);
      break;
    }
    case HELLO_NORMAL:
    {
      dc->SetUserScale(1.0, 1.0);
      dc->SetMapMode(MM_TEXT);
      dc->Clear();
      // last param required for cl386
      Draw(*dc,TRUE);
      break;
    }
    case HELLO_ZOOM:
    {
      char *zoom_factor_s = FloatToString(zoom_factor);
      zoom_factor_s = wxGetTextFromUser("Enter new zoom factor", "Input", zoom_factor_s);
      if (zoom_factor_s)
      {
        StringToFloat(zoom_factor_s, &zoom_factor);
        dc->SetUserScale(zoom_factor, zoom_factor);
        dc->Clear();
        // last param required for cl386
        Draw(*dc,TRUE);
      }
      break;
    }
    case HELLO_QUIT:
    {
      OnClose();
      delete this;
      break;
    }
    case HELLO_PRINT_EPS:
    {
      wxPostScriptDC dc(NULL, TRUE);
      if (dc.Ok())
      {
        dc.StartDoc("Hello printout");
        dc.StartPage();
        // last param required for cl386
        Draw(dc,TRUE);
        dc.EndPage();
        dc.EndDoc();
      }
      break;
    }
#ifdef wx_msw
    case HELLO_PRINT:
    {
      wxPrinterDC dc(NULL, NULL, NULL);
      if (dc.Ok())
      {
        dc.StartDoc("Hello printout");
        dc.StartPage();
        Draw(dc, FALSE);
        dc.EndPage();
        dc.EndDoc();
      }
      break;
    }
    case HELLO_COPY_MF:
    {
      wxMetaFileDC dc;
      if (dc.Ok())
      {
        Draw(dc, FALSE);
        wxMetaFile *mf = dc.Close();
        if (mf)
        {
          Bool success = mf->SetClipboard((int)(dc.MaxX() + 10), (int)(dc.MaxY() + 10));
          delete mf;
        }
      }
      break;
    }
#endif
    case HELLO_ABOUT:
    {
      (void)wxMessageBox("wxWindows GUI library demo Vsn 1.50\nAuthor: Julian Smart J.Smart@ed.ac.uk\nAIAI (c) 1993", "About wxHello");
      break;
    }
    case HELLO_TIMER_ON:
    {
      the_timer.Start(5000);
      timer_on = TRUE;
      menu_bar->Enable(HELLO_TIMER_ON, FALSE);
      menu_bar->Enable(HELLO_TIMER_OFF, TRUE);
      break;
    }
    case HELLO_TIMER_OFF:
    {
      the_timer.Stop();
      menu_bar->Enable(HELLO_TIMER_ON, TRUE);
      menu_bar->Enable(HELLO_TIMER_OFF, FALSE);
      break;
    }
    default:
    {
      wxCursor *cursor = new wxCursor(id);
      frame->canvas->SetCursor(cursor);
      break;
    }
  }
}

// Size the subwindows when the frame is resized
void MyFrame::OnSize(int w, int h)
{
  if (panel && text_window)
  {
    int width, height;
    GetClientSize(&width, &height);
    panel->SetSize(0, 0, width, (int)(height/2));
    text_window->SetSize(0, (int)(height/2), width, (int)(height/2));
  }
}

void MyFrame::Draw(wxDC& dc, Bool draw_bitmaps)
{
  dc.SetFont(small_font);

  dc.SetPen(wxGREEN_PEN);
  dc.DrawLine(0.0, 0.0, 200.0, 200.0);
  dc.DrawLine(200.0, 0.0, 0.0, 200.0);

  dc.SetBrush(wxCYAN_BRUSH);
  dc.SetPen(wxRED_PEN);
  dc.DrawRectangle(100.0, 100.0, 100.0, 50.0);
  // cl386 (NT compiler) doesn't like defaults values...
  dc.DrawRoundedRectangle(150.0, 150.0, 100.0, 50.0,20.0);

  dc.SetClippingRegion(150.0, 150.0, 100.0, 50.0);
  dc.DrawText("This text should be clipped within the rectangle", 150.0, 170.0);
  dc.DestroyClippingRegion();

  dc.DrawEllipse(250.0, 250.0, 100.0, 50.0);
  dc.DrawSpline(50.0, 200.0, 50.0, 100.0, 200.0, 10.0);
  dc.DrawLine(50.0, 230.0, 200.0, 230.0);
  dc.DrawText("This is a test string", 50.0, 230.0);

  dc.SetPen(wxBLACK_PEN);
  dc.DrawArc(50.0, 300.0, 100.0, 250.0, 100.0, 300.0);

  if (draw_bitmaps)
  {
    // The easy way to draw bitmaps, using icons
    dc.DrawIcon(test_icon, 250.0, 50.0);

/*  An alternative way to draw bitmaps.
    wxMemoryDC temp_dc(dc);
    temp_dc.SelectObject(test_bitmap);
    dc.Blit(250, 50, BITMAP_WIDTH, BITMAP_HEIGHT, &temp_dc, 0, 0);
*/
    char buf[10];
    for (int i = 0; i < 1000; i += 50)
    {
      sprintf(buf, "%d", i);
      dc.DrawText(buf, (float)i, (float)400);
    }
  }
}

// Define a constructor for my canvas
MyCanvas::MyCanvas(wxFrame *frame, int x, int y, int w, int h, int style):
 wxCanvas(frame, x, y, w, h, style)
{
}

// Define the repainting behaviour
void MyCanvas::OnPaint(void)
{
  // need the last param for cl386.
  frame->Draw(*(GetDC()),TRUE);
}

// This implements a tiny doodling program! Drag the mouse using
// the left button.
void MyCanvas::OnEvent(wxMouseEvent& event)
{
  SetPen(wxBLACK_PEN);
  SetBrush(wxTRANSPARENT_BRUSH);
  float x, y;
  event.Position(&x, &y);
  if (event.RightDown())
  {
    x = -1; y = -1;
    GetDC()->SetLogicalFunction(wxINVERT);
  }
  else if (event.RightUp())
  {
    GetDC()->SetLogicalFunction(wxCOPY);
  }
  else if (event.Dragging() && event.RightIsDown())
  {
    // Test out inversion
    // Erase old one...
    if (xpos != -1 && ypos != -1)
      GetDC()->DrawRectangle(xpos - 50, ypos - 50, 100, 100);
    // ...draw new one.
    GetDC()->DrawRectangle(x - 50, y - 50, 100, 100);
  }
  else
  {
    if (xpos > -1 && ypos > -1 && event.Dragging())
    {
      DrawLine(xpos, ypos, x, y);
    }
  }
  xpos = x;
  ypos = y;
}

// Intercept character input
void MyCanvas::OnChar(wxKeyEvent& event)
{
  char buf[2];
  buf[0] = (char)event.KeyCode();
  buf[1] = 0;
  frame->SetStatusText(buf,1);

  // Process the default behaviour
  wxCanvas::OnChar(event);
}

// Define the behaviour for the frame closing
// - must delete all frames except for the main one.
Bool MyFrame::OnClose(void)
{
  if (subframe)
    delete subframe;

  return TRUE;
}

void quit_proc(wxButton& but, wxCommandEvent& event)
{
  wxDialogBox *box = (wxDialogBox *)but.GetParent();
  box->Show(FALSE);
  delete box;
}

// Gets some user input, and sets the status line
void text_proc(wxText& but, wxCommandEvent& event)
{
  if (event.eventType==wxEVENT_TYPE_TEXT_COMMAND)
	wxDebugMsg("Value changed\n") ;
  else if (event.eventType==wxEVENT_TYPE_TEXT_ENTER_COMMAND)
	wxDebugMsg("Enter key\n") ;
  else
	wxDebugMsg("??\n") ;
  wxDebugMsg("Text value '%s'\n",but.GetValue()) ;
}

// Gets some user input, and sets the status line
void check_proc(wxCheckBox& but, wxCommandEvent& event)
{
  btn2->Enable(!but.GetValue()) ; // test of insensitive Pixmap
}

// Gets some user input, and sets the status line
void button_proc(wxButton& but, wxCommandEvent& event)
{
  int choice ;
  
  int tag = (int)but.GetClientData() ;
  if (tag==PIXMAP_TAG)
  {
    frame->OnMenuCommand(HELLO_LOAD_FILE) ;
    return ;
  }
  
  choice = wxMessageBox("Press OK to continue", "Try me",
                        wxOK | wxCANCEL,frame) ;
  if (choice == wxOK)
  {
    char *text = wxGetTextFromUser("Enter some text", "Text input", "");
    if (text)
    {
      (void)wxMessageBox(text, "Result", wxOK);

      frame->SetStatusText(text,2);
    }
  }
}

// Put some text into the text window
void list_proc(wxListBox& list, wxCommandEvent& event)
{
  // Test of list callback
  wxDebugMsg ("List select. Item %d string '%s'\n",
              event.commandInt,event.commandString) ;
  *(frame->text_window) << event.commandString;
  int *liste,count ;
  count = list.GetSelections(&liste) ;
  for (int i =0;i<count;i++)
	wxDebugMsg("Selection %d\n",liste[i]) ;
  wxDebugMsg("\n") ;
}

void GenericOk(wxButton& but, wxCommandEvent& event)
{
  wxDialogBox *dialog = (wxDialogBox *)but.GetParent();

  dialog->Show(FALSE);
}

// Timer notify proc
void MyTimer::Notify(void)
{
  *(frame->text_window) << "Timer went!\n";
}
