%{
enum { EAX=0, ECX=1, EDX=2, EBX=3, ESI=6, EDI=7 };
#include "c.h"
#define NODEPTR_TYPE Node
#define OP_LABEL(p) ((p)->op)
#define LEFT_CHILD(p) ((p)->kids[0])
#define RIGHT_CHILD(p) ((p)->kids[1])
#define STATE_LABEL(p) ((p)->x.state)
static void address(Symbol, Symbol, long);
static void blkfetch(int, int, int, int);
static void blkloop(int, int, int, int, int, int[]);
static void blkstore(int, int, int, int);
static void defaddress(Symbol);
static void defconst(int, int, Value);
static void defstring(int, char *);
static void defsymbol(Symbol);
static void doarg(Node);
static void emit2(Node);
static void export(Symbol);
static void clobber(Node);
static void function(Symbol, Symbol [], Symbol [], int);
static void global(Symbol);
static void import(Symbol);
static void local(Symbol);
static void progbeg(int, char **);
static void progend(void);
static void segment(int);
static void space(int);
static void target(Node);
extern int ckstack(Node, int);
extern int memop(Node);
extern int sametree(Node, Node);
static Symbol charreg[32], shortreg[32], intreg[32];
static Symbol fltreg[32];

static Symbol charregw, shortregw, intregw, fltregw;

static int cseg;

static Symbol quo, rem;

%}
%start stmt
%term CNSTF4=4113
%term CNSTF8=8209
%term CNSTF16=16401
%term CNSTI1=1045
%term CNSTI2=2069
%term CNSTI4=4117
%term CNSTI8=8213
%term CNSTP4=4119
%term CNSTP8=8215
%term CNSTU1=1046
%term CNSTU2=2070
%term CNSTU4=4118
%term CNSTU8=8214
 
%term ARGB=41
%term ARGF4=4129
%term ARGF8=8225
%term ARGF16=16417
%term ARGI4=4133
%term ARGI8=8229
%term ARGP4=4135
%term ARGP8=8231
%term ARGU4=4134
%term ARGU8=8230

%term ASGNB=57
%term ASGNF4=4145
%term ASGNF8=8241
%term ASGNF16=16433
%term ASGNI1=1077
%term ASGNI2=2101
%term ASGNI4=4149
%term ASGNI8=8245
%term ASGNP4=4151
%term ASGNP8=8247
%term ASGNU1=1078
%term ASGNU2=2102
%term ASGNU4=4150
%term ASGNU8=8246

%term INDIRB=73
%term INDIRF4=4161
%term INDIRF8=8257
%term INDIRF16=16449
%term INDIRI1=1093
%term INDIRI2=2117
%term INDIRI4=4165
%term INDIRI8=8261
%term INDIRP4=4167
%term INDIRP8=8263
%term INDIRU1=1094
%term INDIRU2=2118
%term INDIRU4=4166
%term INDIRU8=8262

%term CVFF4=4209
%term CVFF8=8305
%term CVFF16=16497
%term CVFI4=4213
%term CVFI8=8309

%term CVIF4=4225
%term CVIF8=8321
%term CVIF16=16513
%term CVII1=1157
%term CVII2=2181
%term CVII4=4229
%term CVII8=8325
%term CVIU1=1158
%term CVIU2=2182
%term CVIU4=4230
%term CVIU8=8326

%term CVPP4=4247
%term CVPP8=8343
%term CVPP16=16535
%term CVPU4=4246
%term CVPU8=8342

%term CVUI1=1205
%term CVUI2=2229
%term CVUI4=4277
%term CVUI8=8373
%term CVUP4=4279
%term CVUP8=8375
%term CVUP16=16567
%term CVUU1=1206
%term CVUU2=2230
%term CVUU4=4278
%term CVUU8=8374

%term NEGF4=4289
%term NEGF8=8385
%term NEGF16=16577
%term NEGI4=4293
%term NEGI8=8389

%term CALLB=217
%term CALLF4=4305
%term CALLF8=8401
%term CALLF16=16593
%term CALLI4=4309
%term CALLI8=8405
%term CALLP4=4311
%term CALLP8=8407
%term CALLU4=4310
%term CALLU8=8406
%term CALLV=216

%term RETF4=4337
%term RETF8=8433
%term RETF16=16625
%term RETI4=4341
%term RETI8=8437
%term RETP4=4343
%term RETP8=8439
%term RETU4=4342
%term RETU8=8438
%term RETV=248

%term ADDRGP4=4359
%term ADDRGP8=8455

%term ADDRFP4=4375
%term ADDRFP8=8471

%term ADDRLP4=4391
%term ADDRLP8=8487

%term ADDF4=4401
%term ADDF8=8497
%term ADDF16=16689
%term ADDI4=4405
%term ADDI8=8501
%term ADDP4=4407
%term ADDP8=8503
%term ADDU4=4406
%term ADDU8=8502

%term SUBF4=4417
%term SUBF8=8513
%term SUBF16=16705
%term SUBI4=4421
%term SUBI8=8517
%term SUBP4=4423
%term SUBP8=8519
%term SUBU4=4422
%term SUBU8=8518

%term LSHI4=4437
%term LSHI8=8533
%term LSHU4=4438
%term LSHU8=8534

%term MODI4=4453
%term MODI8=8549
%term MODU4=4454
%term MODU8=8550

%term RSHI4=4469
%term RSHI8=8565
%term RSHU4=4470
%term RSHU8=8566

%term BANDI4=4485
%term BANDI8=8581
%term BANDU4=4486
%term BANDU8=8582

%term BCOMI4=4501
%term BCOMI8=8597
%term BCOMU4=4502
%term BCOMU8=8598

%term BORI4=4517
%term BORI8=8613
%term BORU4=4518
%term BORU8=8614

%term BXORI4=4533
%term BXORI8=8629
%term BXORU4=4534
%term BXORU8=8630

%term DIVF4=4545
%term DIVF8=8641
%term DIVF16=16833
%term DIVI4=4549
%term DIVI8=8645
%term DIVU4=4550
%term DIVU8=8646

%term MULF4=4561
%term MULF8=8657
%term MULF16=16849
%term MULI4=4565
%term MULI8=8661
%term MULU4=4566
%term MULU8=8662

%term EQF4=4577
%term EQF8=8673
%term EQF16=16865
%term EQI4=4581
%term EQI8=8677
%term EQU4=4582
%term EQU8=8678

%term GEF4=4593
%term GEF8=8689
%term GEI4=4597
%term GEI8=8693
%term GEI16=16885
%term GEU4=4598
%term GEU8=8694

%term GTF4=4609
%term GTF8=8705
%term GTF16=16897
%term GTI4=4613
%term GTI8=8709
%term GTU4=4614
%term GTU8=8710

%term LEF4=4625
%term LEF8=8721
%term LEF16=16913
%term LEI4=4629
%term LEI8=8725
%term LEU4=4630
%term LEU8=8726

%term LTF4=4641
%term LTF8=8737
%term LTF16=16929
%term LTI4=4645
%term LTI8=8741
%term LTU4=4646
%term LTU8=8742

%term NEF4=4657
%term NEF8=8753
%term NEF16=16945
%term NEI4=4661
%term NEI8=8757
%term NEU4=4662
%term NEU8=8758

%term JUMPV=584

%term LABELV=600

%term LOADB=233
%term LOADF4=4321
%term LOADF8=8417
%term LOADF16=16609
%term LOADI1=1253
%term LOADI2=2277
%term LOADI4=4325
%term LOADI8=8421
%term LOADP4=4327
%term LOADP8=8423
%term LOADU1=1254
%term LOADU2=2278
%term LOADU4=4326
%term LOADU8=8422

%term VREGP=711
%%
reg:  INDIRI1(VREGP)     "# read register\n"
reg:  INDIRU1(VREGP)     "# read register\n"

reg:  INDIRI2(VREGP)     "# read register\n"
reg:  INDIRU2(VREGP)     "# read register\n"

reg:  INDIRF4(VREGP)     "# read register\n"
reg:  INDIRI4(VREGP)     "# read register\n"
reg:  INDIRP4(VREGP)     "# read register\n"
reg:  INDIRU4(VREGP)     "# read register\n"

reg:  INDIRF8(VREGP)     "# read register\n"
reg:  INDIRI8(VREGP)     "# read register\n"
reg:  INDIRP8(VREGP)     "# read register\n"
reg:  INDIRU8(VREGP)     "# read register\n"

stmt: ASGNI1(VREGP,reg)  "# write register\n"
stmt: ASGNU1(VREGP,reg)  "# write register\n"

stmt: ASGNI2(VREGP,reg)  "# write register\n"
stmt: ASGNU2(VREGP,reg)  "# write register\n"

stmt: ASGNF4(VREGP,reg)  "# write register\n"
stmt: ASGNI4(VREGP,reg)  "# write register\n"
stmt: ASGNP4(VREGP,reg)  "# write register\n"
stmt: ASGNU4(VREGP,reg)  "# write register\n"

stmt: ASGNF8(VREGP,reg)  "# write register\n"
stmt: ASGNI8(VREGP,reg)  "# write register\n"
stmt: ASGNP8(VREGP,reg)  "# write register\n"
stmt: ASGNU8(VREGP,reg)  "# write register\n"
con: CNSTI1  "%a"
con: CNSTU1  "%a"

con: CNSTI2  "%a"
con: CNSTU2  "%a"

con: CNSTI4  "%a"
con: CNSTU4  "%a"
con: CNSTP4  "%a"

con: CNSTI8  "%a"
con: CNSTU8  "%a"
con: CNSTP8  "%a"
stmt: reg  ""
acon: ADDRGP4  "(%a)"
acon: con     "(%0)"
base: ADDRGP4          "(%a)"
base: reg              "[%0]"
base: ADDI4(reg,acon)  "%1[%0]"
base: ADDP4(reg,acon)  "%1[%0]"
base: ADDU4(reg,acon)  "%1[%0]"
base: ADDRFP4  "(%a)[ebp]"
base: ADDRLP4  "(%a)[ebp]"
index: reg "%0"
index: LSHI4(reg,con1)  "%0*2"
index: LSHI4(reg,con2)  "%0*4"
index: LSHI4(reg,con3)  "%0*8"

con1:  CNSTI4  "1"  range(a, 1, 1)
con1:  CNSTU4  "1"  range(a, 1, 1)
con2:  CNSTI4  "2"  range(a, 2, 2)
con2:  CNSTU4  "2"  range(a, 2, 2)
con3:  CNSTI4  "3"  range(a, 3, 3)
con3:  CNSTU4  "3"  range(a, 3, 3)
index: LSHU4(reg,con1)  "%0*2"
index: LSHU4(reg,con2)  "%0*4"
index: LSHU4(reg,con3)  "%0*8"
addr: base              "%0"
addr: ADDI4(index,base)  "%1[%0]"
addr: ADDP4(index,base)  "%1[%0]"
addr: ADDU4(index,base)  "%1[%0]"
addr: index  "[%0]"
mem: INDIRI1(addr)  "byte ptr %0"
mem: INDIRI2(addr)  "word ptr %0"
mem: INDIRI4(addr)  "dword ptr %0"
mem: INDIRU1(addr)  "byte ptr %0"
mem: INDIRU2(addr)  "word ptr %0"
mem: INDIRU4(addr)  "dword ptr %0"
mem: INDIRP4(addr)  "dword ptr %0"
rc:   reg  "%0"
rc:   con  "%0"

mr:   reg  "%0"
mr:   mem  "%0"

mrc0: mem  "%0"
mrc0: rc   "%0"
mrc1: mem  "%0"  1
mrc1: rc   "%0"

mrc3: mem  "%0"  3
mrc3: rc   "%0"
reg: addr         "lea %c,%0\n"  1
reg: mrc0         "mov %c,%0\n"  1
reg: LOADI1(reg)  "# move\n"  1
reg: LOADI2(reg)  "# move\n"  1
reg: LOADI4(reg)  "# move\n"  move(a)
reg: LOADU1(reg)  "# move\n"  1
reg: LOADU2(reg)  "# move\n"  1
reg: LOADU4(reg)  "# move\n"  move(a)
reg: LOADP4(reg)  "# move\n"  move(a)
reg: ADDI4(reg,mrc1)  "?mov %c,%0\nadd %c,%1\n"  1
reg: ADDP4(reg,mrc1)  "?mov %c,%0\nadd %c,%1\n"  1
reg: ADDU4(reg,mrc1)  "?mov %c,%0\nadd %c,%1\n"  1
reg: SUBI4(reg,mrc1)  "?mov %c,%0\nsub %c,%1\n"  1
reg: SUBP4(reg,mrc1)  "?mov %c,%0\nsub %c,%1\n"  1
reg: SUBU4(reg,mrc1)  "?mov %c,%0\nsub %c,%1\n"  1
reg: BANDI4(reg,mrc1)  "?mov %c,%0\nand %c,%1\n"  1
reg: BORI4(reg,mrc1)   "?mov %c,%0\nor %c,%1\n"   1
reg: BXORI4(reg,mrc1)  "?mov %c,%0\nxor %c,%1\n"  1
reg: BANDU4(reg,mrc1)  "?mov %c,%0\nand %c,%1\n"  1
reg: BORU4(reg,mrc1)   "?mov %c,%0\nor %c,%1\n"   1
reg: BXORU4(reg,mrc1)  "?mov %c,%0\nxor %c,%1\n"  1
stmt: ASGNI4(addr,ADDI4(mem,con1))  "inc %1\n"  memop(a)
stmt: ASGNI4(addr,ADDU4(mem,con1))  "inc %1\n"  memop(a)
stmt: ASGNP4(addr,ADDP4(mem,con1))  "inc %1\n"  memop(a)
stmt: ASGNI4(addr,SUBI4(mem,con1))  "dec %1\n"  memop(a)
stmt: ASGNI4(addr,SUBU4(mem,con1))  "dec %1\n"  memop(a)
stmt: ASGNP4(addr,SUBP4(mem,con1))  "dec %1\n"  memop(a)
stmt: ASGNI4(addr,ADDI4(mem,rc))   "add %1,%2\n"  memop(a)
stmt: ASGNI4(addr,SUBI4(mem,rc))   "sub %1,%2\n"  memop(a)
stmt: ASGNU4(addr,ADDU4(mem,rc))   "add %1,%2\n"  memop(a)
stmt: ASGNU4(addr,SUBU4(mem,rc))   "sub %1,%2\n"  memop(a)

stmt: ASGNI4(addr,BANDI4(mem,rc))  "and %1,%2\n"  memop(a)
stmt: ASGNI4(addr,BORI4(mem,rc))   "or %1,%2\n"   memop(a)
stmt: ASGNI4(addr,BXORI4(mem,rc))  "xor %1,%2\n"  memop(a)
stmt: ASGNU4(addr,BANDU4(mem,rc))  "and %1,%2\n"  memop(a)
stmt: ASGNU4(addr,BORU4(mem,rc))   "or %1,%2\n"   memop(a)
stmt: ASGNU4(addr,BXORU4(mem,rc))  "xor %1,%2\n"  memop(a)
reg: BCOMI4(reg)  "?mov %c,%0\nnot %c\n"  2
reg: BCOMU4(reg)  "?mov %c,%0\nnot %c\n"  2
reg: NEGI4(reg)   "?mov %c,%0\nneg %c\n"  2

stmt: ASGNI4(addr,BCOMI4(mem))  "not %1\n"  memop(a)
stmt: ASGNU4(addr,BCOMU4(mem))  "not %1\n"  memop(a)
stmt: ASGNI4(addr,NEGI4(mem))   "neg %1\n"  memop(a)
reg: LSHI4(reg,con5)  "?mov %c,%0\nsal %c,%1\n"  2
reg: LSHU4(reg,con5)  "?mov %c,%0\nshl %c,%1\n"  2
reg: RSHI4(reg,con5)  "?mov %c,%0\nsar %c,%1\n"  2
reg: RSHU4(reg,con5)  "?mov %c,%0\nshr %c,%1\n"  2

stmt: ASGNI4(addr,LSHI4(mem,con5))  "sal %1,%2\n"  memop(a)
stmt: ASGNI4(addr,LSHU4(mem,con5))  "shl %1,%2\n"  memop(a)
stmt: ASGNI4(addr,RSHI4(mem,con5))  "sar %1,%2\n"  memop(a)
stmt: ASGNI4(addr,RSHU4(mem,con5))  "shr %1,%2\n"  memop(a)

con5: CNSTI4  "%a"  range(a, 0, 31)

reg: LSHI4(reg,reg)  "?mov %c,%0\nmov ecx,%1\nsal %c,cl\n"  3
reg: LSHU4(reg,reg)  "?mov %c,%0\nmov ecx,%1\nshl %c,cl\n"  2
reg: RSHI4(reg,reg)  "?mov %c,%0\nmov ecx,%1\nsar %c,cl\n"  2
reg: RSHU4(reg,reg)  "?mov %c,%0\nmov ecx,%1\nshr %c,cl\n"  2
reg: MULI4(reg,mrc3)  "?mov %c,%0\nimul %c,%1\n"  14
reg: MULI4(con,mr)    "imul %c,%1,%0\n"  13
reg: MULU4(reg,mr)  "mul %1\n"  13
reg: DIVU4(reg,reg)  "xor edx,edx\ndiv %1\n"
reg: MODU4(reg,reg)  "xor edx,edx\ndiv %1\n"
reg: DIVI4(reg,reg)  "cdq\nidiv %1\n"
reg: MODI4(reg,reg)  "cdq\nidiv %1\n"
reg: CVPU4(reg)  "mov %c,%0\n"  move(a)
reg: CVUP4(reg)  "mov %c,%0\n"  move(a)
reg: CVII4(INDIRI1(addr))  "movsx %c,byte ptr %0\n"  3
reg: CVII4(INDIRI2(addr))  "movsx %c,word ptr %0\n"  3
reg: CVUU4(INDIRU1(addr))  "movzx %c,byte ptr %0\n"  3
reg: CVUU4(INDIRU2(addr))  "movzx %c,word ptr %0\n"  3
reg: CVII4(reg)  "# extend\n"  3
reg: CVIU4(reg)  "# extend\n"  3
reg: CVUI4(reg)  "# extend\n"  3
reg: CVUU4(reg)  "# extend\n"  3

reg: CVII1(reg)  "# truncate\n"  1
reg: CVII2(reg)  "# truncate\n"  1
reg: CVUU1(reg)  "# truncate\n"  1
reg: CVUU2(reg)  "# truncate\n"  1
stmt: ASGNI1(addr,rc)  "mov byte ptr %0,%1\n"   1
stmt: ASGNI2(addr,rc)  "mov word ptr %0,%1\n"   1
stmt: ASGNI4(addr,rc)  "mov dword ptr %0,%1\n"  1
stmt: ASGNU1(addr,rc)  "mov byte ptr %0,%1\n"   1
stmt: ASGNU2(addr,rc)  "mov word ptr %0,%1\n"   1
stmt: ASGNU4(addr,rc)  "mov dword ptr %0,%1\n"  1
stmt: ASGNP4(addr,rc)  "mov dword ptr %0,%1\n"  1
stmt: ARGI4(mrc3)  "push %0\n"  1
stmt: ARGU4(mrc3)  "push %0\n"  1
stmt: ARGP4(mrc3)  "push %0\n"  1
stmt: ASGNB(reg,INDIRB(reg))  "mov ecx,%a\nrep movsb\n"
stmt: ARGB(INDIRB(reg))  "sub esp,%a\nmov edi,esp\nmov ecx,%a\nrep movsb\n"

memf: INDIRF8(addr)         "qword ptr %0"
memf: INDIRF4(addr)         "dword ptr %0"
memf: CVFF8(INDIRF4(addr))  "dword ptr %0"
reg: memf  "fld %0\n"  3
stmt: ASGNF8(addr,reg)         "fstp qword ptr %0\n"  7
stmt: ASGNF4(addr,reg)         "fstp dword ptr %0\n"  7
stmt: ASGNF4(addr,CVFF4(reg))  "fstp dword ptr %0\n"  7
stmt: ARGF8(reg)  "sub esp,8\nfstp qword ptr [esp]\n"
stmt: ARGF4(reg)  "sub esp,4\nfstp dword ptr [esp]\n"
reg: NEGF8(reg)  "fchs\n"
reg: NEGF4(reg)  "fchs\n"
flt: memf  " %0"
flt: reg   "p st(1),st"
reg: ADDF8(reg,flt)  "fadd%1\n"
reg: ADDF4(reg,flt)  "fadd%1\n"
reg: DIVF8(reg,flt)  "fdiv%1\n"
reg: DIVF4(reg,flt)  "fdiv%1\n"
reg: MULF8(reg,flt)  "fmul%1\n"
reg: MULF4(reg,flt)  "fmul%1\n"
reg: SUBF8(reg,flt)  "fsub%1\n"
reg: SUBF4(reg,flt)  "fsub%1\n"
reg: CVFF8(reg)  "# CVFF8\n"
reg: CVFF4(reg)  "sub esp,4\nfstp dword ptr 0[esp]\nfld dword ptr 0[esp]\nadd esp,4\n"  12

reg: CVFI4(reg)  "call __ftol\n" 31
reg: CVIF8(INDIRI4(addr))  "fild dword ptr %0\n"  10
reg: CVIF4(reg)  "push %0\nfild dword ptr 0[esp]\nadd esp,4\n"  12

reg: CVIF8(reg)  "push %0\nfild dword ptr 0[esp]\nadd esp,4\n"  12

addrj: ADDRGP4  "%a"
addrj: reg      "%0"  2
addrj: mem      "%0"  2

stmt:  JUMPV(addrj)  "jmp %0\n"  3
stmt:  LABELV        "%a:\n"
stmt: EQI4(mem,rc)  "cmp %0,%1\nje %a\n"   5
stmt: GEI4(mem,rc)  "cmp %0,%1\njge %a\n"  5
stmt: GTI4(mem,rc)  "cmp %0,%1\njg %a\n"   5
stmt: LEI4(mem,rc)  "cmp %0,%1\njle %a\n"  5
stmt: LTI4(mem,rc)  "cmp %0,%1\njl %a\n"   5
stmt: NEI4(mem,rc)  "cmp %0,%1\njne %a\n"  5
stmt: GEU4(mem,rc)  "cmp %0,%1\njae %a\n"  5
stmt: GTU4(mem,rc)  "cmp %0,%1\nja  %a\n"  5
stmt: LEU4(mem,rc)  "cmp %0,%1\njbe %a\n"  5
stmt: LTU4(mem,rc)  "cmp %0,%1\njb  %a\n"  5
stmt: EQI4(reg,mrc1)  "cmp %0,%1\nje %a\n"   4
stmt: GEI4(reg,mrc1)  "cmp %0,%1\njge %a\n"  4
stmt: GTI4(reg,mrc1)  "cmp %0,%1\njg %a\n"   4
stmt: LEI4(reg,mrc1)  "cmp %0,%1\njle %a\n"  4
stmt: LTI4(reg,mrc1)  "cmp %0,%1\njl %a\n"   4
stmt: NEI4(reg,mrc1)  "cmp %0,%1\njne %a\n"  4

stmt: EQU4(reg,mrc1)  "cmp %0,%1\nje %a\n"   4
stmt: GEU4(reg,mrc1)  "cmp %0,%1\njae %a\n"  4
stmt: GTU4(reg,mrc1)  "cmp %0,%1\nja %a\n"   4
stmt: LEU4(reg,mrc1)  "cmp %0,%1\njbe %a\n"  4
stmt: LTU4(reg,mrc1)  "cmp %0,%1\njb %a\n"   4
stmt: NEU4(reg,mrc1)  "cmp %0,%1\njne %a\n"  4
cmpf: memf  " %0"
cmpf: reg   "p"
stmt: EQF8(cmpf,reg)  "fcomp%0\nfstsw ax\nsahf\nje %a\n"
stmt: GEF8(cmpf,reg)  "fcomp%0\nfstsw ax\nsahf\njbe %a\n"
stmt: GTF8(cmpf,reg)  "fcomp%0\nfstsw ax\nsahf\njb %a\n"
stmt: LEF8(cmpf,reg)  "fcomp%0\nfstsw ax\nsahf\njae %a\n"
stmt: LTF8(cmpf,reg)  "fcomp%0\nfstsw ax\nsahf\nja %a\n"
stmt: NEF8(cmpf,reg)  "fcomp%0\nfstsw ax\nsahf\njne %a\n"

stmt: EQF4(cmpf,reg)  "fcomp%0\nfstsw ax\nsahf\nje %a\n"
stmt: GEF4(cmpf,reg)  "fcomp%0\nfstsw ax\nsahf\njbe %a\n"
stmt: GTF4(cmpf,reg)  "fcomp%0\nfstsw ax\nsahf\njb %a\n"
stmt: LEF4(cmpf,reg)  "fcomp%0\nfstsw ax\nsahf\njae %a\n"
stmt: LTF4(cmpf,reg)  "fcomp%0\nfstsw ax\nsahf\nja %a\n"
stmt: NEF4(cmpf,reg)  "fcomp%0\nfstsw ax\nsahf\njne %a\n"
reg:  CALLI4(addrj)  "call %0\nadd esp,%a\n"
reg:  CALLU4(addrj)  "call %0\nadd esp,%a\n"
reg:  CALLP4(addrj)  "call %0\nadd esp,%a\n"
stmt: CALLV(addrj)   "call %0\nadd esp,%a\n"
reg: CALLF4(addrj)  "call %0\nadd esp,%a\n"
reg: CALLF8(addrj)  "call %0\nadd esp,%a\n"
stmt: CALLF4(addrj)  "call %0\nadd esp,%a\nfstp\n"
stmt: CALLF8(addrj)  "call %0\nadd esp,%a\nfstp\n"

stmt: RETI4(reg)  "# ret\n"
stmt: RETU4(reg)  "# ret\n"
stmt: RETP4(reg)  "# ret\n"
stmt: RETF4(reg)  "# ret\n"
stmt: RETF8(reg)  "# ret\n"
%%
static void progbeg(int argc, char *argv[]) {
        int i;

        {
                union {
                        char c;
                        int i;
                } u;
                u.i = 0;
                u.c = 1;
                swap = ((int)(u.i == 1)) != IR->little_endian;
        }
        parseflags(argc, argv);
        intreg[EAX] = mkreg("eax", EAX, 1, IREG);
        intreg[EDX] = mkreg("edx", EDX, 1, IREG);
        intreg[ECX] = mkreg("ecx", ECX, 1, IREG);
        intreg[EBX] = mkreg("ebx", EBX, 1, IREG);
        intreg[ESI] = mkreg("esi", ESI, 1, IREG);
        intreg[EDI] = mkreg("edi", EDI, 1, IREG);

        shortreg[EAX] = mkreg("ax", EAX, 1, IREG);
        shortreg[ECX] = mkreg("cx", ECX, 1, IREG);
        shortreg[EDX] = mkreg("dx", EDX, 1, IREG);
        shortreg[EBX] = mkreg("bx", EBX, 1, IREG);
        shortreg[ESI] = mkreg("si", ESI, 1, IREG);
        shortreg[EDI] = mkreg("di", EDI, 1, IREG);

        charreg[EAX]  = mkreg("al", EAX, 1, IREG);
        charreg[ECX]  = mkreg("cl", ECX, 1, IREG);
        charreg[EDX]  = mkreg("dl", EDX, 1, IREG);
        charreg[EBX]  = mkreg("bl", EBX, 1, IREG);
        for (i = 0; i < 8; i++)
                fltreg[i] = mkreg("%d", i, 0, FREG);
        charregw = mkwildcard(charreg);
        shortregw = mkwildcard(shortreg);
        intregw = mkwildcard(intreg);
        fltregw = mkwildcard(fltreg);

        tmask[IREG] = (1<<EDI) | (1<<ESI) | (1<<EBX)
                    | (1<<EDX) | (1<<ECX) | (1<<EAX);
        vmask[IREG] = 0;
        tmask[FREG] = 0xff;
        vmask[FREG] = 0;
        print(".486\n");
        print(".model flat\n");
        print("extrn __fltused:near\n");
        print("extrn __ftol:near\n");
        cseg = 0;
        quo = mkreg("eax", EAX, 1, IREG);
        quo->x.regnode->mask |= 1<<EDX;
        rem = mkreg("edx", EDX, 1, IREG);
        rem->x.regnode->mask |= 1<<EAX;
}
static Symbol rmap(int opk) {
        switch (optype(opk)) {
        case B: case P:
                return intregw;
        case I: case U:
                if (opsize(opk) == 1)
                        return charregw;
                else if (opsize(opk) == 2)
                        return shortregw;
                else
                        return intregw;
        case F:
                return fltregw;
        default:
                return 0;
        }
}
static void segment(int n) {
        if (n == cseg)
                return;
        if (cseg == CODE || cseg == LIT)
                print("_TEXT ends\n");
        else if (cseg == DATA || cseg == BSS)
                print("_DATA ends\n");
        cseg = n;
        if (cseg == CODE || cseg == LIT)
                print("_TEXT segment\n");
        else if (cseg == DATA || cseg == BSS)
                print("_DATA segment\n");
}
static void progend(void) {
        segment(0);
        print("end\n");
}
static void target(Node p) {
        assert(p);
        switch (specific(p->op)) {
        case MUL+U:
                setreg(p, quo);
                rtarget(p, 0, intreg[EAX]);
                break;
        case DIV+I: case DIV+U:
                setreg(p, quo);
                rtarget(p, 0, quo);
                break;
        case MOD+I: case MOD+U:
                setreg(p, rem);
                rtarget(p, 0, quo);
                break;
        case ASGN+B:
                rtarget(p, 0, intreg[EDI]);
                rtarget(p->kids[1], 0, intreg[ESI]);
                break;
        case ARG+B:
                rtarget(p->kids[0], 0, intreg[ESI]);
                break;
        case CVF+I:
                setreg(p, intreg[EAX]);
                break;
        case CALL+I: case CALL+U: case CALL+P: case CALL+V:
                setreg(p, intreg[EAX]);
                break;
        case RET+I: case RET+U: case RET+P:
                rtarget(p, 0, intreg[EAX]);
                break;
        }
}

static void clobber(Node p) {
        static int nstack = 0;

        assert(p);
        nstack = ckstack(p, nstack);
        switch (specific(p->op)) {
        case RSH+I: case RSH+U: case LSH+I: case LSH+U:
                if (generic(p->kids[1]->op) != CNST
                && !(   generic(p->kids[1]->op) == INDIR
                     && specific(p->kids[1]->kids[0]->op) == VREG+P
                     && p->kids[1]->syms[RX]->u.t.cse
                     && generic(p->kids[1]->syms[RX]->u.t.cse->op) == CNST
)) {
                        spill(1<<ECX, 1, p);
                }
                break;
        case ASGN+B: case ARG+B:
                spill(1<<ECX | 1<<ESI | 1<<EDI, IREG, p);
                break;
        case EQ+F: case LE+F: case GE+F: case LT+F: case GT+F: case NE+F:
                spill(1<<EAX, IREG, p);
                break;
        case CALL+F:
                spill(1<<EDX | 1<<EAX | 1<<ECX, IREG, p);
                break;
        case CALL+I: case CALL+U: case CALL+P: case CALL+V:
                spill(1<<EDX | 1<<ECX, IREG, p);
                break;
        }
}
#define isfp(p) (optype((p)->op)==F)

int ckstack(Node p, int n) {
        int i;

        for (i = 0; i < NELEMS(p->x.kids) && p->x.kids[i]; i++)
                if (isfp(p->x.kids[i]))
                        n--;
        if (isfp(p) && p->count > 0)
                n++;
        if (n > 8)
                error("expression too complicated\n");
        debug(fprint(stderr, "(ckstack(%x)=%d)\n", p, n));
        assert(n >= 0);
        return n;
}
int memop(Node p) {
        assert(p);
        assert(generic(p->op) == ASGN);
        assert(p->kids[0]);
        assert(p->kids[1]);
        if (generic(p->kids[1]->kids[0]->op) == INDIR
        && sametree(p->kids[0], p->kids[1]->kids[0]->kids[0]))
                return 3;
        else
                return LBURG_MAX;
}
int sametree(Node p, Node q) {
        return p == NULL && q == NULL
        || p && q && p->op == q->op && p->syms[0] == q->syms[0]
                && sametree(p->kids[0], q->kids[0])
                && sametree(p->kids[1], q->kids[1]);
}
static void emit2(Node p) {
        int op = specific(p->op);
#define preg(f) ((f)[getregnum(p->x.kids[0])]->x.name)

        if (op == CVI+I && opsize(p->op) == 4 && opsize(p->x.kids[0]->op) == 1)
                print("movsx %s,%s\n", p->syms[RX]->x.name
, preg(charreg));
        else if (op == CVI+U && opsize(p->op) == 4 && opsize(p->x.kids[0]->op) == 1)
                print("movsx %s,%s\n", p->syms[RX]->x.name
, preg(charreg));
        else if (op == CVI+I && opsize(p->op) == 4 && opsize(p->x.kids[0]->op) == 2)
                print("movsx %s,%s\n", p->syms[RX]->x.name
, preg(shortreg));
        else if (op == CVI+U && opsize(p->op) == 4 && opsize(p->x.kids[0]->op) == 2)
                print("movsx %s,%s\n", p->syms[RX]->x.name
, preg(shortreg));

        else if (op == CVU+I && opsize(p->op) == 4 && opsize(p->x.kids[0]->op) == 1)
                print("movzx %s,%s\n", p->syms[RX]->x.name
, preg(charreg));
        else if (op == CVU+U && opsize(p->op) == 4 && opsize(p->x.kids[0]->op) == 1)
                print("movzx %s,%s\n", p->syms[RX]->x.name
, preg(charreg));
        else if (op == CVU+I && opsize(p->op) == 4 && opsize(p->x.kids[0]->op) == 2)
                print("movzx %s,%s\n", p->syms[RX]->x.name
, preg(shortreg));
        else if (op == CVU+U && opsize(p->op) == 4 && opsize(p->x.kids[0]->op) == 2)
                print("movzx %s,%s\n", p->syms[RX]->x.name
, preg(shortreg));
        else if (generic(op) == CVI || generic(op) == CVU || generic(op) == LOAD) {
                char *dst = intreg[getregnum(p)]->x.name;
                char *src = preg(intreg);
                assert(opsize(p->op) <= opsize(p->x.kids[0]->op));
                if (dst != src)
                        print("mov %s,%s\n", dst, src);
        }
}

static void doarg(Node p) {
        assert(p && p->syms[0]);
        mkactual(4, p->syms[0]->u.c.v.i);
}
static void blkfetch(int k, int off, int reg, int tmp) {}
static void blkstore(int k, int off, int reg, int tmp) {}
static void blkloop(int dreg, int doff, int sreg, int soff,
        int size, int tmps[]) {}
static void local(Symbol p) {
        if (isfloat(p->type))
                p->sclass = AUTO;
        if (askregvar(p, (*IR->x.rmap)(ttob(p->type))) == 0)
                mkauto(p);
}
static void function(Symbol f, Symbol caller[], Symbol callee[], int n) {
        int i;

        print("%s:\n", f->x.name);
        print("push ebx\n");
        print("push esi\n");
        print("push edi\n");
        print("push ebp\n");
        print("mov ebp,esp\n");
        usedmask[0] = usedmask[1] = 0;
        freemask[0] = freemask[1] = ~(unsigned)0;
        offset = 16 + 4;
        for (i = 0; callee[i]; i++) {
                Symbol p = callee[i];
                Symbol q = caller[i];
                assert(q);
                p->x.offset = q->x.offset = offset;
                p->x.name = q->x.name = stringf("%d", p->x.offset);
                p->sclass = q->sclass = AUTO;
                offset += roundup(q->type->size, 4);
        }
        assert(caller[i] == 0);
        offset = maxoffset = 0;
        gencode(caller, callee);
        framesize = roundup(maxoffset, 4);
        if (framesize > 0)
                print("sub esp,%d\n", framesize);
        emitcode();
        print("mov esp,ebp\n");
        print("pop ebp\n");
        print("pop edi\n");
        print("pop esi\n");
        print("pop ebx\n");
        print("ret\n");
}
static void defsymbol(Symbol p) {
        if (p->scope >= LOCAL && p->sclass == STATIC)
                p->x.name = stringf("L%d", genlabel(1));
        else if (p->generated)
                p->x.name = stringf("L%s", p->name);
        else if (p->scope == GLOBAL || p->sclass == EXTERN)
                p->x.name = stringf("_%s", p->name);
        else if (p->scope == CONSTANTS
        && (isint(p->type) || isptr(p->type))
        && p->name[0] == '0' && p->name[1] == 'x')
                p->x.name = stringf("0%sH", &p->name[2]);
        else
                p->x.name = p->name;
}
static void address(Symbol q, Symbol p, long n) {
        if (p->scope == GLOBAL
        || p->sclass == STATIC || p->sclass == EXTERN)
                q->x.name = stringf("%s%s%D",
                        p->x.name, n >= 0 ? "+" : "", n);
        else {
                assert(n <= INT_MAX && n >= INT_MIN);
                q->x.offset = p->x.offset + n;
                q->x.name = stringd(q->x.offset);
        }
}
static void defconst(int suffix, int size, Value v) {
        if (suffix == I && size == 1)
                print("db %d\n",   v.u);
        else if (suffix == I && size == 2)
                print("dw %d\n",   v.i);
        else if (suffix == I && size == 4)
                print("dd %d\n",   v.i);
        else if (suffix == U && size == 1)
                print("db 0%xH\n", v.u);
        else if (suffix == U && size == 2)
                print("dw 0%xH\n", v.u);
        else if (suffix == U && size == 4)
                print("dd 0%xH\n", v.u);
        else if (suffix == P && size == 4)
                print("dd 0%xH\n", v.p);
        else if (suffix == F && size == 4) {
                float f = v.d;
                print("dd 0%xH\n", *(unsigned *)&f);
        }
        else if (suffix == F && size == 8) {
                double d = v.d;
                unsigned *p = (unsigned *)&d;
                print("dd 0%xH\ndd 0%xH\n", p[swap], p[!swap]);
        }
        else assert(0);
}
static void defaddress(Symbol p) {
        print("dd %s\n", p->x.name);
}
static void defstring(int n, char *str) {
        char *s;

        for (s = str; s < str + n; s++)
                print("db %d\n", (*s)&0377);
}
static void export(Symbol p) {
        print("public %s\n", p->x.name);
}
static void import(Symbol p) {
        int oldseg = cseg;

        if (p->ref > 0) {
                segment(0);
                print("extrn %s:near\n", p->x.name);
                segment(oldseg);
        }
}
static void global(Symbol p) {
        print("align %d\n",
                p->type->align > 4 ? 4 : p->type->align);
        print("%s label byte\n", p->x.name);
        if (p->u.seg == BSS)
                print("db %d dup (0)\n", p->type->size);
}
static void space(int n) {
        if (cseg != BSS)
                print("db %d dup (0)\n", n);
}
Interface x86IR = {
        1, 1, 0,  /* char */
        2, 2, 0,  /* short */
        4, 4, 0,  /* int */
        4, 4, 0,  /* long */
        4, 4, 0,  /* long long */
        4, 4, 1,  /* float */
        8, 4, 1,  /* double */
        8, 4, 1,  /* long double */
        4, 4, 0,  /* T * */
        0, 4, 0,  /* struct; so that ARGB keeps stack aligned */
        1,        /* little_endian */
        0,        /* mulops_calls */
        0,        /* wants_callb */
        1,        /* wants_argb */
        0,        /* left_to_right */
        0,        /* wants_dag */
        0,        /* unsigned_char */
        address,
        blockbeg,
        blockend,
        defaddress,
        defconst,
        defstring,
        defsymbol,
        emit,
        export,
        function,
        gen,
        global,
        import,
        local,
        progbeg,
        progend,
        segment,
        space,
        0, 0, 0, 0, 0, 0, 0,
        {1, rmap,
            blkfetch, blkstore, blkloop,
            _label,
            _rule,
            _nts,
            _kids,
            _string,
            _templates,
            _isinstruction,
            _ntname,
            emit2,
            doarg,
            target,
            clobber,
}
};
static char rcsid[] = "$Id: x86.nw,v 2.25 1998/07/02 00:26:44 drh Exp $";
