%{
/**********************************************
       Floating Point supported

Notes:
       isreg() not used
***********************************************/
#define NS32K_VERSION "0.93"
#define CASE_ESCAPE

enum { R0=0, R1, R2, R3, R4, R5, R6, R7 };
enum { F0=0, F1, F2, F3, F4, F5, F6, F7 };   /* D.P. only uses the even registers */
enum { r_first=R3, r_last=R7 };         /* registers to save on call */

/* mask bits to keep track of issuance of  .entp, .extp pairs */
/* use in  sym->x.eaddr  */
#define ENTP 1
#define EXTP 2

#include "c.h"

#define NODEPTR_TYPE Node
#define OP_LABEL(p) ((p)->op)
#define LEFT_CHILD(p) ((p)->kids[0])
#define RIGHT_CHILD(p) ((p)->kids[1])
#define STATE_LABEL(p) ((p)->x.state)

static void address     ARGS((Symbol, Symbol, int));
static void blkfetch    ARGS((int, int, int, int));
static void blkloop     ARGS((int, int, int, int, int, int[]));
static void blkstore    ARGS((int, int, int, int));
static void defaddress  ARGS((Symbol));
static void defconst    ARGS((int, Value));
static void defstring   ARGS((int, char *));
static void defsymbol   ARGS((Symbol));
static void doarg       ARGS((Node));
static void emit2       ARGS((Node));
static void export      ARGS((Symbol));
static void clobber     ARGS((Node));
static void function    ARGS((Symbol, Symbol [], Symbol [], int));
static void global      ARGS((Symbol));
static void import      ARGS((Symbol));
static void local       ARGS((Symbol));
static void progbeg     ARGS((int, char **));
static void progend     ARGS((void));
static void segment     ARGS((int));
static void space       ARGS((int));
static void target      ARGS((Node));
static int memop ARGS((Node));
static int memop2 ARGS((Node));
static int insertop ARGS((Node));
static int sametree ARGS((Node, Node));
static Symbol intreg[32], fltreg[32], dfltreg[32];

static int cseg, rsave, fmask;
static int InSwitch = 0;        /* mark being in a switch statement */
static Symbol quo, rem;

%}
%start stmt
%term ADDD=306 ADDF=305 ADDI=309 ADDP=311 ADDU=310
%term ADDRFP=279
%term ADDRGP=263
%term ADDRLP=295
%term ARGB=41 ARGD=34 ARGF=33 ARGI=37 ARGP=39
%term ASGNB=57 ASGNC=51 ASGND=50 ASGNF=49 ASGNI=53 ASGNP=55 ASGNS=52
%term BANDU=390
%term BCOMU=406
%term BORU=422
%term BXORU=438
%term CALLB=217 CALLD=210 CALLF=209 CALLI=213 CALLV=216
%term CNSTC=19 CNSTD=18 CNSTF=17 CNSTI=21 CNSTP=23 CNSTS=20 CNSTU=22
%term CVCI=85 CVCU=86
%term CVDF=97 CVDI=101
%term CVFD=114
%term CVIC=131 CVID=130 CVIS=132 CVIU=134
%term CVPU=150
%term CVSI=165 CVSU=166
%term CVUC=179 CVUI=181 CVUP=183 CVUS=180
%term DIVD=450 DIVF=449 DIVI=453 DIVU=454
%term EQD=482 EQF=481 EQI=485
%term GED=498 GEF=497 GEI=501 GEU=502
%term GTD=514 GTF=513 GTI=517 GTU=518
%term INDIRB=73 INDIRC=67 INDIRD=66 INDIRF=65 INDIRI=69 INDIRP=71 INDIRS=68
%term JUMPV=584
%term LABELV=600
%term LED=530 LEF=529 LEI=533 LEU=534
%term LOADB=233 LOADC=227 LOADD=226 LOADF=225 LOADI=229 LOADP=231 LOADS=228 LOADU=230
%term LSHI=341 LSHU=342
%term LTD=546 LTF=545 LTI=549 LTU=550
%term MODI=357 MODU=358
%term MULD=466 MULF=465 MULI=469 MULU=470
%term NED=562 NEF=561 NEI=565
%term NEGD=194 NEGF=193 NEGI=197
%term RETD=242 RETF=241 RETI=245
%term RSHI=373 RSHU=374
%term SUBD=322 SUBF=321 SUBI=325 SUBP=327 SUBU=326
%term VREGP=615
%%
reg:  INDIRC(VREGP)     "# read register\n"
reg:  INDIRI(VREGP)     "# read register\n"
reg:  INDIRP(VREGP)     "# read register\n"
reg:  INDIRS(VREGP)     "# read register\n"
dreg: INDIRD(VREGP)     "# read register\n"
freg: INDIRF(VREGP)     "# read register\n"
stmt: ASGNC(VREGP,reg)  "# write register\n"
stmt: ASGNI(VREGP,reg)  "# write register\n"
stmt: ASGNP(VREGP,reg)  "# write register\n"
stmt: ASGNS(VREGP,reg)  "# write register\n"
stmt: ASGND(VREGP,dreg)  "# write register\n"
stmt: ASGNF(VREGP,freg)  "# write register\n"


conq: CNSTC  "%a"  range(a, -8, 7)
conq: CNSTI  "%a"  range(a, -8, 7)
conq: CNSTP  "%a"  range(a,  0, 7)
conq: CNSTP  "%a"  range(a, -8, -1)
conq: CNSTS  "%a"  range(a, -8, 7)
conq: CNSTU  "%a"  range(a,  0, 7)
conq: CNSTU  "%a"  range(a, -8, -1)

consq: CNSTC  "%a"  range(a, -7, 8)
consq: CNSTI  "%a"  range(a, -7, 8)
consq: CNSTP  "%a"  range(a,  0, 8)
consq: CNSTP  "%a"  range(a, -7, -1)
consq: CNSTS  "%a"  range(a, -7, 8)
consq: CNSTU  "%a"  range(a,  0, 8)
consq: CNSTU  "%a"  range(a, -7, -1)

con8k: CNSTC  "%a"  (1|range(a, 0, 8191))
con8k: CNSTI  "%a"  (1|range(a, 0, 8191))
con8k: CNSTP  "%a"  (1|range(a, 0, 8191))
con8k: CNSTS  "%a"  (1|range(a, 0, 8191))
con8k: CNSTU  "%a"  (1|range(a, 0, 8191))

del8k: CNSTC  "%a"  (1|range(a, -8192, 8191))
del8k: CNSTI  "%a"  (1|range(a, -8192, 8191))
del8k: CNSTP  "%a"  (1|range(a,     0, 8191))
del8k: CNSTP  "%a"  (1|range(a, -8192, -1))
del8k: CNSTS  "%a"  (1|range(a, -8192, 8191))
del8k: CNSTU  "%a"  (1|range(a,     0, 8191))
del8k: CNSTU  "%a"  (1|range(a, -8192, -1))

con: CNSTC  "%a"  2
con: CNSTI  "%a"  2
con: CNSTP  "%a"  2
con: CNSTS  "%a"  2
con: CNSTU  "%a"  2

stmt: reg  ""
reg: CVIU(reg)  "%0"  notarget(a)
reg: CVPU(reg)  "%0"  notarget(a)
reg: CVUI(reg)  "%0"  notarget(a)
reg: CVUP(reg)  "%0"  notarget(a)

reg: CVIU(reg)  "\tMovD %0,%c\n"   move(a)
reg: CVPU(reg)  "\tMovD %0,%c\n"   move(a)
reg: CVUI(reg)  "\tMovD %0,%c\n"   move(a)
reg: CVUP(reg)  "\tMovD %0,%c\n"   move(a)

acon: CNSTI  "%a"  
acon: CNSTP  "%a"  
acon: CNSTU  "%a"  

bcon: ADDRFP  "FR+%a"
bcon: ADDRLP  "FR%a"

base: ADDRGP  "%a"
base: reg            "0(%0)"   1
base: bcon    "%0" 
base: ADDI(reg,acon)  "%1(%0)"  
base: ADDP(reg,acon)  "%1(%0)"  
base: ADDU(reg,acon)  "%1(%0)"  
base: INDIRP(bcon)             "0(%0)"
base: ADDP(INDIRP(bcon),acon)  "%1(%0)"  

index: reg             "%0:B"   1
index: LSHI(reg,con1)  "%0:W"   1
index: LSHI(reg,con2)  "%0:D"   1
index: LSHI(reg,con3)  "%0:Q"   1
index: LSHU(reg,con1)  "%0:W"   1
index: LSHU(reg,con2)  "%0:D"   1
index: LSHU(reg,con3)  "%0:Q"   1

addr: base              "%0"      
addr: ADDI(index,base)  "%1[%0]"
addr: ADDP(index,base)  "%1[%0]"
addr: ADDU(index,base)  "%1[%0]"
addr: ADDI(index,reg)  "(%1)[%0]"
addr: ADDP(index,reg)  "(%1)[%0]"
addr: ADDU(index,reg)  "(%1)[%0]"


con1:  CNSTI  "1"  range(a, 1, 1)
con1:  CNSTU  "1"  range(a, 1, 1)
con2:  CNSTI  "2"  range(a, 2, 2)
con2:  CNSTU  "2"  range(a, 2, 2)
con3:  CNSTI  "3"  range(a, 3, 3)
con3:  CNSTU  "3"  range(a, 3, 3)
conm2:  CNSTI "%a"  range(a, -2, -2)
conm2:  CNSTU "%a"  range(a, -2, -2)


mem: INDIRC(addr)  "%0"
mem: INDIRI(addr)  "%0"
mem: INDIRP(addr)  "%0"
mem: INDIRS(addr)  "%0"

rc:   reg  "%0"
rc:   con  "%0" 

mr:   reg  "%0"
mr:   mem  "%0"

mrc0: mem  "%0"
mrc0: rc   "%0"
mrc1: mem  "%0"  1
mrc1: rc   "%0"

reg: conq        "\tmovqd %0,%c\n" 1
reg: con8k       "\taddr @%0,%c\n" 2
reg: INDIRP(bcon) "\tmovd %0,%c\n" 2
reg: addr        "\taddr %0,%c\n"  300
reg: mrc0        "\tmovd %0,%c\n"  3


reg: LOADC(reg)  "\tmovb %0,%c\n"  move(a)
reg: LOADI(reg)  "\tmovd %0,%c\n"  move(a)
reg: LOADP(reg)  "\tmovd %0,%c\n"  move(a)
reg: LOADS(reg)  "\tmovw %0,%c\n"  move(a)
reg: LOADU(reg)  "\tmovD %0,%c\n"  move(a)
dreg: LOADD(dreg)  "\tmovl %0,%c\n" move(a)
freg: LOADF(freg)  "\tmovf %0,%c\n" move(a)

stmt: ASGNI(addr,BORU(BANDU(mem,conm2),BANDU(BANDU(CVIU(mr),con1),con1)))  "\tinssd %3,%0,0,1\n"  memop2(a)
stmt: ASGNI(addr,BORU(BANDU(mem,acon),BANDU(BANDU(CVIU(mr),acon),acon)))  "\tinssd %3,%0,0,%%%%(%5)\n"  insertop(a)
stmt: ASGNI(addr,BORU(BANDU(CVIU(mem),acon),BANDU(LSHU(CVIU(RSHI(LSHI(mr,c5),c5)),c5),acon)))  "\tinssd %3,%6/8+%0,%6&7,32-%5\n"  insertop(a)
stmt: ASGNI(addr,BORU(BANDU(CVIU(mem),acon),BANDU(CVIU(RSHI(LSHI(mr,c5),c5)),acon)))  "\tinssd %3,%0,0,32-%5\n"  insertop(a)
stmt: ASGNI(addr,BORU(BANDU(mem,acon),BANDU(LSHU(BANDU(CVIU(mr),acon),c5),acon)))  "\tinssd %3,%5/8+%0,%5&7,%%%%(%6)\n"  insertop(a)

stmt: ASGNI(addr,CVUI(RSHU(LSHU(mem,c5),c5))) "\textsd (%3-%2)/8+%1,%0,(%3-%2)&7,32-%3\n" 
reg: RSHU(LSHU(mem,c5),c5) "\textsd (%2-%1)/8+%0,%c,(%2-%1)&7,32-%2\n"   1

reg: ADDI(reg,mrc1)    "?\tmovd %0,%c\n\taddd %1,%c\n"    3
reg: SUBI(reg,mrc1)    "?\tmovd %0,%c\n\tsubd %1,%c\n"    3 
reg: ADDP(reg,mrc1)    "?\tmovd %0,%c\n\taddd %1,%c\n"    3
reg: ADDU(reg,mrc1)    "?\tmovd %0,%c\n\taddd %1,%c\n"    3
reg: SUBP(reg,mrc1)    "?\tmovd %0,%c\n\tsubd %1,%c\n"    3
reg: SUBU(reg,mrc1)    "?\tmovd %0,%c\n\tsubd %1,%c\n"    3

reg: ADDI(reg,conq)    "?\tmovd %0,%c\n\taddqd %1,%c\n"      2
reg: ADDP(reg,conq)    "?\tmovd %0,%c\n\taddqd %1,%c\n"      2
reg: ADDU(reg,conq)    "?\tmovd %0,%c\n\taddqd %1,%c\n"      2

reg: ADDI(reg,del8k)    "\taddr %1(%0),%c\n"      2
reg: ADDP(reg,del8k)    "\taddr %1(%0),%c\n"      2
reg: ADDU(reg,del8k)    "\taddr %1(%0),%c\n"      2

reg: SUBI(reg,consq)    "?\tmovd %0,%c\n\taddqd -(%1),%c\n"   2
reg: SUBP(reg,consq)    "?\tmovd %0,%c\n\taddqd -(%1),%c\n"   2
reg: SUBU(reg,consq)    "?\tmovd %0,%c\n\taddqd -(%1),%c\n"   2

abcon: CNSTU "%a"  range(a, -256, -1)
obcon: CNSTU "%a"  range(a,    0, 255)
awcon: CNSTU "%a"  range(a, -65556, -1)
owcon: CNSTU "%a"  range(a, 0, 65535)

reg: BANDU(reg,BCOMU(mr))    "\tBICd %1,%0\n"  (3+notarget(a))
reg: BANDU(reg,mrc1)    "\tANDd %1,%0\n"  (3+notarget(a))
reg: BORU(reg,mrc1)     "\tORd %1,%0\n"  (3+notarget(a))
reg: BXORU(reg,mrc1)    "\tXORd %1,%0\n"  (3+notarget(a))

reg: BANDU(reg,BCOMU(mr))  "?\tMOVD %0,%c\n\tbicd %1,%c\n"    2
reg: BANDU(reg,mrc1)   "?\tMOVD %0,%c\n\tandd %1,%c\n"    2
reg: BANDU(reg,abcon)   "?\tMOVD %0,%c\n\tandb %1,%c\n"    2
reg: BANDU(reg,awcon)   "?\tMOVD %0,%c\n\tandw %1,%c\n"    2
reg: BORU(reg,mrc1)    "?\tmovd %0,%c\n\tord %1,%c\n"     2
reg: BORU(reg,obcon)    "?\tmovd %0,%c\n\torb %1,%c\n"     2
reg: BORU(reg,owcon)    "?\tmovd %0,%c\n\torw %1,%c\n"     2
reg: BXORU(reg,mrc1)   "?\tmovd %0,%c\n\txord %1,%c\n"    2
reg: BXORU(reg,obcon)   "?\tmovd %0,%c\n\txorb %1,%c\n"    2
reg: BXORU(reg,owcon)   "?\tmovd %0,%c\n\txorw %1,%c\n"    2

stmt: ASGNI(addr,ADDI(mem,conq))  "\taddqd %2,%1\n"  memop(a)
stmt: ASGNI(addr,ADDU(mem,conq))  "\taddqd %2,%1\n"  memop(a)
stmt: ASGNP(addr,ADDP(mem,conq))  "\taddqd %2,%1\n"  memop(a)
stmt: ASGNI(addr,SUBI(mem,consq))  "\taddqd -(%2),%1\n"  memop(a)
stmt: ASGNI(addr,SUBU(mem,consq))  "\taddqd -(%2),%1\n"  memop(a)
stmt: ASGNP(addr,SUBP(mem,consq))  "\taddqd -(%2),%1\n"  memop(a)

stmt: ASGNI(addr,ADDI(mem,rc))   "\taddd %2,%1\n"  memop(a)
stmt: ASGNI(addr,ADDU(mem,rc))   "\taddd %2,%1\n"  memop(a)
stmt: ASGNI(addr,SUBI(mem,rc))   "\tsubd %2,%1\n"  memop(a)
stmt: ASGNI(addr,SUBU(mem,rc))   "\tsubd %2,%1\n"  memop(a)
stmt: ASGNI(addr,BANDU(mem,rc))  "\tandd %2,%1\n"  memop(a)
stmt: ASGNI(addr,BORU(mem,rc))   "\tord %2,%1\n"   memop(a)
stmt: ASGNI(addr,BXORU(mem,rc))  "\txord %2,%1\n"  memop(a)

reg: BCOMU(reg)  "\tcomd %0,%c\n"  1
reg: NEGI(reg)   "\tnegd %0,%c\n"  1
stmt: ASGNI(addr,BCOMU(mem))  "\tcomd %1,%1\n"  memop(a)
stmt: ASGNI(addr,NEGI(mem))   "\tnegd %1,%1\n"  memop(a)

reg: LSHI(reg,rc5)  "?\tmovd %0,%c\n\tashd %1,%c\n"  2
reg: LSHU(reg,rc5)  "?\tmovd %0,%c\n\tlshd %1,%c\n"  2
reg: RSHI(reg,c5)  "?\tmovd %0,%c\n\tashd -(%1),%c\n"  2
reg: RSHU(reg,c5)  "?\tmovd %0,%c\n\tlshd -(%1),%c\n"  2
reg: RSHI(reg,reg)  "?\tmovd %0,%c\n\tnegd %1,%1\n\tashd %1,%c\n"  3
reg: RSHU(reg,reg)  "?\tmovd %0,%c\n\tnegd %1,%1\n\tlshd %1,%c\n"  3

stmt: ASGNI(addr,LSHI(mem,rc5))  "\tashd %2,%1\n"  memop(a)
stmt: ASGNI(addr,LSHU(mem,rc5))  "\tlshd %2,%1\n"  memop(a)
stmt: ASGNI(addr,RSHI(mem,c5))   "\tashd -(%2),%1\n"  memop(a)
stmt: ASGNI(addr,RSHU(mem,c5))   "\tlshd -(%2),%1\n"  memop(a)

c5:  CNSTI  "%a"  range(a, 0, 31)
c5:  CNSTU  "%a"  range(a, 0, 31)
rc5: mr     "%0"
rc5: c5     "%0" 

reg: MULI(reg,mrc1)  "?\tmovd %0,%c\n\tmuld %1,%c\n"  14
reg: DIVI(reg,mrc1)  "?\tmovd %0,%c\n\tquod %1,%c\n"  16
reg: MODI(reg,mrc1)  "?\tmovd %0,%c\n\tremd %1,%c\n"  16
reg: MULU(reg,mrc1)       "\tmeid %1,%c\n"  13
reg: DIVU(reg,mrc1)  "\tmovqd 0,r1\n\tdeid %1,r0\n"   15
reg: MODU(reg,mrc1)  "\tmovqd 0,r1\n\tdeid %1,r0\n"     15

reg: CVCI(mr)  "\tmovxbd %0,%c\n"  3
reg: CVCU(mr)  "\tmovzbd %0,%c\n"  3
reg: CVSI(mr)  "\tmovxwd %0,%c\n"  3
reg: CVSU(mr)  "\tmovzwd %0,%c\n"  3

reg: CVIC(reg)  "# truncate\n"  1
reg: CVIS(reg)  "# truncate\n"  1
reg: CVUC(reg)  "# truncate\n"  1
reg: CVUS(reg)  "# truncate\n"  1

stmt: ASGNC(addr,conq)  "\tmovqb %1,%0\n"   
stmt: ASGNC(addr,mrc0)  "\tmovb %1,%0\n"  
stmt: ASGNI(addr,conq)  "\tmovqd %1,%0\n" 
stmt: ASGNI(addr,con8k) "\taddr @%1,%0\n"
stmt: ASGNI(addr,mrc0)  "\tmovd %1,%0\n"  
stmt: ASGNP(addr,conq)  "\tmovqd %1,%0\n"  
stmt: ASGNP(addr,mrc0)  "\tmovd %1,%0\n" 
stmt: ASGNS(addr,conq)  "\tmovqw %1,%0\n"  
stmt: ASGNS(addr,mrc0)  "\tmovw %1,%0\n"  

stmt: ARGI(conq)         "\tmovqd %0,tos\n"
stmt: ARGI(con8k)        "\taddr @%0,tos\n"
stmt: ARGI(mrc1)           "\tmovd %0,tos\n"
stmt: ARGP(addr)          "\taddr %0,tos\n"   1
stmt: ARGP(mrc1)           "\tmovd %0,tos\n"
stmt: ARGP(INDIRP(addr))  "\tmovd %0,tos\n"
stmt: ARGI(INDIRI(addr))  "\tmovd %0,tos\n"
stmt: ASGNB(reg,INDIRB(reg))  "#   \tmovd %a,r0\n\tmovsb\n"
stmt: ARGB(INDIRB(reg))  "#   \tmovd %a,r0\n\tadjspd r0\n\taddr tos,r2\n\tmovsb\n"

stmt: dreg   ""
stmt: freg   ""
memd: INDIRD(addr)        "%0"
memf: INDIRF(addr)        "%0"
freg:  memf  "\tmovf %0,%c\n"   5
dreg:  memd  "\tmovl %0,%c\n"   5
rmd:   dreg  "%0"
rmd:   memd  "%0"
rmf:   freg  "%0"
rmf:   memf  "%0" 
stmt: ASGND(addr,dreg)        "\tmovl %1,%0\n"       7
stmt: ASGND(addr,memd)        "\tmovmd %1,%0,2\n"    3
stmt: ASGND(addr,CVFD(rmf))   "\tmovfl %1,%0\n"  7
stmt: ASGNF(addr,freg)        "\tmovf %1,%0\n"       7
stmt: ASGNF(addr,memf)        "\tmovd %1,%0\n"       1
stmt: ASGNF(addr,CVDF(rmd))  "\tmovlf %1,%0\n"  7
stmt: ARGD(rmd)  "\tmovl %0,tos\n"
stmt: ARGF(rmf)  "\tmovf %0,tos\n"

stmt: ASGND(addr,NEGD(memd))   "\txorb #80,7+%1\n"  memop(a)
stmt: ASGNF(addr,NEGF(memf))   "\txorb #80,3+%1\n"  memop(a)
dreg: NEGD(rmd)  "\tnegl %0,%c\n"    5
freg: NEGF(rmf)  "\tnegf %0,%c\n"    5

dreg: ADDD(dreg,memd)  "?\tmovl %0,%c\n\taddl %1,%c\n"   5
dreg: ADDD(dreg,dreg)  "?\tmovl %0,%c\n\taddl %1,%c\n"   
dreg: ADDD(memd,dreg)  "\tmovl %0,%c\n\taddl %1,%c\n"    8
freg: ADDF(freg,rmf)  "?\tmovf %0,%c\n\taddf %1,%c\n"
dreg: SUBD(dreg,memd)  "?\tmovl %0,%c\n\tsubl %1,%c\n"   5
dreg: SUBD(dreg,dreg)  "?\tmovl %0,%c\n\tsubl %1,%c\n"
freg: SUBF(freg,rmf)  "?\tmovf %0,%c\n\tsubf %1,%c\n"
dreg: MULD(dreg,memd)  "?\tmovl %0,%c\n\tmull %1,%c\n"   5
dreg: MULD(dreg,dreg)  "?\tmovl %0,%c\n\tmull %1,%c\n"   
dreg: MULD(memd,dreg)  "\tmovl %0,%c\n\tmull %1,%c\n"    8
freg: MULF(freg,rmf)  "?\tmovf %0,%c\n\tmulf %1,%c\n"
dreg: DIVD(dreg,memd)  "?\tmovl %0,%c\n\tdivl %1,%c\n"   5
dreg: DIVD(dreg,dreg)  "?\tmovl %0,%c\n\tdivl %1,%c\n"
freg: DIVF(freg,rmf)  "?\tmovf %0,%c\n\tdivf %1,%c\n"
dreg: CVFD(rmf)  "\tmovfl %0,%c\n"           5
freg: CVDF(rmd)  "\tmovlf %0,%c\n"           5

stmt: ASGNI(addr,CVDI(dreg))  "\ttruncld %1,%0\n"      5
stmt: ASGNI(addr,CVDI(CVFD(freg)))  "\ttruncfd %1,%0\n"     5
reg:  CVDI(rmd)  "\ttruncld %0,%c\n"          5
reg:  CVDI(CVFD(rmf))  "\ttruncfd %0,%c\n"    5
dreg: CVID(mr)  "\tmovdl %0,%c\n"             5
freg: CVDF(CVID(mr))  "\tmovdf %0,%c\n"       5

addrc: ADDRGP  "%a"
addrj: reg     "%0"  2
addrj: mem     "%0"  2

stmt:  JUMPV(INDIRP(ADDP(LSHI(reg,con2),base))) "# %\tcased %2[%0:D]\n"
stmt:  JUMPV(INDIRP(ADDP(LSHU(reg,con2),base))) "# %\tcaseD %2[%0:D]\n"
stmt:  JUMPV(addrc)  "\tbr %0\n"  
stmt:  JUMPV(addrj)  "\tjump %0\n"   5 
stmt:  LABELV        "# %a\n"

stmt: EQI(conq,mrc1)  "\tcmpqd %0,%1\n\tbeq %a\n"  3
stmt: EQI(mrc1,conq)  "\tcmpqd %1,%0\n\tbeq %a\n"  3
stmt: EQI(mrc1,mrc1)  "\tcmpd %0,%1\n\tbeq %a\n"   3
stmt: GEI(conq,mrc1)  "\tcmpqd %0,%1\n\tbge %a\n"  3
stmt: GEI(mrc1,conq)  "\tcmpqd %1,%0\n\tble %a\n"  3
stmt: GEI(mrc1,mrc1)  "\tcmpd %0,%1\n\tbge %a\n"  3
stmt: GTI(conq,mrc1)  "\tcmpqd %0,%1\n\tbgt %a\n"   3
stmt: GTI(mrc1,conq)  "\tcmpqd %1,%0\n\tblt %a\n"   3
stmt: GTI(mrc1,mrc1)  "\tcmpd %0,%1\n\tbgt %a\n"   3
stmt: LEI(conq,mrc1)  "\tcmpqd %0,%1\n\tble %a\n"  3
stmt: LEI(mrc1,conq)  "\tcmpqd %1,%0\n\tbge %a\n"  3
stmt: LEI(mrc1,mrc1)  "\tcmpd %0,%1\n\tble %a\n"  3
stmt: LTI(conq,mrc1)  "\tcmpqd %0,%1\n\tblt %a\n"   3
stmt: LTI(mrc1,conq)  "\tcmpqd %1,%0\n\tbgt %a\n"   3
stmt: LTI(mrc1,mrc1)  "\tcmpd %0,%1\n\tblt %a\n"   3
stmt: NEI(conq,mrc1)  "\tcmpqd %0,%1\n\tbne %a\n"  3
stmt: NEI(mrc1,conq)  "\tcmpqd %1,%0\n\tbne %a\n"  3
stmt: NEI(mrc1,mrc1)  "\tcmpd %0,%1\n\tbne %a\n"  3
stmt: GEU(conq,mrc1)  "\tcmpqd %0,%1\n\tbhs %a\n"  3
stmt: GEU(mrc1,conq)  "\tcmpqd %1,%0\n\tbls %a\n"  3
stmt: GEU(mrc1,mrc1)  "\tcmpd %0,%1\n\tbhs %a\n"  3
stmt: GTU(conq,mrc1)  "\tcmpqd %0,%1\n\tbhi %a\n"  3
stmt: GTU(mrc1,conq)  "\tcmpqd %1,%0\n\tblo %a\n"  3
stmt: GTU(mrc1,mrc1)  "\tcmpd %0,%1\n\tbhi %a\n"  3
stmt: LEU(conq,mrc1)  "\tcmpqd %0,%1\n\tbls %a\n"  3
stmt: LEU(mrc1,conq)  "\tcmpqd %1,%0\n\tbhs %a\n"  3
stmt: LEU(mrc1,mrc1)  "\tcmpd %0,%1\n\tbls %a\n"  3
stmt: LTU(conq,mrc1)  "\tcmpqd %0,%1\n\tblo %a\n"  3
stmt: LTU(mrc1,conq)  "\tcmpqd %1,%0\n\tbhi %a\n"  3
stmt: LTU(mrc1,mrc1)  "\tcmpd %0,%1\n\tblo %a\n"  3

stmt: EQD(rmd,rmd)  "\tcmpl %0,%1\n\tbeq %a\n"
stmt: GED(rmd,rmd)  "\tcmpl %0,%1\n\tbge %a\n"
stmt: GTD(rmd,rmd)  "\tcmpl %0,%1\n\tbgt %a\n"
stmt: LED(rmd,rmd)  "\tcmpl %0,%1\n\tble %a\n"
stmt: LTD(rmd,rmd)  "\tcmpl %0,%1\n\tblt %a\n"
stmt: NED(rmd,rmd)  "\tcmpl %0,%1\n\tbne %a\n"

stmt: EQF(rmf,rmf)  "\tcmpf %0,%1\n\tbeq %a\n"
stmt: GEF(rmf,rmf)  "\tcmpf %0,%1\n\tbge %a\n"
stmt: GTF(rmf,rmf)  "\tcmpf %0,%1\n\tbgt %a\n"
stmt: LEF(rmf,rmf)  "\tcmpf %0,%1\n\tble %a\n"
stmt: LTF(rmf,rmf)  "\tcmpf %0,%1\n\tblt %a\n"
stmt: NEF(rmf,rmf)  "\tcmpf %0,%1\n\tbne %a\n"

stmt:  CALLV(addrc)  "#  \tcxp %0\n\tadjspb -%a\n"
reg:   CALLI(addrc)  "#  \tcxp %0\n\tadjspb -%a\n"
freg:  CALLF(addrc)  "#  \tcxp %0\n\tadjspb -%a\n"
dreg:  CALLD(addrc)  "#  \tcxp %0\n\tadjspb -%a\n"
stmt:  CALLV(mr)     "\tcxpd %0\n\tadjspb -%a\n"
reg:   CALLI(mr)     "\tcxpd %0\n\tadjspb -%a\n"
dreg:  CALLD(mr)     "\tcxpd %0\n\tadjspb -%a\n"
freg:  CALLF(mr)     "\tcxpd %0\n\tadjspb -%a\n"


stmt: RETI(reg)   "# ret\n"
stmt: RETF(freg)  "# ret\n"
stmt: RETD(dreg)  "# ret\n"
%%
static void progbeg(argc, argv) int argc; char *argv[]; {
	int i;

	{
		union {
			char c;
			int i;
		} u;
		u.i = 0;
		u.c = 1;
		swap = (u.i == 1) != IR->little_endian;
	}
	parseflags(argc, argv);
	cseg = rsave = 0;

        for (i = R0; i <= R7; i++) {
                if (i>=r_first && i<=r_last) rsave |= 1<<i;
                intreg[i] = mkreg("r%d", i, 1, IREG);
                }
        for (i = F0; i <= F7; i+=1) {
                fltreg[i] = mkreg("f%d", i, 1, FREG);
                if (!(i&1))  {
                        dfltreg[i] = mkreg("F%d", i, 3, FREG);
                        dfltreg[i+1] = NULL;
                    }
                }

	rmap[C] = 
	rmap[S] = 
	rmap[P] = rmap[B] = rmap[U] = rmap[I] = mkwildcard(intreg);
	rmap[F] = mkwildcard(fltreg);
	rmap[D] = mkwildcard(dfltreg);
	tmask[IREG] = 0xff;
	vmask[IREG] = rsave;     /* may be used for register variables */
	tmask[FREG] = 0xff;
	vmask[FREG] = fmask = 0x00;     /* fmask is those to save on call */

        print("; LCC -- target: NS32K  version: " NS32K_VERSION
                                       " (" __DATE__ "  " __TIME__ " GMT)\n");
              
        print(";\t.title\n");

        print("\t.frame\nFR\t.equ *\n");

	quo = mkreg("r1", R1, 1, IREG);         /* was EAX */
	quo->x.regnode->mask |= 1<<R0;
	rem = mkreg("r0", R0, 1, IREG);         /* was EDX */
	rem->x.regnode->mask |= 1<<R1;
}
static void segment(n) int n; {
	if (n == cseg)
		return;
	cseg = n;
	if (cseg == CODE || cseg == LIT)
		print("\t.code%s\n", cseg==LIT?"\t; LITERAL":"");
	else if (cseg == DATA || cseg == BSS)
		print("\t.data%s\n", cseg==BSS?"\t; BSS":"");
}
static void progend() {
	segment(0);
	print("\t.end\n");
}
static void target(p) Node p; {
	assert(p);
	switch (p->op) {

	case MULU:
		setreg(p, rem);
		rtarget(p, 0, intreg[R0]);
		break;
	case DIVU:
		setreg(p, quo);
		rtarget(p, 0, intreg[R0]);
	/***	rtarget(p, 1, intreg[ECX]); ***/
		break;
	case MODU:
		setreg(p, rem);
		rtarget(p, 0, intreg[R0]);
	/***	rtarget(p, 1, intreg[ECX]); ***/
		break;
	case ASGNB:
		rtarget(p, 0, intreg[R2]);
		rtarget(p->kids[1], 0, intreg[R1]);
		break;
	case ARGB:
		rtarget(p->kids[0], 0, intreg[R1]);
		break;
        case CALLV:
	case CALLI:
		setreg(p, intreg[R0]);
		break;
	case CALLF: 
		setreg(p, fltreg[F0]);
		break;
        case CALLD:
		setreg(p, dfltreg[F0]);
		break;
	case RETI:
		rtarget(p, 0, intreg[R0]);
		p->kids[0]->x.registered = 1;
		break;
        case RETF:  
                rtarget(p, 0, fltreg[F0]);
                break;
        case RETD:
                rtarget(p, 0, dfltreg[F0]);
                break;
	}
}

static void clobber(p) Node p; {
	assert(p);
	switch (p->op) {
        case MULU:  case MODU:
/***		spill(1<<R1, IREG, p);  ****/
                break;
        case DIVU:
/***		spill(1<<R1, IREG, p);  ****/
                break;
	case ASGNB: case ARGB:
		spill(1<<R0, IREG, p);
		break;
	case CALLD: case CALLF:
        case CALLI: case CALLV: case CALLB:
/****           spill( fmask, FREG, p);      *****/
		break;
	}
}
static int memop(p) Node p; {
	assert(p);
	assert(generic(p->op) == ASGN);
	assert(p->kids[0]);
	assert(p->kids[1]);
	if (generic(p->kids[1]->kids[0]->op) == INDIR
	&& sametree(p->kids[0], p->kids[1]->kids[0]->kids[0]))
		return 3-((struct _state *)(LEFT_CHILD(p)->x.state))->cost[_addr_NT];
/***		return 3;   ****/
	else
		return LBURG_MAX;
}
static int memop2(p) Node p; {
        Node q;
	assert(p);
	assert(generic(p->op) == ASGN);
	assert(p->kids[0]);
	assert(p->kids[1]);
        q = p->kids[1]->kids[0];
        assert(q);
	if (generic(q->kids[0]->op) == INDIR
	&& sametree(p->kids[0], q->kids[0]->kids[0]))
		return 3-((struct _state *)(LEFT_CHILD(p)->x.state))->cost[_addr_NT];
/***		return 3;   ****/
	else
		return LBURG_MAX;
}
static int atoi2(char *c) {
    int res = 0;
    int radix = 10;    
    int ch;    
    if (*c==0) {
        if (c[1]=='x'||c[1]=='X') { radix=16; c++; }
        else  radix=8; 
        c++;
    }       
    else if (*c=='#') {radix=16; c++; }
    
    while (ch=*c++) {
        if (ch>='0'&&ch<='9') ch-='0';
        else if (ch>='a'&&ch<='f') ch-='a'-10;
        else if (ch>='A'&&ch<='F') ch-='A'-10;
        res *= radix;
        res += ch;
    }
    return res;    
}
static int insertop(p) Node p; {
        Node q;

	assert(p);
	assert(generic(p->op) == ASGN);
	assert(p->kids[0]);
	assert(q = p->kids[1]);
        if (q->op == BORU) {
            assert(q->kids[0]);
            assert(q->kids[1]);
            if (q->kids[0]->op == BANDU  &&  q->kids[1]->op == BANDU) {
                Node ca, cb;
                ca = q->kids[0]->kids[1];
                cb = q->kids[1]->kids[1];
                assert(ca && cb);
                if (generic(ca->op) == CNST  &&  generic(cb->op) == CNST) {
                    int ia, ib;
                    ia = atoi2(ca->syms[0]->x.name);
                    ib = atoi2(cb->syms[0]->x.name);
#ifdef MATCHOUT
             printf("; match0 ia=%x, ib=%x!\n", ia, ib);
#endif
                    if (ia == ~ib) {
                        q = q->kids[0]->kids[0];
                        assert(q);
                        if (q->op == CVIU  ||  q->op == CVUI) q = q->kids[0];
                        assert(q);
#ifdef MATCHOUT
             printf("; match1!\n");
             if (generic(q->op) == INDIR) printf("; match1a!\n");
#endif
                        if (generic(q->op) == INDIR
                                && sametree(p->kids[0], q->kids[0]) ) {
#ifdef MATCHOUT
             printf("; match2!\n");
#endif
                            return 1-((struct _state *)(LEFT_CHILD(p)->x.state))->cost[_addr_NT];
                        }
                    }
                }
            }
        } 
        
        return LBURG_MAX;
}

static int sametree(p, q) Node p, q; {
	return p == NULL && q == NULL
	|| p && q && p->op == q->op && p->syms[0] == q->syms[0]
		&& sametree(p->kids[0], q->kids[0])
		&& sametree(p->kids[1], q->kids[1]);
}

#define preg(f) ((f)[getregnum(p->x.kids[0])]->x.name)
static void emit2(p) Node p; {
        static int icase = 0;
#ifdef CASE_ESCAPE
        static char *CaseLabel, CaseExpr[32] = { 0 };      /* save case label here */
#endif

        if (p->op == LABELV) {
#ifdef CASE_ESCAPE
                if (InSwitch && *CaseExpr) {
                        print("%s\t.equ %s\n", CaseLabel, CaseExpr);
                        *CaseExpr = '\000';
                }
#endif
                InSwitch = 0;
                print("%s\n", p->syms[0]->x.name);
        }
        else if (p->op == JUMPV) {
                char *sa, *sr;

                p = LEFT_CHILD(LEFT_CHILD(p));
                sa = RIGHT_CHILD(p)->syms[0]->x.name;
                assert(sa);
#ifdef CASE_ESCAPE
                for (sr = sa+1; *sr; ++sr) {
                        if (*sr=='-' || *sr=='+') {
                                strcpy(CaseExpr, sa);
                                sr[0] = 'C';
                                sr[1] = '\000';
                                CaseLabel = sa;
                                break;
                        }
                }
#endif
                sr = LEFT_CHILD(LEFT_CHILD(p))->syms[RX]->x.name;
                assert(sr);
                InSwitch = ++icase;
                print("C%d\tcased %s[%s:D]\n", icase, sa, sr);
        }
	else if (p->op == CALLI || p->op == CALLV ||
                      p->op == CALLF || p->op == CALLD) {
                int i;
                Node q;

                if ((q=LEFT_CHILD(p))->op == ADDRGP) {
                        Symbol s = q->syms[0];
                        if ((s->x.eaddr&EXTP)==0 && (s->sclass==EXTERN ||
                            (s->sclass==AUTO && !s->defined) ) ) {
                                print("\t.extp %s\n", s->x.name);
                                s->x.eaddr |= EXTP;
                                }                
	                print( s->sclass==STATIC || 
                          (s->sclass==AUTO && s->defined)    ?
                                "\tsprd mod,tos\n\tbsr %s\n" : "\tcxp %s\n",
                                                    q->syms[0]->x.name);
                } else {
                        print(";\tindirect CALLI: \n");
/* this doesn't work because we don't know how to recurse */
                        print(";\tindirect CALLI: %s %s\n", 
                                p->kids[0]->syms[RX]->x.name, p->syms[0]->x.name);
                }
                i = atoi(p->syms[0]->x.name);
                if (i) print("\tadjsp%c -%d\n", i>128 ? 'w' : 'b', i);
        }
        else if (p->op == ARGB || p->op == ASGNB) {
                int size = atoi(p->syms[0]->x.name);
                char *dst = "r2";
                char bwd;
                assert(size%4==0);
                if (p->op == ARGB) {
                    if (size<=127) bwd = 'b';
                    else if (size<=32767) bwd = 'w';
                    else bwd = 'd';
                    print("\tadjsp%c %d\n", bwd, size);
                    if (size>16) print("\taddr tos,r2\n", size);
                    else dst = "tos";
                }
                size /= 4;
                if (size<=4) print("\tmovmd r1,%s,%d\n", dst, size);
                else {
                    print("\tmov");    
                    if (size<=7) print("q");
                    else if (size<=127) print("zb");
                    print("d %d,r0\n\tmovsd\n", size);
                }
        }
	else if (p->op == ASGNI && p->kids[1]->op == BORU) {
                print("; I think we got an insert\n");
        }
/**************************************************************************
	else if (p->op == CVCI)
		print("\tmovxbd %s,%s\n", preg(intreg)
                                        , p->syms[RX]->x.name);
	else if (p->op == CVCU)
		print("\tmovzbd %s,%s\n", preg(intreg)
                                        , p->syms[RX]->x.name);
	else if (p->op == CVSI)
		print("\tmovxwd %s,%s\n", preg(intreg)
                                        , p->syms[RX]->x.name);
	else if (p->op == CVSU)
		print("\tmovzwd %s,%s\n", preg(intreg)
                                        , p->syms[RX]->x.name);
	else if (p->op == CVIC || p->op == CVIS
	      || p->op == CVUC || p->op == CVUS) {
		char *dst = intreg[getregnum(p)]->x.name;
		char *src = preg(intreg);
		if (dst != src)
			print("\tmovd %s,%s\n", src, dst);
	}
*************************************************************************/
}

static void doarg(p) Node p; {
	assert(p && p->syms[0]);
	mkactual(4, p->syms[0]->u.c.v.i);
}
static void blkfetch(k, off, reg, tmp)
int k, off, reg, tmp; {}

static void blkstore(k, off, reg, tmp)
int k, off, reg, tmp; {}

static void blkloop(dreg, doff, sreg, soff, size, tmps)
int dreg, doff, sreg, soff, size, tmps[]; {}

static void local(p) Symbol p; {
/*********************************************************
	if (isfloat(p->type))
		p->sclass = AUTO;
*********************************************************/
	if (askregvar(p, rmap[ttob(p->type)]) == 0)
		mkauto(p);
}
static void function(f, caller, callee, n)
Symbol f, callee[], caller[]; int n; {
	int i;

usedmask[IREG] = usedmask[FREG] = 0;
freemask[IREG] = freemask[FREG] = ~(unsigned)0;
	offset = 8 + 4;
	for (i = 0; callee[i]; i++) {
		Symbol p = callee[i];
		Symbol q = caller[i];
		assert(q);
		p->x.offset = q->x.offset = offset;
		p->x.name = q->x.name = stringf("%d", p->x.offset);
		p->sclass = q->sclass = AUTO;
		offset += roundup(q->type->size, 4);
	}
	assert(caller[i] == 0);
	offset = maxoffset = 0;
	gencode(caller, callee);
	framesize = roundup(maxoffset, 4);

	print("\t.align 4\n"
              "%s\n"
              "\tenter R%s,%d\n", f->x.name, f->x.name, framesize);
	emitcode();
        print("\texit R%s\n\trxp 0\nR%s .equ [", f->x.name, f->x.name);
        { int j=0;
        for (i=r_first; i<=r_last; i++) {
                if (1<<i & usedmask[IREG]) {
                        if (j) print(",r%d", i);
                        else print("r%d", i);
                        j = 1;
                }
        } /* end for */ }
        print("]\n");
}
static void defsymbol(p) Symbol p; {
	if (p->scope >= LOCAL && p->sclass == STATIC)
		p->x.name = stringf("L%d", genlabel(1));
	else if (p->generated)
		p->x.name = stringf("L%s", p->name);
/****	else if (p->scope == GLOBAL && p->sclass == STATIC)
		p->x.name = stringf("?%s", p->name);            ****/
	else if (p->scope == GLOBAL || p->sclass == EXTERN)
		p->x.name = stringf("_%s", p->name);
	else if (p->scope == CONSTANTS
	&& (isint(p->type) || isptr(p->type))
	&& p->name[0] == '0' && p->name[1] == 'x')
		p->x.name = stringf("#%s", &p->name[2]);
	else if (p->scope == CONSTANTS && ischar(p->type) ) {
                signed char c = atoi(p->name);
		p->x.name = stringf("%d", (int)c);
        }
	else
		p->x.name = p->name;
}
static void address(q, p, n) Symbol q, p; int n; {
	if (p->scope == GLOBAL
	|| p->sclass == STATIC || p->sclass == EXTERN)
		q->x.name = stringf("%s%s%d",
			p->x.name, n >= 0 ? "+" : "", n);
	else {
		n = q->x.offset = p->x.offset + n;
/******		q->x.name = stringd(q->x.offset);  ******/
		q->x.name = stringf("%s%d", n >= 0 ? "+" : "", n);
	}
}
static void defconst(ty, v) int ty; Value v; {
	switch (ty) {
		case C: print("\t.ds b(%d)\n",   v.uc); return;
		case S: print("\t.ds w(%d)\n",   v.ss); return;
		case I: print("\t.ds d(%d)\n",   v.i ); return;
		case U: print("\t.ds d(#%x)\n", v.u ); return;
		case P: print("\t.ds d(#%x)\n", v.p ); return;
		case F:
			print("\t.ds f(#%x)\n", *(unsigned *)&v.f);
			return;
		case D: {
			unsigned *p = (unsigned *)&v.d;
			print("\t.ds d(#%x),d(#%x)\n", p[swap], p[1 - swap]);
			return;
			}
	}
}
static void defaddress(p) Symbol p; {
        if (InSwitch) print("\t.ds d(%s-C%d)\n", p->x.name, InSwitch);
	else {
                if (p->type->op == FUNCTION) {
                        if ((p->x.eaddr & ENTP) == 0)
                                print("\t.entp %s\t; KLUDGE !!!\n", p->x.name);
                        p->x.eaddr |= ENTP;
                        if ((p->x.eaddr & EXTP) == 0)
                                print("\t.extp %s\n", p->x.name);
                        p->x.eaddr |= EXTP;
                }
                print("\t.ds d(%s)\t; ADDRESS\n", p->x.name);
        }
}
#define isascii(c) ((c)>=040 && (c)<0177)
#define QUOTE "\""
static void defstring(n, str) int n; char *str; {
	unsigned char *s;
        int m, k;
        
        s = str;
        while (n) {
                for (m=0; m<n && isascii(s[m]) && s[m]!=*(QUOTE);
                     m++) ;
                if (m>0 && m<n && s[m]==0) {
                        print("\t.textz "QUOTE"%s"QUOTE"\n", s); 
                        n -= ++m;
                        s += m;
                } else if (m>0) { char t = s[m];
                        s[m] = 0;
                        print("\t.text "QUOTE"%s"QUOTE"\n", s); 
                        s[m] = t;
                        n -= m;
                        s += m;
                } else {
                        print("\t.ds b(%d)\n", (*s)&0377);
                        n--;
                        s++;
                }
        }
}


static void export(p) Symbol p; {
        if (p->type->op == FUNCTION) {
                if ((p->x.eaddr & ENTP) == 0)
                        print("\t.entp %s\n", p->x.name);
                p->x.eaddr |= ENTP;
        } else {
                if (p->u.seg==BSS) {
                        print("\t.comm %s,%d,%d\n", p->x.name, p->type->size,
                		p->type->align > 4 ? 4 : p->type->align);
                } else
                        print("\t.entd %s\n", p->x.name);
        }
}
static void import(p) Symbol p; {
        static int flag = 0;
        if (!flag) {
            print("; begin import section\n");
            flag++;
        }
	if (p->ref > 0) {
           if (p->type->op == FUNCTION) {
                if ((p->x.eaddr & EXTP)==0)
                    print("\t.extp %s\n", p->x.name);
                p->x.eaddr |= EXTP;
           } else print("\t.extd %s\n", p->x.name);
        }
}
static void global(p) Symbol p; {

if (p->sclass == STATIC) {
        if (p->type->align > 1)   print("\t.align %d\n",
                        p->type->align > 4 ? 4 : p->type->align);

	print("%s\n", p->x.name);
	if (p->u.seg == BSS)
		print("\t.ds (%d)b\n", p->type->size);
} else {
        if (p->u.seg != BSS) {

        if (p->type->align > 1)   print("\t.align %d\n",
                        p->type->align > 4 ? 4 : p->type->align);

        	print("%s\n", p->x.name);
        }
}
}
static void space(n) int n; {
	if (cseg != BSS)
		print("\t.ds (%d)b(0)\t; space\n", n);
}
Interface ns32kIR = {
	1, 1, 0,  /* char */
	2, 2, 0,  /* short */
	4, 4, 0,  /* int */
	4, 4, 1,  /* float */
	8, 4, 1,  /* double */
	4, 4, 0,  /* T * */
	0, 4, 0,  /* struct; so that ARGB keeps stack aligned */
	1,        /* little_endian */
	0,        /* mulops_calls */
	0,        /* wants_callb */
	1,        /* wants_argb */
	0,        /* left_to_right */
	0,        /* wants_dag */
	address,
	blockbeg,
	blockend,
	defaddress,
	defconst,
	defstring,
	defsymbol,
	emit,
	export,
	function,
	gen,
	global,
	import,
	local,
	progbeg,
	progend,
	segment,
	space,
	0, 0, 0, 0, 0, 0, 0,
	{1, blkfetch, blkstore, blkloop,
	    _label,
	    _rule,
	    _nts,
	    _kids,
	    _opname,
	    _arity,
	    _string,
	    _templates,
	    _isinstruction,
	    _ntname,
	    emit2,
	    doarg,
	    target,
	    clobber,
}
};
