/*
 *
 * Non-expanded forms of basic type
*/
#include <stdio.h>

#include <ert.H>
#include <string.H>
#include <any.H>
#include <numeric.H>
#include <real_ref.H>

class STRING;

REAL_REF::REAL_REF () {
#ifdef _BOOLEAN_REF_H
	val = false; 
#else
	val = 0; 
#endif
	class_id = _bibt_REAL_REF_id;		/* defined in ert.H */
	c_object_address = (POINTER) this;
	c_class_name = (POINTER) "REAL_REF";
}

void REAL_REF::set_value ( REAL v) { val = v; }

REAL REAL_REF::item () { return val; }

void REAL_REF::_Copy ( int deep, int sclass, REAL_REF* v) { 
	val = v->val; 
}

BOOLEAN REAL_REF::_Equal ( int deep, int sclass, REAL_REF* v) {
	return v->val == val ? true : false; 
}

STRING* REAL_REF::out() { 
	STRING *result;

   	result = new STRING;
   	result->make_from_real ( val);
	return result;
}

				 	/* BUG! we don't have STD_FILES available */
void REAL_REF::print ( ANY *s)
{ 
	fprintf ( stderr, "%d", val); 
}
 
REAL_REF* REAL_REF::_Clone (
					int deep, int sclass, REAL_REF *_arg) { 
	REAL_REF *r = new REAL_REF; r->val = _arg->val; return r; 
}

REAL_REF*
_ert_clone_REAL ( REAL v)
{
	REAL_REF *result;
	result = new REAL_REF;
	result->val = v;
	return result;
}

REAL_REF*
_ert_clone_REAL_REF ( REAL_REF *v)
{
	if ( v) {
		REAL_REF *result;
		result = new REAL_REF;
		result->val = v->val;
		return result;
	}

	return ( REAL_REF *) 0;
}

REAL_REF *_REAL_REF_chk(REAL_REF *rtc, char *fname)
{
   if ( !rtc)
      _eiffel_rt_Assert ( 107, "REAL_REF", fname, "void target", 
			false, _ert_longjmp());
   return rtc;
}


BOOLEAN REAL_REF::is_equal (REAL_REF* p1) { 
	return _Equal( 1, 1, p1); 
}

BOOLEAN REAL_REF::equal (ANY* p1, REAL_REF* p2) { 
	return (p1)->_Equal ( 0, 1, p2); 
}

void REAL_REF::copy ( REAL_REF* p1) { 
	_Copy ( 0, 1, p1); 
}

REAL_REF* REAL_REF::clone (REAL_REF *x) {
	 return _Clone( 0, 1, x); 
}

REAL_REF* REAL_REF::_localClone ( int deep, int sclass) { 
	REAL_REF *r = new REAL_REF; r->val = val; return r; 
}

BOOLEAN REAL_REF::deep_equal ( REAL_REF* p1, REAL_REF* p2) {
	 return p1->_Equal ( 1, 1, p2); 
}

void REAL_REF::deep_copy ( REAL_REF* p1) { 
	_Copy ( 1, 1, p1); 
}

REAL_REF* REAL_REF::deep_clone ( REAL_REF *x) {
	 return _Clone (1,1,x); 
}

REAL_REF* _bibt_REAL_REAL_REF ( REAL v)
{
	REAL_REF *result;
	result = new REAL_REF;
	result->set_value ( v);
	return result;
}

#ifndef _BOOLEAN_REF_H

BOOLEAN REAL_REF::_INFIX_LEQ ( REAL_REF* other)
{
	return val < _REAL_REF_chk ( other, "other")->val ? 
       		_ert_BOOLEAN_Const ( true) : _ert_BOOLEAN_Const ( false);
}

REAL_REF* REAL_REF::_INFIX_ADD ( REAL_REF* other)
{
	REAL_REF *r = new REAL_REF; 
	r->val = _REAL_REF_chk ( other, "other")->val + val;
	return r;
}

REAL_REF* REAL_REF::_INFIX_SUB ( REAL_REF* other)
{
	REAL_REF *r = new REAL_REF; 
	r->val = _REAL_REF_chk ( other, "other")->val - val;
	return r;
}

REAL_REF* REAL_REF::_INFIX_MUL ( REAL_REF* other)
{
	REAL_REF *r = new REAL_REF; 
	r->val = _REAL_REF_chk ( other, "other")->val * val;
	return r;
}

REAL_REF* REAL_REF::_INFIX_DIV ( REAL_REF* other)
{
	REAL_REF *r = new REAL_REF; 
	r->val = _REAL_REF_chk ( other, "other")->val / val;
	return r;
}
#endif /* _BOOLEAN_REF_H */

BOOLEAN REAL_REF::_Conforms_to ( int other_id)  /* Don't use REAL */
{
   	if ( class_id == other_id)
      	return true;

#ifdef _BOOLEAN_REF_H
	{
		ANY a;

		return a._Conforms_to ( other_id);
	}
#else
	{
   		NUMERIC n;

   		if ( n.class_id == other_id)
      		return true;

		return n._Conforms_to ( other_id);
	}
#endif
}
