deferred class COMPARABLE

feature

   infix "<" (other: like Current): BOOLEAN is
         -- Is current element less than `other'?
      deferred
      ensure
         Result implies (not (Current >= other))
      end -- "<"

   infix "<=" (other: like Current): BOOLEAN is
         -- Is current element less than or equal to `other'?
      do
         Result := not (other < Current)
      ensure
         Result implies (not (Current > other))
      end -- "<="

   infix ">" (other: like Current): BOOLEAN is
         -- Is current element greater than `other'?
      do
         Result := other < Current
      ensure
         Result implies (not (Current <= other))
      end -- ">"

   infix ">=" (other: like Current): BOOLEAN is
         -- Is current element greater than or equal to `other'?
      do
         Result := not (Current < other)
      ensure
         Result implies (not (Current < other))
      end -- ">="

end -- class COMPARABLE
