#if !defined (DEBUG)
#define DEBUG 1
#endif

#include <AppKit.h>
#include <InterfaceKit.h>
#include <Debug.h>

#include <stdio.h>
#include <stdlib.h>
#include "gtk/gtk.h"
#include "libgimp/gimp.h"
#include "libgimp/gimpui.h"
#include "libgimp/gimpprotocol.h"

#include "IEWindow.h"
#include "FilterViews.h"
#include "GimpStub.h"
#include "TBitmap.h"
#include "Document.h"
#include "Benaphore.h"

//-----------------------------------------------------------------------------------------------
//	To port a GIMP filter,
//
//		Replace in the project settings the correct filter name
//		Replace in the project settings the correct define for the class name.
//		replace StrucValues by the structure used in the filter (passed to get and set_data).
//		replace "struc" by the name of the IEWindow
//		put whatever is needeed in the constructor for GIMPDlog
//		In the destructor, add whatever is necessary.
//		Update DoPreview
//		Update MessageReceived
//		Update DoIt
//		
//-----------------------------------------------------------------------------------------------
typedef struct {
  int	radius;
  int	type;
  int	blackLevel;
  int	whiteLevel;
} StrucValues;

extern "C" StrucValues		despeckle_vals;

typedef struct ReturnValue {
	BMessage	*msg;
	bool		done;
};

class GIMPDlog : public IEWindow {
public:
	GIMPDlog (ReturnValue *ret, FILTER_NAME *filter, TFilterParams *parms);
	~GIMPDlog(void);

virtual	void		MessageReceived(BMessage *message);
virtual	bool		QuitRequested (void);
		void		DoPreview (void);
//public:
protected:
	FILTER_NAME			*fFilter;
	TFilterParams		*fParms;
	BSliderTextHelper	*fHelper;
	ReturnValue			*fReturn;
	StrucValues			fVals;
	bool				fPreview;
};

GIMPDlog::GIMPDlog (ReturnValue *ret, FILTER_NAME *filter, TFilterParams *parms) : IEWindow("struc") {
	ASSERT (!ret->done); fReturn = ret; fReturn->msg = NULL;
	AddTemporaryBPath (NULL); fParms = parms; fFilter = filter;

	fVals = despeckle_vals;
	fPreview = true;
	Lock ();
	char	radioName[2] = { 48, 0 };
	*radioName = 48 + fDirection;
	BControl	*ctl = (BControl *) FindView (radioName);
	ASSERT (ctl); if (ctl) ctl->SetValue (1);
	BTextControl	*txtCtl = (BTextControl *)FindView ("TE"); ASSERT (typeid(*txtCtl)==typeid(BTextControl));
	BSlider			*slider = (BSlider *) FindView ("Slider"); ASSERT (typeid(*slider)==typeid(BSlider));
	fHelper = new BSliderTextHelper (slider, txtCtl); fHelper->SetValue (fDepth);
	//gProgressView = new TDlogProgressView (FindView ("Progress"));
	Unlock ();
	Show();
	DoPreview ();
}

GIMPDlog::~GIMPDlog(void) {
	if (!fReturn->msg) {
		fParms->fDst->Copy (*fParms->fSrc);
		fParms->fDocument->Update (NULL, fParms->fBounds);
	} else  {
		if (!fPreview) {
			fPreview = true;
			DoPreview ();	//	We do the action if it was not previewed.
		}
		VERIFY (B_OK == fFilter->Archive (fReturn->msg, true));
	}
	delete fHelper;
	fReturn->done = true;
}

bool GIMPDlog::QuitRequested (void) {
	gProgressView = NULL;
	return true;
}

void GIMPDlog::DoPreview (void) {
	if (fPreview) {
		fFilter->SetValue (&fVals);
	}
}

// Handling of user interface and other events
void GIMPDlog::MessageReceived (BMessage *message) {
	int32			value;

	switch(message->what){
		case '_xPr':	//	DoMiniPreview (); break;
		case 'Sldr':	value = message->FindInt32 ("be:value");
						if (value != fDepth) {
							fDepth = value;
							DoPreview ();
						}
						break;
		case 'View':	fPreview = !fPreview;
						if (fPreview) {
							DoPreview ();
						} else {
							//	Removes the preview by restoring the original image.
							fParms->fDst->Copy (*fParms->fSrc);
							fParms->fDocument->Update (NULL, fParms->fBounds);
						}
						break;
		case 1000:
		case 1001:
		case 1002:
		case 1003:		if (int32(message->what - 1000) != fDirection) { fDirection = message->what - 1000; DoPreview (); } break;
		case 'Abut':	fFilter->DoAbout (); break;
		case 'OK  ':	fReturn->msg = new BMessage ('Parm'); despeckle_vals = fVals;
		case 'Esc ':	gProgressView = NULL; Quit (); break;
		default:		inherited::MessageReceived(message); break;
	}

}

void FILTER_NAME::DoIt (TFilterParams *parms, const void *values) {
	GParam	inputParms[5], *outputParms;
	gint	cntOutput;

	inputParms[0].type = PARAM_INT32; inputParms[0].data.d_int32 = RUN_NONINTERACTIVE;	//	TBD, determined by the message
	inputParms[2].type = PARAM_DRAWABLE; inputParms[2].data.d_drawable = gint32(parms);
	inputParms[3].type = PARAM_INT32; inputParms[3].data.d_int32 = ((const StrucValues *)values)->direction;
	inputParms[4].type = PARAM_INT32; inputParms[4].data.d_int32 = ((const StrucValues *)values)->depth;
	(*PLUG_IN_INFO.run_proc) (fName, 5, inputParms, &cntOutput, &outputParms);
}

BMessage *FILTER_NAME::ApplyFilter (TFilterParams *parms) {
	BMessage	*result = NULL;

	if (fInited) {
		ASSERT (fLock == NULL);
		DoIt (parms, fData);
	} else {
		ReturnValue	returnVal;

		fLock = new Benaphore ("Synchro Dialog");
		returnVal.done = fChanged = false; fInited = true;
		AddTemporaryBPath (filterFile);
		new GIMPDlog (&returnVal, this, parms);
		do {
			if (fChanged) {
				fLock->Lock ();
				StrucValues	tmpValues;
				memcpy (&tmpValues, fData, sizeof (StrucValues));
				fChanged = false;
				fLock->Unlock ();
				DoIt (parms, &tmpValues);
				parms->fDocument->FilterUpdate (parms);
			} else {
				snooze (250000);
			}
		} while (!returnVal.done);
		result = returnVal.msg;
	}
	return result;
}

void FILTER_NAME::PrepareData (void) {
	fData = (void *) new char [sizeof(StrucValues)]; fDataSize = sizeof (StrucValues);
	ASSERT (fData);
}

void FILTER_NAME::DisposeData (void) {
	delete (StrucValues *)fData;
}

void FILTER_NAME::SetValue (void *value) {
	ASSERT (fLock);
	fLock->Lock ();

	memcpy (fData, value, sizeof(StrucValues));
	fChanged = true;
	fLock->Unlock ();
}

void gimp_get_data (gchar *id, gpointer data) {
	ASSERT (gCurFilter); gCurFilter->GetData (id, data);
}

void gimp_set_data (gchar *id, gpointer data, guint32 length) {
	ASSERT (gCurFilter); gCurFilter->SetData (id, data, length);
}

