********************************************************************
**                                                                **
**                  IBM-PC Installation of DISLIN                 **
**                                                                **
**  Contents:  1.)  Introduction                                  **
**             2.)  Installation of DISLIN                        **
**             3.)  Getting DISLIN Support                        **
**                                                                **
**  Date   :   15.03.2022                                         **
**  Version:   11.5 / Windows, C interpreter Ch                   **
**  Author :   Helmut Michels                                     **
**             Dislin Software                                    **
**             Am Hachweg 10                                      **
**             37083 Gttingen, Germany                           **
**  Email  :   michels@dislin.de                                  **
********************************************************************

1.)  Introduction

     This file describes the installation of the Dislin distribution
     for the C interpreter Ch on Windows.

2.)  Installation of DISLIN

     The Ch distribution of DISLIN is contained in the zipped file
     dl_11_ch.zip.  A utility for unpacking the DISLIN files is 
     available from the same location where you have downloaded 
     dl_11_ch.zip, or from the DISLIN CD-ROM. 

     To install DISLIN, make the following steps:

  a) Create a temporary directory and copy the files dl_11_ch.zip
     and unzip.exe to it:

     for example:   md  c:\temp
                    cd  c:\temp
                    copy e:\dislin\windows\unzip.exe    *.*
                    copy e:\dislin\windows\dl_11_ch.zip *.*

  b) Extract the DISLIN files with the command:

                 unzip  -o dl_11_ch.zip

  c) Run the setup program with the command

                  setup

     -  Choose OK

     -  Give the Installation Directory where  DISLIN  should be in-
        stalled. The default directory is C:\DISLIN.

  d) Reconfigure the System

     Set the DISLIN environment variable to c:\dislin and include
     c:\dislin\win in your path. If you have installed DISLIN in a
     different directory, you have to use that directory for the 
     environment variables above.

     The environment variables can be set or modified with the Control
     Panel 
    
     (see Control Panel -> System -> Advanced -> Environment
      Variables).
   
  e) Now you run the example programs in the DISLIN subdirectory
     examples\ch with the command

     ch curve.ch    
     ch bars.ch
     ...

     Notes:
 
        - The directory examples\ch contains the header file 'dislin.h'
          which is used by the .ch examples. The file 'dislin.h' contains
          two pragma statements for setting the _fpath and _lpath system
          variables with the Dislin installation directory. If you have
          not installed Dislin in the default directory c:\dislin, you 
          have to change the pragma statements corresponding to your
          Dislin installation. 

        - The shareable library dislin.dl for Ch is based on the double
          precision C library of Dislin.
 

3.)  Getting DISLIN Support

     The DISLIN distributions can be used freely without any restriction.
     Access to the source code is availabe via a support contract from the
     site www.dislin.de.
