/*****************************************************************************/
/* File name: Device.java                                                    */
/* Purpose: additional things to work on devices                             */
/* Last modified: 11.10.98                                                   */
/* Author: Victor Klimov, 1998                                               */
/*                                                                           */
/* This program is distributed in the hope that it will be useful, but       */
/* WITHOUT ANY WARRANTY; without even the implied warranty of                */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General */
/* Public License for more details.                                          */
/*                                                                           */
/* This software is distributed under the terms                              */
/* of the GNU General Public License as published                            */
/* by the Free Software Foundation; either version 2, or (at your option)    */
/* any later version.                                                        */
/* See file COPYING for your rights (GNU GPL)                                */
/*****************************************************************************/

package util;


final

public
class

Device

{

  private final static java.lang.String RCSID = "$Header: /d/JTAR03/util/RCS/Device.java,v 1.3 1998/12/13 17:19:21 vklimov Exp $";


  Device( )
/*****************************************************************************/
/* Function name: Device                                                     */
/* File name: Device.java                                                    */
/* Purpose: constructor for the object major - minor object                  */
/* Parameters:                                                               */
/* Returns:                                                                  */
/* Last modified: 03.10.98                                                   */
/* Author: Victor Klimov, 1998                                               */
/*****************************************************************************/
    {
                                                            /* Device */
/*---------------------------------------------------------------------------*/

    }
/*end of Device*/


  public
  static
  int
  major( int Device )
/*****************************************************************************/
/* Function name: major                                                      */
/* File name: Device.java                                                    */
/* Purpose: to get a major number form a device field (e.g. from rdev)      */
/* Parameters: Device                                                        */
/* Returns: major number                                                     */
/* Last modified: 12.12.98                                                   */
/* Author: Victor Klimov, 1998                                               */
/*****************************************************************************/
    {
      int majorNumber;
                                                            /* major */
/*---------------------------------------------------------------------------*/

      majorNumber = (Device >> 8) & 0xff;
      return majorNumber;

    }
/*end of major*/


  public
  static
  int
  minor( int Device )
/*****************************************************************************/
/* Function name: minor                                                      */
/* File name: Device.java                                                    */
/* Purpose: to get a minor number form a device field (e.g. from rdev)       */
/* Parameters: Device                                                        */
/* Returns: minor number                                                     */
/* Last modified: 12.12.98                                                   */
/* Author: Victor Klimov, 1998                                               */
/*****************************************************************************/
    {
      int minorNumber;
                                                            /* minor */
/*---------------------------------------------------------------------------*/

      minorNumber = Device & 0xff;
      return minorNumber;

    }
/*end of minor*/


} /*end of Device */

/*****************************************************************************/
/* End of file: Device.java                                                  */
/*****************************************************************************/
