/*****************************************************************************/
/* File name: Names.java                                                     */
/* Purpose: descriptor object for a single file hole                         */
/* Last modified: 12.12.98                                                   */
/* Author: Victor Klimov, 1998                                               */
/*                                                                           */
/* This program is distributed in the hope that it will be useful, but       */
/* WITHOUT ANY WARRANTY; without even the implied warranty of                */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General */
/* Public License for more details.                                          */
/*                                                                           */
/* This software is distributed under the terms                              */
/* of the GNU General Public License as published                            */
/* by the Free Software Foundation; either version 2, or (at your option)    */
/* any later version.                                                        */
/* See file COPYING for your rights (GNU GPL)                                */
/*****************************************************************************/

package jtar;

import java.lang.*;
import util.*;
import general.*;


final

class

Names

     implements jtar.Constants, general.Constants

{

  private final static java.lang.String RCSID = "$Header: /d/JTAR03/jtar/RCS/Names.java,v 1.4 1998/12/13 17:19:20 vklimov Exp $";

                            /* Make sure you link with the proper libraries */
                            /* if you are running the Yellow Peril (thanks  */
                            /* for the good laugh, Ian J.!), or, euh... NIS */
                            /* This code should also be modified            */
                            /* for non-UNIX systems to do something         */
                            /* reasonable                                   */

  static StringBuffer cachedUname = new StringBuffer( 0 );
  static StringBuffer cachedGname = new StringBuffer( 0 );

  static int cachedUid;        /* valid only if cachedUname is not empty */


  Names( )
/*****************************************************************************/
/* Function name: Names                                                      */
/* File name: Names.java                                                     */
/* Purpose: constructor for the object Names                                 */
/* Parameters:                                                               */
/* Returns:                                                                  */
/* Last modified: 04.10.98                                                   */
/* Author: Victor Klimov, 1998                                               */
/*****************************************************************************/
    {
                                                            /* Names */
/*---------------------------------------------------------------------------*/

    }
/*end of Names*/


  static
  boolean
  gnameToGid( java.lang.String gnameString, c.Stat currentStat )
/*****************************************************************************/
/* Function name: gnameToGid                                                 */
/* File name: Names.java                                                     */
/* Purpose: to set gid (the gid field in currentStat) according to gname     */
/*          Currently no search and no match is performed, only default      */
/*          value is assigned                                                */
/* Parameters: gnameString - the name to define user ID                      */
/*             currentStat - the stat object to set the uid field in         */
/* Returns: true - if everything is OK                                       */
/*          false - otherwise                                                */
/* Last modified: 12.12.98                                                   */
/* Author of the Java translation: Victor Klimov, 1998                       */
/*****************************************************************************/
    {
      int nCharNull;
      int lengthGname;
      StringBuffer gname;
                                                       /* gnameToGid */
/*---------------------------------------------------------------------------*/

      nCharNull = gnameString.indexOf( NULL_CHAR );
      gname = new StringBuffer( gnameString );
      lengthGname = gname.length();
      if (nCharNull > JAVA_ERROR_CODE)
        gname.setLength( nCharNull );
      else
        ;
    /*end of if*/

      if ( (cachedGname.length() == 0)  ||
          !gname.equals( cachedGname ) )
        {
          cachedUid = DEFAULT_UID;
          cachedGname.setLength( 0 ); /* clear */
          cachedGname.append( gnameString );
        }
      else
        ;
    /*end of if*/

      return true;
    }
/*end of gnameToGid*/


  static
  boolean
  unameToUid( java.lang.String unameString, c.Stat currentStat )
/*****************************************************************************/
/* Function name: unameToUid                                                 */
/* File name: Names.java                                                     */
/* Purpose: to set uid (the uid field in currentStat) according to uname     */
/*          Currently no search and no match is performed, only default      */
/*          value is assigned                                                */
/* Parameters: unameString - the name to define user ID                      */
/*             currentStat - the stat object to set the uid field in         */
/* Returns: true - if everything is OK                                       */
/*          false - otherwise                                                */
/* Last modified: 12.12.98                                                   */
/* Author of the Java translation: Victor Klimov, 1998                       */
/*****************************************************************************/
    {
      int nCharNull;
      int lengthUname;
      StringBuffer uname;
                                                       /* unameToUid */
/*---------------------------------------------------------------------------*/

      nCharNull = unameString.indexOf( NULL_CHAR );
      uname = new StringBuffer( unameString );
      lengthUname = uname.length();
      if (nCharNull > JAVA_ERROR_CODE)
        uname.setLength( nCharNull );
      else
        ;
    /*end of if*/

      if ( (cachedUname.length() == 0)  ||
          !uname.equals( cachedUname ) )
        {
          cachedUid = DEFAULT_UID;
          cachedUname.setLength( 0 ); /* clear */
          cachedUname.append( unameString );
        }
      else
        ;
    /*end of if*/

      return true;
    }
/*end of unameToUid*/


  static
  boolean
  checkExclude( java.lang.String name )
/*****************************************************************************/
/* Function name: checkExclude                                               */
/* File name: Names.java                                                     */
/* Purpose: to determine whether the name (from an archive) should not be    */
/*          added nor extracted                                              */
/* Parameters: name to check                                                 */
/* Returns: true - if the name should not be added nor extracted             */
/*          false - otherwise                                                */
/* Last modified: 12.12.98                                                   */
/* Author of the Java translation: Victor Klimov, 1998                       */
/*****************************************************************************/
    {
      int counter;
                                                       /* checkExclude */
/*---------------------------------------------------------------------------*/

      return false; /* we exclude nothing for the time being */

    }
/*end of checkExclude*/


  static
  boolean
  nameMatch( java.lang.String path )
/*****************************************************************************/
/* Function name: nameMatch                                                  */
/* File name: Names.java                                                     */
/* Purpose: to determine whether the path name (from an archive) matches     */
/*          any name from the namelist                                       */
/* Parameters: path - name of a file from a tar archive                      */
/* Returns: true - if the path matches to some name from the namelist        */
/*          false - otherwise                                                */
/* Last modified: 12.12.98                                                   */
/* Author of the Java translation: Victor Klimov, 1998                       */
/*****************************************************************************/
    {
      int length = path.length();
                                                           /* nameMatch */
/*---------------------------------------------------------------------------*/

      return true; /* our namelist is empty for the time being */

    }
/*end of nameMatch*/


  static
  void
  namesNotFound()
/*****************************************************************************/
/* Function name: namesNotFound                                              */
/* File name: Names.java                                                     */
/* Purpose: to print the names of things in the namelist                     */
/*          that were not matched                                            */
/* Parameters:                                                               */
/* Returns:                                                                  */
/* Last modified: 12.12.98                                                   */
/* Author of the Java translation: Victor Klimov, 1998                       */
/*****************************************************************************/
    {
                                                       /* namesNotFound */
/*---------------------------------------------------------------------------*/

      /* no namelist yet */

    }
/*end of namesNotFound*/

} /*end of Names */

/*****************************************************************************/
/* End of file: Names.java                                                   */
/*****************************************************************************/
