/*****************************************************************************/
/* File name: TarRegularOutputStream.java                                    */
/* Purpose: output stream to write a regular tar file                        */
/*                                                                           */
/* Last modified: 07.05.99                                                   */
/* Author: Victor Klimov, 1999                                               */
/* For the list of authors and contributors of the original C version        */
/* of the GNU tar see files AUTHORS and THANKS                               */
/*                                                                           */
/* This program is distributed in the hope that it will be useful, but       */
/* WITHOUT ANY WARRANTY; without even the implied warranty of                */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General */
/* Public License for more details.                                          */
/*                                                                           */
/* This software is distributed under the terms                              */
/* of the GNU General Public License as published                            */
/* by the Free Software Foundation; either version 2, or (at your option)    */
/* any later version.                                                        */
/* See file COPYING for your rights (GNU GPL)                                */
/*****************************************************************************/

package io;

import java.io.*;


public
class
TarRegularOutputStream
                              extends    FileOutputStream

                              implements TarWritable
{
  private final static String RCSID = "$Header: /d/JTAR12/io/RCS/TarRegularOutputStream.java,v 1.1 1999/05/09 22:23:47 vklimov Exp $";

  public
  TarRegularOutputStream( File file ) throws java.io.IOException
/*****************************************************************************/
/* Function name: TarRegularOutputStream                                     */
/* File name: TarRegularOutputStream.java                                    */
/* Purpose: constructor object to provide resources to write to a generic tar*/
/* Parameters: file                                                          */
/* Returns:                                                                  */
/* Last modified: 07.05.99                                                   */
/* Author: Victor Klimov, 1999                                               */
/*****************************************************************************/
    {
                                                /* TarRegularOutputStream */
/*---------------------------------------------------------------------------*/

      super( file );

    }
/*end of TarRegularOutputStream*/

} /*end of TarRegularOutputStream*/

/*****************************************************************************/
/* End of file: TarRegularOutputStream.java                                  */
/*****************************************************************************/
