/*****************************************************************************/
/* File name: TarReadable.java                                               */
/* Purpose: interface to read archive files:                                 */
/*          regular tars and gzipped tars                                    */
/* Last modified: 09.07.99                                                   */
/* Author: Victor Klimov, 1999                                               */
/* For the list of authors and contributors of the original C version        */
/* of the GNU tar see files AUTHORS and THANKS                               */
/*                                                                           */
/* This program is distributed in the hope that it will be useful, but       */
/* WITHOUT ANY WARRANTY; without even the implied warranty of                */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General */
/* Public License for more details.                                          */
/*                                                                           */
/* This software is distributed under the terms                              */
/* of the GNU General Public License as published                            */
/* by the Free Software Foundation; either version 2, or (at your option)    */
/* any later version.                                                        */
/* See file COPYING for your rights (GNU GPL)                                */
/*****************************************************************************/

package io;


import java.io.*;


public
interface

TarReadable
{

  /* $Header: /d/JTAR12/io/RCS/TarReadable.java,v 1.2 1999/07/09 23:47:34 vklimov Exp $ */


  public
  int
  read() throws java.io.IOException;
;

                
  public
  int
  read( byte b[] ) throws java.io.IOException;
;

   
  public
  int
  read( byte b[],
        int off,
        int len) throws java.io.IOException;
;

                
  public
  long
  skip( long n ) throws java.io.IOException;
;

   

  public
  int
  available() throws java.io.IOException;
;

                
  public
  void
  close() throws java.io.IOException;

   
  public
  void
  mark( int readlimit );

   
  public
  void
  reset() throws java.io.IOException;
;

   
  public
  boolean
  markSupported();

   
}
/*end of TarReadable*/

/*****************************************************************************/
/* End of file: TarReadable.java                                             */
/*****************************************************************************/
