/*****************************************************************************/
/* File name: Remove.java                                                    */
/* Purpose: to implement Remove methods                                      */
/* Last modified: 12.12.98                                                   */
/* Author: Victor Klimov, 1998                                               */
/*                                                                           */
/* This program is distributed in the hope that it will be useful, but       */
/* WITHOUT ANY WARRANTY; without even the implied warranty of                */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General */
/* Public License for more details.                                          */
/*                                                                           */
/* This software is distributed under the terms                              */
/* of the GNU General Public License as published                            */
/* by the Free Software Foundation; either version 2, or (at your option)    */
/* any later version.                                                        */
/* See file COPYING for your rights (GNU GPL)                                */
/*****************************************************************************/


package io;

import java.io.*;

public
class

Remove

{

  private final static String RCSID = "$Header: /d/JTAR03/io/RCS/Remove.java,v 1.2 1998/12/13 17:19:08 vklimov Exp $";


  public
  Remove()
/*****************************************************************************/
/* Function name: Remove                                                     */
/* File name: Remove.java                                                    */
/* Purpose: constructor for the Remove object                                */
/* Parameters:                                                               */
/* Returns:                                                                  */
/* Last modified: 27.10.98                                                   */
/* Author: Victor Klimov, 1998                                               */
/*****************************************************************************/
    {
                                                         /* Remove */
/*---------------------------------------------------------------------------*/

    }
/*end of Remove*/



  public
  static
  boolean
  removeAnyFile( String path, boolean recursive )
/*****************************************************************************/
/* Function name: removeAnyFile                                              */
/* File name: Remove.java                                                    */
/* Purpose: to delete path, whatever it might be                             */
/* Parameters: path - file to delete                                         */
/*             recursive - if true, first recursively delete the contents    */
/*                         of path when it is a directory                    */
/* Returns: true - if everything is all right                                */
/*          false - otherwise                                                */
/* Last modified: 12.12.98                                                   */
/* Author of the Java translation: Victor Klimov, 1998                       */
/*****************************************************************************/
    {
      File pathFileObject;
      boolean thisIsADirectory;
      boolean removedOK;
      String[] filesSubdirsElementsOfTheDirectory;
      int i;
      int nFiles;
                                                    /* removeAnyFile */
/*---------------------------------------------------------------------------*/

      try
        {
          pathFileObject = new File( path );
          thisIsADirectory = pathFileObject.isDirectory();

          if (thisIsADirectory)
            {
              if (recursive)
                {
                  filesSubdirsElementsOfTheDirectory =
                    pathFileObject.list();

                  nFiles = filesSubdirsElementsOfTheDirectory.
                    length;

                  for ( i=0; i < nFiles; i++ )
                    {
                      removedOK =
                        removeAnyFile(
                          filesSubdirsElementsOfTheDirectory[ i ],
                          recursive                                );

                      if ( ! removedOK )
                        {
                          return false;                       /* return ! */
                        }
                      else
                        ;
                    /*end of if on removedOK*/

                    }
                /*end of for-loop on files*/

                  return pathFileObject.delete();             /* return ! */
                }
              else /* not recursive, regular delete a directory */
                {
                  return pathFileObject.delete();                /* return ! */
                }
            /*end of if on recursive*/
            }
          else /* regular file */
            {
              return pathFileObject.delete();                /* return ! */
            }
        /*end of if on thisIsADirectory*/

        }
      catch( NullPointerException e )
        {
          return false;                                /* return ! */
        }
      catch( SecurityException e )
        {
          return false;                                /* return ! */
        }
    /*end of try-catch on File*/

    }
/*end of removeAnyFile*/


  public
  static
  void

  main( String[] args )
/*****************************************************************************/
/* Function name: main                                                       */
/* File name: Remove.java                                                    */
/* Purpose: to test the Remove class                                         */
/* Parameters:                                                               */
/* Returns:                                                                  */
/* Last modified: 27.10.98                                                   */
/* Author: Victor Klimov, 1998                                               */
/*****************************************************************************/
    {
                                                         /* main */
/*---------------------------------------------------------------------------*/


    }
/*end of main*/

} /*end of class Remove */

/*****************************************************************************/
/* End of file: Remove.java                                                  */
/*****************************************************************************/

