/*****************************************************************************/
/* File name: RamFileVector.java                                             */
/* Purpose: a vector of RamFile objects                                      */
/*                                                                           */
/* Last modified: 20.05.99                                                   */
/* Author: Victor Klimov, 1999                                               */
/* For the list of authors and contributors of the original C version        */
/* of the GNU tar see files AUTHORS and THANKS                               */
/*                                                                           */
/* This program is distributed in the hope that it will be useful, but       */
/* WITHOUT ANY WARRANTY; without even the implied warranty of                */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General */
/* Public License for more details.                                          */
/*                                                                           */
/* This software is distributed under the terms                              */
/* of the GNU General Public License as published                            */
/* by the Free Software Foundation; either version 2, or (at your option)    */
/* any later version.                                                        */
/* See file COPYING for your rights (GNU GPL)                                */
/*****************************************************************************/

package io;

import java.io.*;
import java.util.*;
import util.*;


public
class

RamFileVector

                       extends Vector

{

  private final static java.lang.String RCSID = "$Header: /d/JTAR12/io/RCS/RamFileVector.java,v 1.2 1999/05/21 02:10:49 vklimov Exp $";


  public
  RamFileVector()
/*****************************************************************************/
/* Function name: RamFileVector                                              */
/* File name: RamFileVector.java                                             */
/* Purpose: constructor for the RamFileVector class                          */
/* Parameters:                                                               */
/* Returns:                                                                  */
/* Last modified: 11.05.99                                                   */
/* Author: Victor Klimov, 1999                                               */
/*****************************************************************************/
    {
                                                       /* RamFileVector */
/*---------------------------------------------------------------------------*/

      super();

    }
/*end of RamFileVector*/



  public
  int

  indexOfAName( java.lang.String name )
/*****************************************************************************/
/* Function name: indexOfAName                                               */
/* File name: RamFileVector.java                                             */
/* Purpose: to return the number of an element in this RamFileVector object  */
/*          that has the given name. Only the first order elements           */
/*          are looked at                                                    */
/* Parameters: name                                                          */
/* Returns: the number of the element or                                     */
/*          general.Constants.JAVA_ERROR_CODE if there is no such element    */
/* Last modified: 20.05.99                                                   */
/* Author: Victor Klimov, 1999                                               */
/*****************************************************************************/
    {
      int i = 0;
      RamFile element = null;
                                                         /* indexOfAName */
/*---------------------------------------------------------------------------*/

      while( i < elementCount )
        {
          element = (RamFile) elementAt( i );

          if (element.name.equals( name ))
            return i;                                       /* return ! */
          else
            i++;
        /*end of if*/
        }
    /*end of while-loop*/

      return general.Constants.JAVA_ERROR_CODE;

     }
/*end of indexOfAName*/

} /*end of RamFileVector */

/*****************************************************************************/
/* End of file: RamFileVector.java                                           */
/*****************************************************************************/
