/*****************************************************************************/
/* File name: PosByteArrayInputStream.java                                   */
/* Purpose: to implement a ByteArrayInputStream with accessible pos          */
/* Last modified: 19.11.98                                                   */
/* Author: Victor Klimov, 1998                                               */
/*                                                                           */
/* This program is distributed in the hope that it will be useful, but       */
/* WITHOUT ANY WARRANTY; without even the implied warranty of                */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General */
/* Public License for more details.                                          */
/*                                                                           */
/* This software is distributed under the terms                              */
/* of the GNU General Public License as published                            */
/* by the Free Software Foundation; either version 2, or (at your option)    */
/* any later version.                                                        */
/* See file COPYING for your rights (GNU GPL)                                */
/*****************************************************************************/


package io;

import java.io.*;

public
class

PosByteArrayInputStream

                extends ByteArrayInputStream

{

  private final static String RCSID = "$Header: /d/JTAR03/io/RCS/PosByteArrayInputStream.java,v 1.3 1998/11/23 00:07:50 root Exp $";


  public
  PosByteArrayInputStream( byte byteArray[] )
/*****************************************************************************/
/* Function name: PosByteArrayInputStream                                    */
/* File name: PosByteArrayInputStream.java                                   */
/* Purpose: constructor for the PosByteArrayInputStream object               */
/* Parameters: byteArray                                                     */
/* Returns:                                                                  */
/* Last modified: 27.09.98                                                   */
/* Author: Victor Klimov, 1998                                               */
/*****************************************************************************/
    {
                                           /* PosByteArrayInputStream */
/*---------------------------------------------------------------------------*/

      super( byteArray );

    }
/*end of PosByteArrayInputStream*/


  public
  PosByteArrayInputStream( byte byteArray[],
                           int offset,
                           int length        )
/*****************************************************************************/
/* Function name: PosByteArrayInputStream                                    */
/* File name: PosByteArrayInputStream.java                                   */
/* Purpose: constructor for the PosByteArrayInputStream object               */
/* Parameters: byteArray                                                     */
/*             offset                                                        */
/*             length                                                        */
/* Returns:                                                                  */
/* Last modified: 27.09.98                                                   */
/* Author: Victor Klimov, 1998                                               */
/*****************************************************************************/
    {
                                           /* PosByteArrayInputStream */
/*---------------------------------------------------------------------------*/

      super( byteArray,
             offset,
             length      );

    }
/*end of PosByteArrayInputStream*/


  public
  int
  pos()
/*****************************************************************************/
/* Function name: pos                                                        */
/* File name: PosByteArrayInputStream.java                                   */
/* Purpose: to return the current pos (position) value                       */
/* Parameters:                                                               */
/* Returns: pos                                                              */
/* Last modified: 29.09.98                                                   */
/* Author: Victor Klimov, 1998                                               */
/*****************************************************************************/
    {
                                                          /* pos */
/*---------------------------------------------------------------------------*/

      return pos;

    }
/*end of pos*/


  public
  int
  count()
/*****************************************************************************/
/* Function name: count                                                      */
/* File name: PosByteArrayInputStream.java                                   */
/* Purpose: to return the count value - index one greater than               */
/*          the last valid character in the stream buffer                    */
/* Parameters:                                                               */
/* Returns: count                                                            */
/* Last modified: 19.11.98                                                   */
/* Author: Victor Klimov, 1998                                               */
/*****************************************************************************/
    {
                                                          /* count */
/*---------------------------------------------------------------------------*/

      return count;

    }
/*end of count*/


  public
  static
  void

  main( String[] args )
/*****************************************************************************/
/* Function name: main                                                       */
/* File name: PosByteArrayInputStream.java                                   */
/* Purpose: to test the PosByteArrayInputStream class                        */
/* Parameters:                                                               */
/* Returns:                                                                  */
/* Last modified: 27.09.98                                                   */
/* Author: Victor Klimov, 1998                                               */
/*****************************************************************************/
    {
                                                         /* main */
/*---------------------------------------------------------------------------*/


    }
/*end of main*/

} /*end of class PosByteArrayInputStream */

/*****************************************************************************/
/* End of file: PosByteArrayInputStream.java                                 */
/*****************************************************************************/

