/*****************************************************************************/
/* File name: Filable.java                                                   */
/* Purpose: interface to access directories and files                        */
/*                                                                           */
/* Last modified: 15.05.99                                                   */
/* Author: Victor Klimov, 1999                                               */
/* For the list of authors and contributors of the original C version        */
/* of the GNU tar see files AUTHORS and THANKS                               */
/*                                                                           */
/* This program is distributed in the hope that it will be useful, but       */
/* WITHOUT ANY WARRANTY; without even the implied warranty of                */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General */
/* Public License for more details.                                          */
/*                                                                           */
/* This software is distributed under the terms                              */
/* of the GNU General Public License as published                            */
/* by the Free Software Foundation; either version 2, or (at your option)    */
/* any later version.                                                        */
/* See file COPYING for your rights (GNU GPL)                                */
/*****************************************************************************/

package io;


public
interface

Filable
{

  /* $Header: /d/JTAR12/io/RCS/Filable.java,v 1.2 1999/05/18 19:51:13 vklimov Exp $ */

  public final static int THIS_IS_UNKNOWN_TYPE   = 0;
  public final static int THIS_IS_A_REGULAR_FILE = 1;
  public final static int THIS_IS_A_DIRECTORY    = 2;


  public
  boolean
  exists();

  public
  java.lang.String
  getPath();

  public
  java.lang.String
  getParent();

  public
  java.lang.String
  getName();

  public
  java.lang.String
  getCanonicalPath()  throws java.io.IOException;

  public
  boolean
  isDirectory();

  public
  boolean
  isFile();

  public
  long
  lastModified();

  public
  long
  length();

  public
  java.lang.String[]
  list();

} /*end of Filable */

/*****************************************************************************/
/* End of file: Filable.java                                                 */
/*****************************************************************************/
