/*****************************************************************************/
/* File name: ByteFixedArrayOutputStream.java                                */
/* Purpose: to implement a ByteArrayOutputStream with fixed length array     */
/* Last modified: 19.12.98                                                   */
/* Author: Victor Klimov, 1998                                               */
/*                                                                           */
/* This program is distributed in the hope that it will be useful, but       */
/* WITHOUT ANY WARRANTY; without even the implied warranty of                */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General */
/* Public License for more details.                                          */
/*                                                                           */
/* This software is distributed under the terms                              */
/* of the GNU General Public License as published                            */
/* by the Free Software Foundation; either version 2, or (at your option)    */
/* any later version.                                                        */
/* See file COPYING for your rights (GNU GPL)                                */
/*****************************************************************************/


package io;

import java.io.*;


public
class

ByteFixedArrayOutputStream

                extends ByteArrayOutputStream

{

  private final static String RCSID = "$Header: /d/JTAR10/io/RCS/ByteFixedArrayOutputStream.java,v 1.2 1998/12/20 03:43:24 vklimov Exp $";

  private int length = 0;


  public
  ByteFixedArrayOutputStream( int size )
/*****************************************************************************/
/* Function name: ByteFixedArrayOutputStream                                 */
/* File name: ByteFixedArrayOutputStream.java                                */
/* Purpose: constructor for the ByteFixedArrayOutputStream object            */
/* Parameters: size - number of bytes in the internal buffer                 */
/* Returns:                                                                  */
/* Last modified: 02.12.98                                                   */
/* Author: Victor Klimov, 1998                                               */
/*****************************************************************************/
    {
                                           /* ByteFixedArrayOutputStream */
/*---------------------------------------------------------------------------*/

      super( size );
      this.length = size;

    }
/*end of ByteFixedArrayOutputStream*/


  public
  byte[]
  buffer()
/*****************************************************************************/
/* Function name: buffer                                                     */
/* File name: ByteFixedArrayOutputStream.java                                */
/* Purpose: returns the internal byte array buffer that contains the data    */
/*          written to here                                                  */
/* Parameters:                                                               */
/* Returns: the buffer byte array                                            */
/* Last modified: 19.12.98                                                   */
/* Author: Victor Klimov, 1998                                               */
/*****************************************************************************/
    {
                                                          /* buffer */
/*---------------------------------------------------------------------------*/

      return this.buf;

    }
/*end of buffer*/


  public
  int
  numberOfBytesInTheBuffer()
/*****************************************************************************/
/* Function name: numberOfBytesInTheBuffer                                   */
/* File name: ByteFixedArrayOutputStream.java                                */
/* Purpose: returns number of valid bytes in the internal buffer             */
/* Parameters:                                                               */
/* Returns: number of bytes in the buffer                                    */
/* Last modified: 19.12.98                                                   */
/* Author: Victor Klimov, 1998                                               */
/*****************************************************************************/
    {
                                            /* numberOfBytesInTheBuffer */
/*---------------------------------------------------------------------------*/

      return this.count;

    }
/*end of numberOfBytesInTheBuffer*/



  public
  void
  writeF( byte b[],
          int  offset,
          int  length  ) throws BufferFullException
/*****************************************************************************/
/* Function name: writeF                                                     */
/* File name: ByteFixedArrayOutputStream.java                                */
/* Purpose: to write some bytes from a byte array into the stream            */
/*          If internal buffer is filled up then the number of bytes         */
/*          written into the buffer could be less than length parameter      */
/*          Throws BufferFullException when the buffer is filled up          */
/* Parameters: b - byte array to write from                                  */
/*             offset - the place in the b, from which to begin to write     */
/*             length - number of bytes to write                             */
/* Returns:                                                                  */
/* Last modified: 02.12.98                                                   */
/* Author: Victor Klimov, 1998                                               */
/*****************************************************************************/
    {
      int nBytesToWrite = 0;
                                                          /* writeF */
/*---------------------------------------------------------------------------*/

      if (this.length >= length + count)
        super.write( b, offset, length );
      else
        {
          nBytesToWrite =
            this.length - count;
          super.write( b, offset, nBytesToWrite );
          throw new BufferFullException(
                      this.length, 
                      nBytesToWrite,
                      "ByteFixedArrayOutputStream.buf" );
        }
    /*end of if on size*/

    }
/*end of writeF*/


  public
  void
  writeF( int b ) throws BufferFullException
/*****************************************************************************/
/* Function name: writeF                                                     */
/* File name: ByteFixedArrayOutputStream.java                                */
/* Purpose: to write a byte into the stream                                  */
/*          If internal buffer is filled up then the byte is not written     */
/*          into the buffer and BufferFullException will be thrown           */
/* Parameters: b - byte to be written                                        */
/* Returns:                                                                  */
/* Last modified: 02.12.98                                                   */
/* Author: Victor Klimov, 1998                                               */
/*****************************************************************************/
    {
                                                          /* writeF */
/*---------------------------------------------------------------------------*/

      if (this.length >= 1 + count)
        super.write( b );
      else
        {
          throw new BufferFullException(
                      this.length, 0,
                      "ByteFixedArrayOutputStream.buf" );
        }
    /*end of if on size*/

    }
/*end of writeF*/


  public
  int
  numberAvailableBytes()
/*****************************************************************************/
/* Function name: numberAvailableBytes                                       */
/* File name: ByteFixedArrayOutputStream.java                                */
/* Purpose: returns number of bytes left free to be written to in the stream */
/* Parameters:                                                               */
/* Returns: number of bytes                                                  */
/* Last modified: 04.12.98                                                   */
/* Author: Victor Klimov, 1998                                               */
/*****************************************************************************/
    {
                                                 /* numberAvailableBytes */
/*---------------------------------------------------------------------------*/

      return length - count;

    }
/*end of numberAvailableBytes*/



  public
  static
  void

  main( String[] args )
/*****************************************************************************/
/* Function name: main                                                       */
/* File name: ByteFixedArrayOutputStream.java                                */
/* Purpose: to test the ByteFixedArrayOutputStream class                     */
/* Parameters:                                                               */
/* Returns:                                                                  */
/* Last modified: 27.09.98                                                   */
/* Author: Victor Klimov, 1998                                               */
/*****************************************************************************/
    {
                                                         /* main */
/*---------------------------------------------------------------------------*/

    }
/*end of main*/


} /*end of class ByteFixedArrayOutputStream */

/*****************************************************************************/
/* End of file: ByteFixedArrayOutputStream.java                              */
/*****************************************************************************/

