/*****************************************************************************/
/* File name: BufferFullException.java                                       */
/* Purpose: to implement BufferFullException                                 */
/* Last modified: 02.12.98                                                   */
/* Author: Victor Klimov, 1998                                               */
/*                                                                           */
/* This program is distributed in the hope that it will be useful, but       */
/* WITHOUT ANY WARRANTY; without even the implied warranty of                */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General */
/* Public License for more details.                                          */
/*                                                                           */
/* This software is distributed under the terms                              */
/* of the GNU General Public License as published                            */
/* by the Free Software Foundation; either version 2, or (at your option)    */
/* any later version.                                                        */
/* See file COPYING for your rights (GNU GPL)                                */
/*****************************************************************************/


package io;


public
class

BufferFullException

            extends Exception
{

  private final static String RCSID = "$Header: /d/JTAR03/io/RCS/BufferFullException.java,v 1.1 1998/12/10 21:36:13 root Exp $";

  private int size = 0;
  private int nProcessedBytes = 0;
  private String name = null;


  public
  BufferFullException( int size,
                       int nProcessedBytes,
                       String name           )
/*****************************************************************************/
/* Function name: BufferFullException                                        */
/* File name: BufferFullException.java                                       */
/* Purpose: constructor for the BufferFullException object                   */
/* Parameters: size of the buffer                                            */
/*             nProcessedBytes - number of bytes that were processed OK      */
/*                               before the exception was thrown             */
/*             name of the buffer array                                      */
/* Returns:                                                                  */
/* Last modified: 02.12.98                                                   */
/* Author: Victor Klimov, 1998                                               */
/*****************************************************************************/
    {
                                                /* BufferFullException */
/*---------------------------------------------------------------------------*/

      this.size = size;
      this.name = name;
      this.nProcessedBytes = nProcessedBytes;
    }
/*end of BufferFullException*/



  public
  String

  getMessage()
/*****************************************************************************/
/* Function name: BufferFullException                                        */
/* File name: BufferFullException.java                                       */
/* Purpose: constructor for the BufferFullException object                   */
/* Parameters: size of the buffer                                            */
/*             name of the buffer array                                      */
/* Returns:                                                                  */
/* Last modified: 02.12.98                                                   */
/* Author: Victor Klimov, 1998                                               */
/*****************************************************************************/
    {
                                                         /* getMessage */
/*---------------------------------------------------------------------------*/

      return "Buffer " + name + " is full (size=" + size + " bytes).";
    }
/*end of getMessage*/


  public
  int

  size()
/*****************************************************************************/
/* Function name: size                                                       */
/* File name: BufferFullException.java                                       */
/* Purpose: returns size of the buffer                                       */
/* Parameters:                                                               */
/* Returns: size                                                             */
/* Last modified: 02.12.98                                                   */
/* Author: Victor Klimov, 1998                                               */
/*****************************************************************************/
    {
                                                         /* size */
/*---------------------------------------------------------------------------*/

      return size;
    }
/*end of size*/


  public
  int

  processedBytesNumber()
/*****************************************************************************/
/* Function name: processedBytesNumber                                       */
/* File name: BufferFullException.java                                       */
/* Purpose: returns number of bytes processed                                */
/* Parameters:                                                               */
/* Returns: number of bytes processed                                        */
/* Last modified: 02.12.98                                                   */
/* Author: Victor Klimov, 1998                                               */
/*****************************************************************************/
    {
                                                  /* processedBytesNumber */
/*---------------------------------------------------------------------------*/

      return nProcessedBytes;
    }
/*end of processedBytesNumber*/

}
/*end of BufferFullException class*/

/*****************************************************************************/
/* End of file: BufferFullException.java                                     */
/*****************************************************************************/
