/*****************************************************************************/
/* File name: QuoteString.java                                               */
/* Purpose: additional things to work on strings                             */
/* Last modified: 12.12.98                                                   */
/* Author: Victor Klimov, 1998                                               */
/*                                                                           */
/* This program is distributed in the hope that it will be useful, but       */
/* WITHOUT ANY WARRANTY; without even the implied warranty of                */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General */
/* Public License for more details.                                          */
/*                                                                           */
/* This software is distributed under the terms                              */
/* of the GNU General Public License as published                            */
/* by the Free Software Foundation; either version 2, or (at your option)    */
/* any later version.                                                        */
/* See file COPYING for your rights (GNU GPL)                                */
/*****************************************************************************/

package util;


final

public
class

QuoteString

{

  private final static java.lang.String RCSID = "$Header: /d/JTAR03/util/RCS/QuoteString.java,v 1.4 1998/12/13 17:19:21 vklimov Exp $";


  QuoteString( )
/*****************************************************************************/
/* Function name: QuoteString                                                */
/* File name: QuoteString.java                                               */
/* Purpose: constructor for the object QuoteString                           */
/* Parameters:                                                               */
/* Returns:                                                                  */
/* Last modified: 03.10.98                                                   */
/* Author: Victor Klimov, 1998                                               */
/*****************************************************************************/
    {
                                                       /* QuoteString */
/*---------------------------------------------------------------------------*/

    }
/*end of QuoteString*/


  public
  static
  java.lang.String
  unquoteString( java.lang.String inString )
/*****************************************************************************/
/* Function name: unquoteString                                              */
/* File name: QuoteString.java                                               */
/* Purpose: to convert a quoted C string (like those produced by             */
/*          quoteCopyString) back into the un-quoted original                */
/* Parameters: inString                                                      */
/* Returns: the unquoted string                                              */
/* Last modified: 12.12.98                                                   */
/* Author of the Java translation: Victor Klimov, 1998                       */
/*****************************************************************************/
    {
      int inStringLength;
      int value;
      int i;
      char character;
      char characterNext;
      StringBuffer buffer = null;
                                                   /* unquoteString */
/*---------------------------------------------------------------------------*/

      inStringLength = inString.length();

      buffer = new StringBuffer();

      i = 0;
      while (i<inStringLength-1)
        {
          character = inString.charAt(i);
          characterNext = inString.charAt(i+1);

          if (character == '\\')
            {
              switch( characterNext )
                {

                case '\\':
                  buffer.append( '\\' );
                  break;

                case 'n':
                  buffer.append( '\n' );
                  break;

                case 't':
                  buffer.append( '\t' );
                  break;

                case 'f':
                  buffer.append( '\f' );
                  break;

                case 'b':
                  buffer.append( '\b' );
                  break;

                case 'r':
                  buffer.append( '\r' );
                  break;

                case '?':
                  buffer.append( (char) 127 );
                  break;

                case '0':
                case '1':
                case '2':
                case '3':
                case '4':
                case '5':
                case '6':
                case '7':
                  {
                    value = (int) characterNext - (int) '0';

                    ++i;
                    if ( ++i < inStringLength )
                      {
                        character = inString.charAt(i);

                        if (character < '0' || character > '7')
                          {
                            buffer.append( (char) value );

                            i--;
                            i--;
                            break;                               /* break ! */
                          }
                        else
                          ;
                      /*end of if on not an octal digit*/

                        value = value * 8 + character - '0';

                        if (++i<inStringLength)
                          {
                            character = inString.charAt(i);

                            if (character < '0' || character > '7')
                              {
                                buffer.append( (char) value );

                                i--;
                                i--;
                                break;                            /* break ! */
                              }
                            else
                              ;
                          /*end of if on not an octal digit*/

                            value = value * 8 + character - '0';
                            i++;

                          }
                        else /* no more chars */
                          ;
                      /*end of if on end of the string*/
                      }
                    else /* no more chars */
                      ;
                  /*end of if on i*/

                    buffer.append( (char) value );

                    i--;
                    i--;
                    break;                             /* break ! */
                  }
              /*cases of an octal digit*/

                default:
                  buffer.append( character );
                  break;

                }
            /*end of switch on character*/

              i++;

            }
          else /* other than a backslash char */
            {
              buffer.append( character );

              if (i==inStringLength-2)
                {
                  buffer.append( characterNext );
                }
              else
                ;
            /*end of if on i*/

            }
        /*end of if on '\\'*/

          i++;

        }
    /*end of for-loop*/

      return buffer.toString();

    }
/*end of unquoteString*/


  public
  static
  java.lang.String
  quoteCopyString( java.lang.String inString )
/*****************************************************************************/
/* Function name: quoteCopyString                                            */
/* File name: QuoteString.java                                               */
/* Purpose: to create a copy of the string quoted as in C.                   */
/*          This is used in two contexts only: either listing a tar file     */
/*          for the --list (-t) option, or generating the directory file     */
/*          in incremental dumps.                                            */
/* Parameters: inString                                                      */
/* Returns: the quoted string                                                */
/* Last modified: 12.12.98                                                   */
/* Author of the Java translation: Victor Klimov, 1998                       */
/*****************************************************************************/
    {
      int length;
      int inStringLength;
      int i;
      char character;
      Character Char;
      StringBuffer buffer = null;
                                                   /* quoteCopyString */
/*---------------------------------------------------------------------------*/

      inStringLength = inString.length();

      buffer = new StringBuffer();

      for (i=0; i<inStringLength; i++)
        {
          character = inString.charAt(i);

          Char = new Character( character );

          if (character == '\\')
            {
              buffer.append( '\\' );
              buffer.append( '\\' );
            }
          else /* other than a backslash char */
            {
            if ( !Char.isISOControl( character ) ) /* regular char */
              {
                buffer.append( character );
              }
            else /* control character */
              {
                if (character == 0)
                  return buffer.toString();             /* return ! */
                else
                  buffer.append( '\\' );
              /*end of if on 0*/

                switch (character)
                  {

                  case '\n':
                    buffer.append( 'n' );
                    break;

                  case '\t':
                    buffer.append( 't' );
                    break;

                  case '\f':
                    buffer.append( 'f' );
                    break;

                  case '\b':
                    buffer.append( 'b' );
                    break;

                  case '\r':
                    buffer.append( 'r' );
                    break;

                  default:
                    buffer.append( '?' );
                    break;

                  }
              /*end of switch on character*/
              }
          /*end of if on control character*/
            }
        /*end of if on '\\'*/
        }
    /*end of for-loop*/

      return buffer.toString();

    }
/*end of quoteCopyString*/


  public
  static
  void

  main( java.lang.String[] args )
/*****************************************************************************/
/* Function name: main                                                       */
/* File name: QuoteString.java                                               */
/* Purpose: to test the QuoteString class                                    */
/* Parameters:                                                               */
/* Returns:                                                                  */
/* Last modified: 12.12.98                                                   */
/* Author: Victor Klimov, 1998                                               */
/*****************************************************************************/
    {
      java.lang.String quotedString;
      java.lang.String inString;
      java.lang.String stringToUnquote;
      java.lang.String unquotedString;
                                                         /* main */
/*---------------------------------------------------------------------------*/

      inString = "abcd\'\n\t\f\b\ref";
      System.out.println( "inString.length()=" + inString.length() );
      System.out.println( "" );
      System.out.println( "" );
      System.out.println( "inString=" + inString );

      quotedString =
        quoteCopyString( inString );
      System.out.println( "quotedString = " +
                          quotedString );

      unquotedString =
        unquoteString( quotedString );
      System.out.println( "\nunquotedString = " +
                          unquotedString );


      stringToUnquote = "\\0\\00\\127\\7\\57\\157\\020";
      unquotedString =
        unquoteString( stringToUnquote );
      System.out.println( "\nunquotedString = " +
                          unquotedString );

    }
/*end of main*/

} /*end of QuoteString */

/*****************************************************************************/
/* End of file: QuoteString.java                                             */
/*****************************************************************************/
