/*****************************************************************************/
/* File name: Sparse.java                                                    */
/* Purpose: descriptor object for a single file hole                         */
/* Last modified: 03.05.99                                                   */
/* Author: Victor Klimov, 1999                                               */
/*                                                                           */
/* This program is distributed in the hope that it will be useful, but       */
/* WITHOUT ANY WARRANTY; without even the implied warranty of                */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General */
/* Public License for more details.                                          */
/*                                                                           */
/* This software is distributed under the terms                              */
/* of the GNU General Public License as published                            */
/* by the Free Software Foundation; either version 2, or (at your option)    */
/* any later version.                                                        */
/* See file COPYING for your rights (GNU GPL)                                */
/*****************************************************************************/

package jtar;

import util.*;
import general.*;

final

class

Sparse

     implements jtar.Constants, general.Constants

{

  private final static java.lang.String RCSID = "$Header: /d/JTAR12/jtar/RCS/Sparse.java,v 1.4 1999/05/04 17:01:09 vklimov Exp $";


                                /* byte offset */
  byte[] offset;                  /*   0 */
  byte[] numbytes;                /*  12 */
  
  Sparse( )
/*****************************************************************************/
/* Function name: Sparse                                                     */
/* File name: Sparse.java                                                    */
/* Purpose: constructor for the object Sparse                                */
/* Parameters:                                                               */
/* Returns:                                                                  */
/* Last modified: 04.10.98                                                   */
/* Author: Victor Klimov, 1998                                               */
/*****************************************************************************/
    {
                                                            /* Sparse */
/*---------------------------------------------------------------------------*/

                                                          /* byte offset */
      offset = new
        byte[ SPARSE_DESCRIPTOR_FIELD_LENGTH_OFFSET ];            /*   0 */
      numbytes = new                                              /*  12 */
         byte[ SPARSE_DESCRIPTOR_FIELD_LENGTH_NUMBYTES ];
                                                                  /*  24 */
      util.Array.bytefill( offset, general.Constants.NULL_BYTE );
      util.Array.bytefill( numbytes, general.Constants.NULL_BYTE );
    }
/*end of Sparse*/


  void
  write( io.ByteFixedArrayOutputStream byteArrayStream )
/*****************************************************************************/
/* Function name: write                                                      */
/* File name: Sparse.java                                                    */
/* Purpose: to write a sparce object to a fixed length byte array output     */
/*          stream                                                           */
/* Parameters: byteArrayStream                                               */
/* Returns:                                                                  */
/* Last modified: 03.05.99                                                   */
/* Author: Victor Klimov, 1999                                               */
/*****************************************************************************/
    {
                                                            /* write */
/*---------------------------------------------------------------------------*/

      try
        {
          byteArrayStream.writeF(
            offset, 0,
            SPARSE_DESCRIPTOR_FIELD_LENGTH_OFFSET );
          byteArrayStream.writeF(
            numbytes, 0,
            SPARSE_DESCRIPTOR_FIELD_LENGTH_NUMBYTES );
        }
      catch( io.BufferFullException e )
        {
          util.Error.warn(
            e.getMessage()    );
        }
    /*end of try-catch*/

    }
/*end of write*/


} /*end of Sparse */

/*****************************************************************************/
/* End of file: Sparse.java                                                  */
/*****************************************************************************/
