/*****************************************************************************/
/* File name: QuitButton.java                                                */
/* Purpose: to provide a button to quit the application                      */
/*                                                                           */
/* Last modified: 03.05.99                                                   */
/* Author: Victor Klimov, 1999                                               */
/* For the list of authors and contributors of the original C version        */
/* of the GNU tar see files AUTHORS and THANKS                               */
/*                                                                           */
/* This program is distributed in the hope that it will be useful, but       */
/* WITHOUT ANY WARRANTY; without even the implied warranty of                */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General */
/* Public License for more details.                                          */
/*                                                                           */
/* This software is distributed under the terms                              */
/* of the GNU General Public License as published                            */
/* by the Free Software Foundation; either version 2, or (at your option)    */
/* any later version.                                                        */
/* See file COPYING for your rights (GNU GPL)                                */
/*****************************************************************************/

package jtar;


import java.awt.*;
import java.awt.event.*;
import general.*;
import io.*;


class

QuitButton extends Button

                           implements ActionListener

{

  private final static String RCSID = "$Header: /d/JTAR12/jtar/RCS/QuitButton.java,v 1.2 1999/05/04 17:01:10 vklimov Exp $";


  public
  QuitButton()
/*****************************************************************************/
/* Function name: QuitButton                                                 */
/* File name: QuitButton.java                                                */
/* Purpose: constructor to create the button                                 */
/* Parameters:                                                               */
/* Returns:                                                                  */
/* Last modified: 06.04.99                                                   */
/* Author: Victor Klimov, 1999                                               */
/*****************************************************************************/
    {
                                                           /* QuitButton */
/*---------------------------------------------------------------------------*/

      super();

    }
/*end of QuitButton*/


  public
  QuitButton( String label )
/*****************************************************************************/
/* Function name: QuitButton                                                 */
/* File name: QuitButton.java                                                */
/* Purpose: constructor to create the button                                 */
/* Parameters: label                                                         */
/* Returns:                                                                  */
/* Last modified: 06.04.99                                                   */
/* Author: Victor Klimov, 1999                                               */
/*****************************************************************************/
    {
                                                       /* QuitButton */
/*---------------------------------------------------------------------------*/

      super( label );

    }
/*end of QuitButton*/


  public
  void

  actionPerformed( ActionEvent event )
/*****************************************************************************/
/* Function name: actionPerformed                                            */
/* File name: QuitButton.java                                                */
/* Purpose: to process user initiated events                                 */
/* Parameters: event - incoming event object                                 */
/* Returns:                                                                  */
/* Last modified: 03.05.99                                                   */
/* Author: Victor Klimov, 1999                                               */
/*****************************************************************************/
    {
                                                         /* actionPerformed */
/*---------------------------------------------------------------------------*/

      System.exit( util.Error.exitCode );                    /* exit ! */

  } /* end of actionPerformed */

} /*end of QuitButton */

/*****************************************************************************/
/* End of file: QuitButton.java                                              */
/*****************************************************************************/
